/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.web.action;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import org.apache.logging.log4j.ThreadContext;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.AutopaymentMode;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.AbstractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.autopayment.server.bean.ContractAutopaymentManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.AutopaymentModeEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.PeriodWithTime;

public abstract class AbstractPaymentAction
extends AbstractAction {
    private Class<?> constantsClass = null;
    protected BigDecimal sum = BigDecimal.ZERO;
    protected BigDecimal sumMin = BigDecimal.ZERO;
    protected BigDecimal sumMax = null;
    protected String customerAddress = null;

    public AbstractPaymentAction(String module) {
        super(module);
        try {
            this.constantsClass = Class.forName("ru.bitel.bgbilling.modules." + module + ".server.bean.Constants");
        }
        catch (Exception ex) {
            this.getLogger().error("Constants class for module \"{}\" not found", (Object)module);
        }
    }

    @Override
    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws Exception {
        this.setResultParam("pageTitle", this.getPageTitle(1, this.moduleName, this.moduleId));
        this.setResultParam("jspPage", "include/payment.jsp");
        if (this.req.getBoolean("getBody", false)) {
            this.requestDispatcher(this.moduleName, "../include/payment");
        }
    }

    @WebOperation(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432")
    public void check() throws Exception {
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        this.checkModuleOnContract(this.moduleId, "\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        ThreadContext.put((String)"componentName", (String)this.moduleName);
        ThreadContext.put((String)"moduleId", (String)String.valueOf(this.moduleId));
        ThreadContext.put((String)"contractId", (String)String.valueOf(this.contractId));
        this.customerAddress = this.req.get("customerAddress");
        ContractUtils.saveCustomerAddress(this.con, this.moduleId, this.contractId, this.customerAddress);
        ContractUtils.saveCustomerAddress(this.con, 0, this.contractId, this.customerAddress);
    }

    protected BigDecimal payCheckSum() throws Exception {
        String prefixUpperCase = this.moduleName.toUpperCase();
        int defSumMin = (Integer)this.constantsClass.getDeclaredField(prefixUpperCase + "_SUM_MIN").get(null);
        int defSumMax = (Integer)this.constantsClass.getDeclaredField(prefixUpperCase + "_SUM_MAX").get(null);
        this.sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        this.sumMin = this.moduleSetup.getBigDecimal(this.moduleName + ".sum.min", new BigDecimal(defSumMin));
        this.sumMax = this.moduleSetup.getBigDecimal(this.moduleName + ".sum.max", new BigDecimal(defSumMax));
        if (this.sum.compareTo(BigDecimal.ZERO) <= 0 || this.sum.compareTo(this.sumMin) < 0 || this.sum.compareTo(this.sumMax) > 0) {
            String errorMessage = "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!";
            this.setResultParam("errorMessage", errorMessage);
            this.execute();
            throw new BGMessageException(errorMessage);
        }
        return this.sum;
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        this.checkModuleOnContract(this.moduleId, "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        ThreadContext.put((String)"componentName", (String)this.moduleName);
        ThreadContext.put((String)"moduleId", (String)String.valueOf(this.moduleId));
        ThreadContext.put((String)"contractId", (String)String.valueOf(this.contractId));
    }

    protected void autopaymentImpl(String prefix, AbstractAutopaymentManager autopaymentManager, Class<?> constantClass) throws Exception {
        boolean autopaymentEnable = this.moduleSetup.getBoolean(prefix + ".autopayment.enable", false);
        boolean contractAutopaymentEnabled = ContractAutopaymentManager.isContractAutopaymentEnabled(this.con, this.moduleId, this.contractId);
        if (autopaymentEnable && contractAutopaymentEnabled) {
            int mode = this.req.getInt("mode", 0);
            if (mode > -1 && mode < 4) {
                Preferences modeDataMap;
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(this.contractId);
                if (autopayment != null) {
                    if (autopayment.getMode() != AutopaymentMode.OFF) {
                        autopaymentManager.autopaymentOff(autopayment);
                    }
                    if (mode != autopayment.getMode().getCode()) {
                        autopayment.getPeriod().setLocalDateTimeTo(LocalDateTime.now());
                        autopaymentManager.updateAutopayment(autopayment);
                        autopayment = null;
                    }
                }
                if (autopayment == null) {
                    autopayment = new Autopayment().setContractId(this.contractId);
                }
                AutopaymentModeEvent autopaymentModeEvent = new AutopaymentModeEvent(this.contractId, this.moduleId, AutopaymentMode.OFF);
                Preferences preferences = modeDataMap = autopayment.getModeData() != null ? new Preferences(autopayment.getModeData(), "\n") : new Preferences();
                if (mode == AutopaymentMode.OFF.getCode()) {
                    autopayment.setMode(AutopaymentMode.OFF);
                    autopayment.setSum(BigDecimal.ZERO);
                    autopayment.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                    autopayment.setAccessToken(null);
                } else {
                    String prefixUpperCase = prefix.toUpperCase();
                    if (mode == AutopaymentMode.WEEK.getCode()) {
                        this.autopaymentWeek(prefixUpperCase, modeDataMap, autopayment, constantClass);
                        autopaymentModeEvent.setAutopaymentMode(AutopaymentMode.WEEK);
                    } else if (mode == AutopaymentMode.MONTH.getCode()) {
                        this.autopaymentMonth(prefixUpperCase, modeDataMap, autopayment, constantClass);
                        autopaymentModeEvent.setAutopaymentMode(AutopaymentMode.MONTH);
                    } else if (mode == AutopaymentMode.AUTO.getCode()) {
                        this.autopaymentAuto(prefixUpperCase, modeDataMap, autopayment, constantClass);
                        autopaymentModeEvent.setAutopaymentMode(AutopaymentMode.AUTO);
                    }
                    String customerAddress = ContractUtils.saveCustomerAddress(this.con, this.moduleId, this.contractId, this.req.get("customerAddress"));
                    this.autopaymentRegisterOrder(autopayment.getSum(), customerAddress);
                }
                autopayment.setModeData(modeDataMap.toString());
                autopaymentManager.updateAutopayment(autopayment);
                EventProcessor.getInstance().request(autopaymentModeEvent);
                this.autopaymentRedirect(autopayment.getMode().getCode() != AutopaymentMode.OFF.getCode());
            }
        } else {
            this.getLogger().error("ContractId: {}; autopaymentEnable: {}; contractAutopaymentEnabled: {}", new Object[]{this.contractId, autopaymentEnable, contractAutopaymentEnabled});
        }
    }

    protected void autopaymentRegisterOrder(BigDecimal sum, String customerAddress) throws Exception {
    }

    protected void autopaymentRedirect(boolean redirect) throws Exception {
    }
}

