/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.contract.bean.ContractManager;
import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractParameterGroupName;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterMultiListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractParameterGroupAttrModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractParameterGroupModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractParameterGroupNameDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService")
public class ContractParameterServiceImpl
extends AbstractService
implements ContractParameterService {
    @Override
    public ContractParameterGroup contractParameterGroupGet(int id) throws BGException {
        return this.context.getDirectory(ContractParameterGroup.class, 0).get(id);
    }

    @Override
    public List<ContractParameterGroup> contractParameterGroupList() throws BGException {
        return (List)this.tryReturn(() -> this.context.getDirectory(ContractParameterGroup.class, 0).list());
    }

    @Override
    public String contractParameterGroupJson() throws BGException {
        return (String)this.tryReturn(() -> {
            Connection con = this.getConnection();
            String query = "SELECT * FROM contract_parameter_group";
            try (Statement statement = con.createStatement();){
                String string;
                block14: {
                    ResultSet rs = statement.executeQuery(query);
                    try {
                        ContractPatternDao contractPatternDao = new ContractPatternDao(con);
                        ContractParameterGroupNameDao contractParameterGroupNameDao = new ContractParameterGroupNameDao(con);
                        HashMap<Integer, List> groupParameterIds = new HashMap<Integer, List>();
                        Map<Integer, Integer> groupContractMap = new ContractManager(con).getContractParameterGroupCountMap();
                        Map<Integer, Integer> patternMap = contractPatternDao.getPatternParameterGroupCountMap();
                        while (rs.next()) {
                            int groupId = rs.getInt("gid");
                            List list = groupParameterIds.getOrDefault(groupId, new ArrayList());
                            list.add(rs.getInt("pid"));
                            groupParameterIds.put(groupId, list);
                        }
                        JSONArray array = new JSONArray();
                        contractParameterGroupNameDao.reset();
                        for (ContractParameterGroupName groupName : contractParameterGroupNameDao.list()) {
                            JSONObject json = new JSONObject().put("id", groupName.getId()).put("title", (Object)groupName.getTitle()).put("patterns", (Object)patternMap.getOrDefault(groupName.getId(), 0)).put("contracts", (Object)groupContractMap.getOrDefault(groupName.getId(), 0)).put("parameterIds", (Object)(groupParameterIds.containsKey(groupName.getId()) ? Utils.toString((Iterable)((Iterable)groupParameterIds.get(groupName.getId()))) : ""));
                            array.put((Object)json);
                        }
                        string = array.toString();
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return string;
            }
        });
    }

    @Override
    public int contractParameterGroupUpdate(ContractParameterGroup group) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.context.getDirectory(ContractParameterGroup.class, 0).update(group);
            this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
            return group.getId();
        });
    }

    @Override
    public void contractParameterGroupDelete(int id) throws BGException {
        this.tryCall(() -> this.context.getDirectory(ContractParameterGroup.class, 0).delete(id));
    }

    @Override
    public List<ContractParameterListItem> contractParameterListItemList(int parameterTypeId) throws BGException {
        return (List)this.tryReturn(() -> this.context.getDirectory(ContractParameterListItem.class, parameterTypeId).list());
    }

    @Override
    public List<ContractParameterMultiListItem> contractParameterMultiListItemList(int parameterTypeId) throws BGException {
        return (List)this.tryReturn(() -> this.context.getDirectory(ContractParameterMultiListItem.class, parameterTypeId).list());
    }

    @Override
    public int contractParameterListItemUpdate(int parameterTypeId, ContractParameterListItem item) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.context.getDirectory(ContractParameterListItem.class, parameterTypeId).update(item);
            this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
            this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
            return item.getId();
        });
    }

    @Override
    public int contractParameterMultiListItemUpdate(int parameterTypeId, ContractParameterMultiListItem item) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.context.getDirectory(ContractParameterMultiListItem.class, parameterTypeId).update(item);
            this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
            this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
            return item.getId();
        });
    }

    @Override
    public void contractParameterListItemDelete(int parameterTypeId, int id) throws BGException {
        this.tryCall(() -> {
            this.context.getDirectory(ContractParameterListItem.class, parameterTypeId).delete(id);
            this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
            this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
        });
    }

    @Override
    public void contractParameterMultiListItemDelete(int parameterTypeId, int id) throws BGException {
        this.tryCall(() -> {
            this.context.getDirectory(ContractParameterMultiListItem.class, parameterTypeId).delete(id);
            this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
            this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
        });
    }

    @Override
    public ContractParameterGroupAttr contractParameterGroupAttrGet(int id) throws BGException {
        return this.context.getDirectory(ContractParameterGroupAttr.class, 0).get(id);
    }

    @Override
    public List<ContractParameterGroupAttr> contractParameterGroupAttrList() throws BGException {
        return (List)this.tryReturn(() -> this.context.getDirectory(ContractParameterGroupAttr.class, 0).list());
    }

    @Override
    public int contractParameterGroupAttrUpdate(ContractParameterGroupAttr attr) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.context.getDirectory(ContractParameterGroupAttr.class, 0).update(attr);
            this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
            return attr.getId();
        });
    }

    @Override
    public void contractParameterGroupAttrDelete(int id) throws BGException {
        this.tryCall(() -> this.context.getDirectory(ContractParameterGroupAttr.class, 0).delete(id));
    }

    @Override
    public void contractParameterGroupUpdateLink(int contractParameterGroupId, Set<Integer> parameterIds) throws BGException {
        try (ContractParameterGroupAttrDao dao = new ContractParameterGroupAttrDao(this.getConnection());){
            dao.updateLink(contractParameterGroupId, parameterIds);
        }
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
    }

    @Override
    public void contractParameterGroupAttrOrderSet(List<ContractParameterGroupAttr> list) throws BGException {
        try (ContractParameterGroupAttrDao contractParameterGroupAttrDao = new ContractParameterGroupAttrDao(this.getConnection());){
            contractParameterGroupAttrDao.updateOrderPosition(list);
            this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
        }
    }

    @Override
    public String paramPhoneFormats() throws BGException {
        return Setup.getSetup().get("phones.formats");
    }
}

