/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.function.server.access_restore;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.admin.mail.server.mail.MailAccessRestore;
import ru.bitel.bgbilling.kernel.container.web.action.ActionRequest;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.contract.function.server.PasswordManager;
import ru.bitel.bgbilling.kernel.contract.function.server.access_restore.RestoreAbstract;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.AccessRestoreStepData;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.ContractPasswordOnce;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class RestoreByEmail
extends RestoreAbstract {
    @Override
    public String getModeName() {
        return "email";
    }

    @Override
    public String getTabTitle() {
        return "E-Mail";
    }

    @Override
    public AccessRestoreStepData doStep(ActionRequest actionRequest, Contract contract, Connection con) throws Exception {
        AccessRestoreStepData restoreStepData = new AccessRestoreStepData();
        String step = actionRequest.get("step", "select");
        if ("select".equals(step)) {
            this.stepSelectEmail(restoreStepData, contract, con);
        } else if ("checkEmail".equals(step)) {
            this.stepCheckEmail(restoreStepData, contract, actionRequest.get("email"), con);
        } else if ("checkCode".equals(step)) {
            String email = actionRequest.get("email");
            String code = actionRequest.get("code");
            this.stepCheckCode(restoreStepData, contract, email, code, con);
        }
        return restoreStepData;
    }

    protected void stepSelectEmail(AccessRestoreStepData restoreStepData, Contract contract, Connection con) throws Exception {
        List<String> contractEmail = this.getContractEmail(contract, con);
        if (contractEmail == null || contractEmail.isEmpty()) {
            restoreStepData.setErrorMessage("emailNotFound");
            return;
        }
        restoreStepData.setNextStep("checkEmail");
        restoreStepData.getStepData().put("step", "select");
        restoreStepData.getStepData().put("selectTitle", "\u0412\u0430\u0448\u0438 e-mail:");
        restoreStepData.getStepData().put("maskItems", this.getMaskEmails(contractEmail));
        restoreStepData.getStepData().put("itemTitle", "E-mail:");
        restoreStepData.getStepData().put("itemName", "email");
        restoreStepData.getStepData().put("itemPlaceHolder", this.setup.get("contract.password.forgot.email.placeholder", "name@domain.ru"));
        restoreStepData.getStepData().put("itemComment", "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0438\u0437 E-mail \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0432\u044b\u0448\u0435, \u043d\u0430 \u044d\u0442\u043e\u0442 \u0430\u0434\u0440\u0435\u0441 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0441\u043b\u0430\u043d \u043a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f.");
    }

    protected void stepCheckEmail(AccessRestoreStepData restoreStepData, Contract contract, String email, Connection con) throws Exception {
        List<String> contractEmail = this.getContractEmail(contract, con);
        if (contractEmail == null || contractEmail.isEmpty()) {
            restoreStepData.setErrorMessage("emailNotFound");
            return;
        }
        if (!this.checkEmail(email, contractEmail)) {
            restoreStepData.setErrorMessage("emailNotValid");
            restoreStepData.getStepData().put("errorEmail", email);
            this.stepSelectEmail(restoreStepData, contract, con);
            return;
        }
        int emailCodeLength = this.getCodeLength();
        MailData mailData = this.getMailAccessRestore(email, emailCodeLength, contract, con);
        if (mailData != null) {
            try {
                new MailMsg(this.setup).sendMessage(mailData);
                this.showCheckCode(restoreStepData, email, emailCodeLength);
            }
            catch (Exception ex) {
                restoreStepData.setErrorMessage("emailSendMessage");
                this.logError(ex);
            }
        } else {
            restoreStepData.setErrorMessage("emailDataEmpty");
            restoreStepData.getStepData().put("errorEmail", email);
        }
    }

    protected void showCheckCode(AccessRestoreStepData restoreStepData, String email, int emailCodeLength) {
        restoreStepData.setNextStep("checkCode");
        restoreStepData.getStepData().put("step", "enterCode");
        restoreStepData.getStepData().put("itemName", "email");
        restoreStepData.getStepData().put("itemValue", email);
        restoreStepData.getStepData().put("codeMask", "X".repeat(emailCodeLength));
    }

    protected void stepCheckCode(AccessRestoreStepData restoreStepData, Contract contract, String email, String code, Connection con) throws Exception {
        List<String> contractEmail = this.getContractEmail(contract, con);
        if (contractEmail == null || contractEmail.isEmpty()) {
            restoreStepData.setErrorMessage("emailNotFound");
            return;
        }
        if (!this.checkEmail(email, contractEmail)) {
            restoreStepData.setErrorMessage("emailNotValid");
            restoreStepData.getStepData().put("errorEmail", email);
            return;
        }
        if (code == null) {
            this.stepCheckEmail(restoreStepData, contract, email, con);
            restoreStepData.setErrorMessage("codeNotEnter");
            return;
        }
        PasswordManager passwordManager = new PasswordManager(con);
        ContractPasswordOnce contractPasswordOnce = passwordManager.getContractPasswordOnceByContractTitle(contract.getTitle());
        if (contractPasswordOnce == null) {
            restoreStepData.setErrorMessage("codeNotFound");
        } else if (contractPasswordOnce.getCreateTime().isAfter(LocalDateTime.now()) && contractPasswordOnce.getCode().equals(code)) {
            restoreStepData.getStepData().put("step", "gotoLK");
            restoreStepData.getStepData().put("code", code);
            return;
        }
        restoreStepData.setErrorMessage("codeNotValid");
        this.showCheckCode(restoreStepData, email, this.getCodeLength());
    }

    protected int getCodeLength() {
        return this.setup.getInt("contract.password.forgot.email.code.length", 6);
    }

    protected List<String> getContractEmail(Contract contract, Connection con) throws Exception {
        ArrayList<String> contractEmail = new ArrayList<String>();
        int paramId = this.setup.getInt("contract.password.forgot.email.param.id", -1);
        if (paramId == 0) {
            new CustomerDao(con).getCustomerEmailsByContractId(contract.getId()).forEach(a -> contractEmail.add(a.getValue()));
        } else if (paramId > 0) {
            try (ContractDao contractDao = new ContractDao(con, 0);){
                contractDao.getContractParameterEmail(contract.getId(), paramId).ifPresent(a -> contractEmail.addAll(a.getAddressList()));
                if (contractEmail.isEmpty()) {
                    contractDao.optContractParameterText(contract.getId(), paramId).ifPresent(a -> contractEmail.addAll(Arrays.asList(a.getValue().split(";"))));
                }
            }
        }
        return contractEmail;
    }

    protected boolean checkEmail(String email, List<String> emailList) {
        boolean result;
        block1: {
            String e;
            String token;
            result = false;
            if (email == null || emailList == null) break block1;
            email = email.toLowerCase();
            Iterator<String> iterator = emailList.iterator();
            while (iterator.hasNext() && !(result = (token = (e = iterator.next()).toLowerCase()).equals(email) || token.indexOf("<" + email + ">") > -1)) {
            }
        }
        return result;
    }

    protected List<String> getMaskEmails(List<String> emails) {
        ArrayList<String> maskEmail = new ArrayList<String>();
        Pattern patternEmail = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 2);
        for (String email : emails) {
            String emailString = "";
            if (email.indexOf("<") == -1) {
                Matcher matcherEmail = patternEmail.matcher(email);
                if (matcherEmail.find()) {
                    emailString = matcherEmail.group();
                    if (matcherEmail.find()) {
                        emailString = email;
                    }
                }
            } else {
                int index = email.indexOf("<");
                Matcher matcherEmail = patternEmail.matcher(email.substring(index, email.length()));
                if (matcherEmail.find()) {
                    emailString = matcherEmail.group();
                }
            }
            maskEmail.add(Utils.maskEmail((String)emailString));
        }
        return maskEmail;
    }

    protected MailData getMailAccessRestore(String contractEmail, int emailCodeLength, Contract contract, Connection con) throws Exception {
        MailData mailAccessRestore = null;
        PasswordManager passwordManager = new PasswordManager(con);
        long passwordExpireMinute = this.setup.getLong("contract.password.forgot.expire.minute", this.setup.getLong("contract.password.forgot.expire.hour", 1L) * 60L);
        String emailSubject = this.setup.get("contract.password.forgot.email.subject", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0432 \u041b\u0438\u0447\u043d\u044b\u0439 \u043a\u0430\u0431\u0438\u043d\u0435\u0442");
        String emailText = this.setup.get("contract.password.forgot.email.body", "\u0412\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0432 \u041b\u0438\u0447\u043d\u044b\u0439 \u043a\u0430\u0431\u0438\u043d\u0435\u0442 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 {contract}\n\u041a\u043e\u0434 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u044f - {code}\n\u041a\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u0435\u043d \u0434\u043e {time}.");
        String charArray = this.setup.get("contract.password.forgot.char.array", "1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm");
        String password = passwordManager.getOncePassword(emailCodeLength, charArray);
        passwordManager.deleteByContract(contract.getTitle());
        passwordManager.addPassword(contract.getTitle(), passwordExpireMinute, password);
        try {
            password = URLEncoder.encode(password, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("password URLEncoder -> " + ex.getLocalizedMessage());
        }
        emailText = emailText.replaceAll("\\{contract\\}", contract.getTitle());
        emailText = emailText.replaceAll("\\{time\\}", TimeUtils.format((Date)new Date(System.currentTimeMillis() + passwordExpireMinute * 60000L), (String)"dd.MM.yyyy HH:mm:ss"));
        emailText = emailText.replaceAll("\\{code\\}", password);
        mailAccessRestore = new MailAccessRestore().setPassword(password).setEmailText(emailText).setPasswordExpireHour(passwordExpireMinute).setContractId(contract.getId()).setRecipients(contractEmail).setSubject(emailSubject).addTextPart("text", emailText);
        return mailAccessRestore;
    }
}

