/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.search.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;
import ru.bitel.bgbilling.kernel.contract.search.common.service.ContractSearchService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;

public class ContractSearchRules
extends BGUPanel {
    private SearchImplementationTableModel tableModel = new SearchImplementationTableModel();
    private BGUPanel.WebServiceHolder<ContractSearchService> searchService = new BGUPanel.WebServiceHolder((BGUPanel)this, ContractSearchService.class);

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        JButton reloadImplCache = new JButton("\u041f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435");
        reloadImplCache.addActionListener(e -> this.performAction("refresh"));
        this.setLayout(new GridBagLayout());
        this.add(reloadImplCache, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.performAction("refresh");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            ((ContractSearchService)this.searchService.get()).reloadCache();
            this.tableModel.setData(((ContractSearchService)this.searchService.get()).getSelectedSearches());
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            SelectSearchDialog dialog = new SelectSearchDialog("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438 \u043f\u043e\u0438\u0441\u043a\u0430", new SearchImplementation());
            dialog.open();
            dialog.getData();
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            SearchImplementation searchImplementation = (SearchImplementation)((Object)((Object)this.tableModel.getSelectedRow()));
            if (searchImplementation != null && ClientUtils.confirmDelete((Object)((Object)searchImplementation))) {
                this.deleteSearch();
            }
        });
    }

    private void deleteSearch() {
        List searchImplementations = this.tableModel.getSelectedRows();
        if (Utils.notEmptyCollection((Collection)searchImplementations)) {
            searchImplementations.forEach(search -> this.tryCall(() -> ((ContractSearchService)this.searchService.get()).deleteSearch((SearchImplementation)((Object)search))));
            this.performAction("refresh");
        }
    }

    class SearchImplementationTableModel
    extends BGTableModel<SearchImplementation> {
        public SearchImplementationTableModel() {
            super(SearchImplementation.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043b\u0430\u0441\u0441 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", -1, -1, -1, "pathToImplClass", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", 100, 200, 300, "moduleTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class SelectSearchDialog
    extends BGEditorDialog<SearchImplementation> {
        private BGUList<SearchImplementation> searchesList;

        public SelectSearchDialog(String title, SearchImplementation data) {
            super(title, (Object)data);
            this.searchesList = new BGUList();
        }

        public void doDialogPanel() {
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(this.searchesList, (int)600, (int)300), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.selectButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.tryCall(() -> this.searchesList.setData(((ContractSearchService)ContractSearchRules.this.searchService.get()).getSearches()));
        }

        private JPanel selectButtonPanel() {
            JButton selectAll = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0451");
            selectAll.addActionListener(e -> this.searchesList.setSelectionInterval(0, this.searchesList.getModel().getSize()));
            JButton unselectAll = new JButton("\u0421\u043d\u044f\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435");
            unselectAll.addActionListener(e -> this.searchesList.clearSelection());
            JPanel panel = new JPanel(new GridLayout(1, 2, 5, 0));
            panel.add(selectAll);
            panel.add(unselectAll);
            return panel;
        }

        public boolean doApply() throws Exception {
            List selectedSearches = this.searchesList.getSelectedValuesList();
            if (Utils.isEmptyCollection((Collection)selectedSearches)) {
                ClientUtils.showMessageDialog((Object)"\u0412\u044b \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043b\u0438 \u043d\u0438 \u043e\u0434\u043d\u0443 \u0437\u0430\u043f\u0438\u0441\u044c");
                return false;
            }
            return this.tryCallBoolean(() -> {
                ContractSearchRules.this.tableModel.getRows().forEach(row -> selectedSearches.removeIf(selected -> selected.getPathToImplClass().equals(row.getPathToImplClass()) && selected.getModuleId() == row.getModuleId()));
                ((ContractSearchService)ContractSearchRules.this.searchService.get()).updateSearchList(selectedSearches);
                ContractSearchRules.this.tableModel.setData(((ContractSearchService)ContractSearchRules.this.searchService.get()).getSelectedSearches());
            });
        }
    }
}

