/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.server.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.WiFiAgent;
import ru.bitel.bgbilling.kernel.wifi.WiFiManager;
import ru.bitel.bgbilling.kernel.wifi.common.IpInfo;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.bgbilling.kernel.wifi.server.util.RadiusUtil;
import ru.bitel.bgbilling.kernel.wifi.server.util.ScriptUtil;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.AccessCode;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.common.Utils;

public class WifiPortalServlet
extends HttpServlet {
    private Logger log = LogManager.getLogger();

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String servletPath = request.getServletPath();
        if ("/show".equals(servletPath = servletPath.replaceAll("(.*)\\.do$", "$1"))) {
            this.show(request, response);
        } else if ("/auth".equals(servletPath)) {
            this.auth(request, response);
        } else if ("/password".equals(servletPath)) {
            this.password(request, response);
        } else if ("/statistics".equals(servletPath)) {
            this.statistics(request, response);
        } else if ("/logout".equals(servletPath)) {
            this.logout(request, response);
        } else if ("/auth/activate".equals(servletPath)) {
            String methodName = request.getParameter("method");
            if ("activate".equals(methodName)) {
                this.activate(request, response);
            } else if ("activateWithForward".equals(methodName)) {
                this.activateWithForward(request, response);
            } else if ("remoteSuccess".equals(methodName)) {
                this.remoteSuccess(request, response);
            } else if ("remoteFail".equals(methodName)) {
                this.remoteFail(request, response);
            } else {
                request.getRequestDispatcher("/auth/activation.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
    }

    void show(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        String ip = ServletUtils.getIpFromHeader(request, cfg.getHeaderNameRemoteAddress());
        String login = this.getUserLogin(ip);
        try {
            double balance = this.getBalance(login);
            request.setAttribute("balance", (Object)balance);
        }
        catch (Exception ex) {
            this.log.error("error getBalance", (Throwable)ex);
            request.setAttribute("balance", (Object)"0.00");
        }
        request.setAttribute("showStatistics", (Object)cfg.isShowStatistics());
        request.getRequestDispatcher("/access_ok.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    void auth(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String login = request.getParameter("login");
        String passwd = request.getParameter("password");
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        String realm = cfg.isUseRealm() ? request.getParameter("realm") : null;
        String ip = ServletUtils.getIpFromHeader(request, cfg.getHeaderNameRemoteAddress());
        boolean submitted = request.getParameter("submitted") != null;
        WiFiManager manager = (WiFiManager)this.getServletContext().getAttribute("manager");
        if (submitted && (manager.isIpAlive(WiFiUtil.getIp(ip), false) || this.checkAuth(login, passwd, ip, realm, request))) {
            String target = (String)request.getSession().getAttribute("originalTarget");
            if (!Utils.isEmptyString((String)target)) {
                response.sendRedirect(target);
            } else {
                request.getSession().removeAttribute("originalTarget");
                request.getRequestDispatcher("/").forward((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            request.setAttribute("cardLink", (Object)cfg.getCardLink());
            if (cfg.isUseRealm()) {
                request.setAttribute("realms", cfg.getRealms());
            }
            if (cfg.isRemindPassword()) {
                request.setAttribute("remindPassword", (Object)cfg.isRemindPassword());
            }
            if (!Utils.isEmptyString((String)cfg.getPortalHttpsUrl())) {
                request.setAttribute("securityLink", (Object)cfg.getPortalHttpsUrl());
            }
            if (cfg.isActivate()) {
                request.setAttribute("activateOperation", (Object)"activate");
            } else if (cfg.isActivateWithForward()) {
                request.setAttribute("activateOperation", (Object)"activateWithForward");
            }
            request.getRequestDispatcher("/auth/login.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    void password(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean submit;
        boolean bl = submit = request.getParameter("submit") != null;
        if (submit) {
            String email = request.getParameter("email");
            String error = null;
            if (Utils.isEmptyString((String)email)) {
                error = "\u0412\u044b \u0437\u0430\u0431\u044b\u043b\u0438 \u0432\u0432\u0435\u0441\u0442\u0438 e-mail";
                this.addError(request, error);
                request.getRequestDispatcher("/auth/passwd.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (!email.matches("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$")) {
                error = "\u0412\u0432\u0435\u0434\u0435\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043d\u0430\u0431\u043e\u0440";
                this.addError(request, error);
                request.getRequestDispatcher("/auth/passwd.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            try {
                error = this.sendPasswords(email);
            }
            catch (Exception ex) {
                this.log.error("error sendPasswords", (Throwable)ex);
                error = ex.toString();
            }
            if (error != null) {
                this.addError(request, error);
                request.getRequestDispatcher("/auth/passwd.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            request.getRequestDispatcher("/auth/passwd_send.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.getRequestDispatcher("/auth/passwd.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    void statistics(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        Object statUrl = cfg.getStatHttpUrl();
        String backUrl = cfg.getPortalHttpUrl();
        String ip = ServletUtils.getIpFromHeader(request, cfg.getHeaderNameRemoteAddress());
        String login = this.getUserLogin(ip);
        String password = this.getUserPasswd(ip);
        if (request.getRequestURL().toString().startsWith("https")) {
            statUrl = cfg.getStatHttpsUrl();
            backUrl = cfg.getPortalHttpsUrl();
        }
        statUrl = (String)statUrl + "?user=" + login + "&pswd=" + password + "&midAuth=" + cfg.getModuleId() + "&backUrl=" + backUrl;
        response.sendRedirect((String)statUrl);
    }

    void logout(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        String ip = ServletUtils.getIpFromHeader(request, cfg.getHeaderNameRemoteAddress());
        this.sendWiFiKillSignal(ip);
        request.getSession().invalidate();
        request.getRequestDispatcher("/").forward((ServletRequest)request, (ServletResponse)response);
    }

    void activate(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        request.setAttribute("parameters", cfg.getActivateParams());
        if (Utils.isEmptyString((String)request.getParameter("activateOperation"))) {
            request.setAttribute("activateOperation", (Object)"activate");
            request.getRequestDispatcher("/auth/activation.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute("activateOperation", (Object)"activate");
        WiFiAgent agent = (WiFiAgent)this.getServletContext().getAttribute("wifiAgent");
        Map<String, String> params = this.readParameterMap(request);
        String message = null;
        try {
            message = agent.activate(params);
        }
        catch (Exception ex) {
            request.setAttribute("error", (Object)ex.getMessage());
            request.getRequestDispatcher("/auth/activation.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute("message", (Object)message);
        request.getRequestDispatcher("/auth/activation_result.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    void activateWithForward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        request.setAttribute("parameters", cfg.getActivateParams());
        if (Utils.isEmptyString((String)request.getParameter("activateOperation"))) {
            request.setAttribute("activateOperation", (Object)"activateWithForward");
            request.getRequestDispatcher("/auth/activation.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        request.setAttribute("activateOperation", (Object)"activateWithForward");
        WiFiAgent agent = (WiFiAgent)this.getServletContext().getAttribute("wifiAgent");
        Map<String, String> params = this.readParameterMap(request);
        String activeUrl = null;
        try {
            activeUrl = agent.activateWithForward(params);
        }
        catch (Exception ex) {
            request.setAttribute("error", (Object)ex.getMessage());
            request.getRequestDispatcher("/auth/activation.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (activeUrl != null) {
            response.sendRedirect(activeUrl);
        } else {
            request.getRequestDispatcher("/auth/activation_result.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    void remoteSuccess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("message", (Object)request.getParameter("message"));
        request.getRequestDispatcher("/auth/activation_result.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    void remoteFail(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        request.setAttribute("parameters", cfg.getActivateParams());
        request.setAttribute("error", (Object)request.getParameter("error"));
        request.getRequestDispatcher("/auth/activation.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private String getUserLogin(String ip) {
        String result = null;
        WiFiManager manager = (WiFiManager)this.getServletContext().getAttribute("manager");
        IpInfo info = manager.getIpHash().get(WiFiUtil.getIp(ip));
        if (info != null) {
            result = info.getLogin();
        }
        return result;
    }

    private String getUserPasswd(String ip) {
        String result = null;
        WiFiManager manager = (WiFiManager)this.getServletContext().getAttribute("manager");
        IpInfo info = manager.getIpHash().get(WiFiUtil.getIp(ip));
        if (info != null) {
            result = info.getPasswd();
        }
        return result;
    }

    private double getBalance(String login) throws Exception {
        return ((WiFiAgent)this.getServletContext().getAttribute("wifiAgent")).getBalance(login);
    }

    private boolean checkAuth(String login, String passwd, String ip, String realm, HttpServletRequest request) {
        boolean result;
        block5: {
            RadiusUtil radiusUtil = (RadiusUtil)this.getServletContext().getAttribute("radiusUtil");
            result = false;
            if (!Utils.isEmptyString((String)login) && !Utils.isEmptyString((String)passwd)) {
                try {
                    String acctSessionId = ip + "_" + System.currentTimeMillis();
                    RadiusPacket response = radiusUtil.authUser(login, passwd, ip, realm, acctSessionId);
                    this.log.info("checking authentication ({}, {})...", (Object)login, (Object)ip);
                    if (response != null && response.getCode() == 2) {
                        this.log.info("authentication accepted!");
                        this.sendWiFiAddSignal(ip, login, passwd, acctSessionId);
                        this.runScript(response, ip);
                        result = true;
                        break block5;
                    }
                    this.log.info("authentication rejected!");
                    this.addAuthErrorToRequest(request, response);
                }
                catch (Exception e) {
                    this.log.error("error checkAuth", (Throwable)e);
                    request.setAttribute("error", (Object)"\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430");
                }
            } else {
                String error = "\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0437\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u043b\u043e\u0433\u0438\u043d \u0438 \u043f\u0430\u0440\u043e\u043b\u044c";
                request.setAttribute("error", (Object)error);
            }
        }
        return result;
    }

    private void runScript(RadiusPacket response, String ip) {
        GlobalConfig cfg = (GlobalConfig)this.getServletContext().getAttribute("cfg");
        List<Map<String, String>> authAttrs = cfg.getAuthAttrs();
        RadiusUtil radiusUtil = (RadiusUtil)this.getServletContext().getAttribute("radiusUtil");
        ScriptUtil scriptUtil = (ScriptUtil)this.getServletContext().getAttribute("scriptUtil");
        ArrayList<String> atrList = new ArrayList<String>();
        try {
            for (Map<String, String> map : authAttrs) {
                Integer vendorCode = Integer.valueOf(map.get("vendorCode"));
                Integer attrCode = Integer.valueOf(map.get("attrCode"));
                String type = map.get("type");
                String param = null;
                if (type.equals("integer")) {
                    Integer value = radiusUtil.getIntAtrrubuteValue(response, vendorCode, attrCode);
                    if (value != null) {
                        param = value.toString();
                    }
                } else if (type.equals("string")) {
                    param = radiusUtil.getStringAtrrubuteValue(response, vendorCode, attrCode);
                }
                if (param == null) {
                    atrList.clear();
                    throw new RuntimeException("Value for vendor code = " + vendorCode + " and attribute code = " + attrCode + " is NULL!!");
                }
                atrList.add(param);
            }
        }
        catch (Exception e) {
            this.log.error("error runScript", (Throwable)e);
        }
        scriptUtil.runStartScript(ip, atrList);
    }

    private void sendWiFiAddSignal(String ip, String login, String passwd, String acctSessionId) throws IOException {
        WiFiManager manager = (WiFiManager)this.getServletContext().getAttribute("manager");
        IpInfo info = new IpInfo(WiFiUtil.getIp(ip), new Date().getTime(), login, acctSessionId);
        info.setPasswd(passwd);
        manager.add(info);
    }

    private void addAuthErrorToRequest(HttpServletRequest request, RadiusPacket response) {
        if (response == null) {
            request.setAttribute("error", (Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 - \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443");
            return;
        }
        if (response.getCode() != 2) {
            Object error = "";
            int errorCode = Utils.parseInt((String)response.getStringAttribute(-1, 18, null));
            switch (AccessCode.getAccessCode((int)errorCode)) {
                case INVALID_ACCOUNT: {
                    error = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043b\u043e\u0433\u0438\u043d";
                    break;
                }
                case INVALID_PIN: {
                    error = "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c";
                    break;
                }
                case BALANCE_INSUFFICIENT: {
                    error = "\u0423 \u0432\u0430\u0441 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0447\u0435\u0442\u0443";
                    break;
                }
                case AUTH_DENY: {
                    error = "\u0414\u043e\u0441\u0442\u0443\u043f \u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d";
                    break;
                }
                case SERVICE_CLOSED: {
                    error = "\u0421\u0442\u0430\u0442\u0443\u0441 \u0441\u0435\u0440\u0432\u0438\u0441\u0430 - \u0437\u0430\u043a\u0440\u044b\u0442";
                    break;
                }
                default: {
                    error = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0438 - \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443 [#" + errorCode + "]";
                }
            }
            request.setAttribute("error", error);
        }
    }

    private void addError(HttpServletRequest request, String error) {
        request.setAttribute("error", (Object)error);
    }

    private String sendPasswords(String email) throws Exception {
        WiFiAgent agent = (WiFiAgent)this.getServletContext().getAttribute("wifiAgent");
        return agent.sendPasswords(email);
    }

    private void sendWiFiKillSignal(String ip) {
        WiFiManager manager = (WiFiManager)this.getServletContext().getAttribute("manager");
        try {
            manager.kill(WiFiUtil.getIp(ip));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Map<String, String> readParameterMap(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map pairs = request.getParameterMap();
        for (Map.Entry entry : pairs.entrySet()) {
            String key = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            if (!key.startsWith("param_") || values.length == 0) continue;
            String name = key.substring(key.indexOf("_") + 1);
            result.put(name, values[0]);
        }
        return result;
    }
}

