/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.server.bean.ParameterIds;

public class ParameterDao
extends AbstarctDaoConstant {
    public ParameterDao(Connection con) {
        super(con);
    }

    public Map<String, String> getAddressParams(ParameterIds parameterIds) {
        HashMap<String, String> map = new HashMap<String, String>();
        String query = "SELECT * FROM address_config WHERE true" + " OR (table_id=? AND record_id=?)".repeat(parameterIds.getCount());
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            for (Map.Entry<String, Integer> entry : parameterIds.getIds().entrySet()) {
                ps.setString(index++, entry.getKey());
                ps.setInt(index++, entry.getValue());
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    map.put(rs.getString("table_id") + "." + rs.getString("key"), rs.getString("value"));
                }
            }
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        return map;
    }

    public Map<String, String> getAddressParams(String tableId, int recordId) {
        HashMap<String, String> map = new HashMap<String, String>();
        String query = "SELECT * FROM address_config WHERE table_id=? AND record_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, tableId);
            ps.setInt(2, recordId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    map.put(rs.getString("key"), rs.getString("value"));
                }
            }
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        return map;
    }

    public String getAddressParam(String tableId, int recordId, String key) {
        String result = null;
        String sql = "SELECT * FROM address_config WHERE table_id=? AND record_id=? AND address_config.key=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setString(1, tableId);
            ps.setInt(2, recordId);
            ps.setString(3, key);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = rs.getString("value");
                }
            }
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
        return result;
    }

    public void updateAddressParams(String tableId, int recordId, String key, String value) throws BGException {
        String queryDelete = "DELETE FROM address_config WHERE table_id=? AND record_id=? AND `key`=? ";
        String queryInsert = "INSERT INTO address_config SET table_id=?, value=?, record_id=?, `key`=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);
             PreparedStatement psUpdate = this.con.prepareStatement(queryInsert);){
            psDelete.setString(1, tableId);
            psDelete.setInt(2, recordId);
            psDelete.setString(3, key);
            psDelete.executeUpdate();
            if (Utils.notEmptyString((String)value)) {
                psUpdate.setString(1, tableId);
                psUpdate.setString(2, value);
                psUpdate.setInt(3, recordId);
                psUpdate.setString(4, key);
                psUpdate.executeUpdate();
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteAddressParams(String tableId, int recordId) {
        try {
            String sql = null;
            ArrayList<Integer> streetIdList = new ArrayList<Integer>();
            ArrayList<Integer> areaIdList = new ArrayList<Integer>();
            ArrayList<Integer> quarterIdList = new ArrayList<Integer>();
            if (tableId.equals("address_city")) {
                sql = "SELECT * FROM address_street WHERE cityid=?";
                PreparedStatement streetPS = this.con.prepareStatement(sql);
                streetPS.setInt(1, recordId);
                ResultSet rs = streetPS.executeQuery();
                while (rs.next()) {
                    streetIdList.add(rs.getInt("id"));
                }
                sql = "SELECT * FROM address_area WHERE cityid=?";
                PreparedStatement areaPS = this.con.prepareStatement(sql);
                areaPS.setInt(1, recordId);
                rs = areaPS.executeQuery();
                while (rs.next()) {
                    areaIdList.add(rs.getInt("id"));
                }
                sql = "SELECT * FROM address_quarter WHERE cityid=?";
                PreparedStatement quarterPS = this.con.prepareStatement(sql);
                quarterPS.setInt(1, recordId);
                rs = quarterPS.executeQuery();
                while (rs.next()) {
                    quarterIdList.add(rs.getInt("id"));
                }
                rs.close();
                streetPS.close();
                areaPS.close();
                quarterPS.close();
                if (areaIdList.size() > 0) {
                    this.deleteExctraAddressParams("address_area", areaIdList, null);
                }
                if (streetIdList.size() > 0) {
                    this.deleteExctraAddressParams("address_street", streetIdList, null);
                }
                if (quarterIdList.size() > 0) {
                    this.deleteExctraAddressParams("address_quarter", quarterIdList, null);
                }
            }
            this.deleteExctraAddressParams(tableId, Arrays.asList(recordId), null);
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
    }

    public void deleteExctraAddressParams(String tableId, List<Integer> recordIds, String key) {
        if (recordIds == null || recordIds.isEmpty()) {
            return;
        }
        String sql = "DELETE FROM address_config WHERE table_id=?" + (key == null ? "" : " AND `key`=?") + " AND record_id IN (" + Utils.toString(recordIds) + ")";
        try (PreparedStatement psDelete = this.con.prepareStatement(sql);){
            psDelete.setString(1, tableId);
            if (key != null) {
                psDelete.setString(2, key);
            }
            psDelete.executeUpdate();
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
    }
}

