/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.CheckListCellRenderer;
import bitel.billing.module.common.CheckListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;

public class BGControlPanelListSelect
extends BGUPanel {
    private JButton buttonInvertSelect = new JButton();
    private JButton buttonClearSelect = new JButton();
    private JButton buttonAllSelect = new JButton();
    private boolean buttonPanelVisible = true;
    private JPanel jPanel1 = new JPanel(new GridBagLayout());
    private DefaultListModel<BGUListItem> listModel = new DefaultListModel();
    private JList<BGUListItem> list = new JList<BGUListItem>(this.listModel);
    private int top = 0;
    private int inset = 0;

    public BGControlPanelListSelect() {
        this(false, 0, 3);
    }

    public BGControlPanelListSelect(boolean singleSelection) {
        this(singleSelection, 0, 3);
    }

    public BGControlPanelListSelect(int top) {
        this(false, top, 3);
    }

    public BGControlPanelListSelect(int top, int inset) {
        this(false, top, inset);
    }

    public BGControlPanelListSelect(boolean singleSelection, int top, int inset) {
        this.top = top;
        this.inset = inset;
        this.tryCall(() -> this.build());
        this.listModel.clear();
        this.list.setCellRenderer(new CheckListCellRenderer());
        this.list.setSelectionMode(0);
        if (singleSelection) {
            new CheckListener(this.list){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (ClientUtils.isCtrlI(e)) {
                        BGUListItem id = (BGUListItem)this.list.getSelectedValue();
                        if (id != null) {
                            ClientUtils.showMessageDialog("\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f: " + id.getId(), "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                        }
                    } else {
                        super.keyPressed(e);
                        BGControlPanelListSelect.this.firePropertyChange("itemChange", "1", "2");
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    BGControlPanelListSelect.this.firePropertyChange("itemChange", "1", "2");
                }

                @Override
                protected void doCheck(int index) {
                    if (index > -1 && this.list.isEnabled()) {
                        BGUListItem item = (BGUListItem)this.list.getModel().getElementAt(index);
                        if (!item.isSelected()) {
                            BGControlPanelListSelect.this.setListItemSelected(false);
                        }
                        item.invertSelected();
                        this.list.repaint();
                    }
                }
            };
            this.setButtonPanelVisible(false);
        } else {
            new CheckListener(this.list){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (ClientUtils.isCtrlI(e)) {
                        BGUListItem id = (BGUListItem)this.list.getSelectedValue();
                        if (id != null) {
                            ClientUtils.showMessageDialog("\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f: " + id.getId(), "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f");
                        }
                    } else {
                        super.keyPressed(e);
                        BGControlPanelListSelect.this.firePropertyChange("itemChange", "1", "2");
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    BGControlPanelListSelect.this.firePropertyChange("itemChange", "1", "2");
                }
            };
        }
    }

    @Override
    protected void jbInit() throws Exception {
        this.buttonAllSelect.setActionCommand("all");
        this.buttonAllSelect.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAllSelect.setText("\u0412\u0441\u0435");
        this.buttonAllSelect.addActionListener(e -> this.buttonAllSelect_actionPerformed(e));
        this.buttonClearSelect.setActionCommand("clear");
        this.buttonClearSelect.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClearSelect.setText("\u0421\u0431\u0440\u043e\u0441");
        this.buttonClearSelect.addActionListener(e -> this.buttonClearSelect_actionPerformed(e));
        this.buttonInvertSelect.setMargin(new Insets(2, 2, 2, 2));
        this.buttonInvertSelect.setText("\u0418\u043d\u0432\u0435\u0440\u0442.");
        this.buttonInvertSelect.addActionListener(e -> this.buttonInvertSelect_actionPerformed(e));
        this.jPanel1.add((Component)this.buttonAllSelect, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.jPanel1.add((Component)this.buttonClearSelect, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.jPanel1.add((Component)this.buttonInvertSelect, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(this.top, this.inset, this.inset, this.inset), 0, 0));
        this.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    public void setListItemSelected(boolean selected) {
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            listModel.getElementAt(i).setSelected(selected);
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    private void buttonInvertSelect_actionPerformed(ActionEvent e) {
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            listModel.getElementAt(i).invertSelected();
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    private void buttonClearSelect_actionPerformed(ActionEvent e) {
        this.setListItemSelected(false);
    }

    private void buttonAllSelect_actionPerformed(ActionEvent e) {
        this.setListItemSelected(true);
    }

    public JList<BGUListItem> getList() {
        return this.list;
    }

    public DefaultListModel<BGUListItem> getListModel() {
        return this.list.getModel() == this.listModel ? this.listModel : (DefaultListModel)this.list.getModel();
    }

    public List<BGUListItem> getSelectedElements() {
        ArrayList<BGUListItem> selectedElements = new ArrayList<BGUListItem>();
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            BGUListItem listItem = listModel.getElementAt(i);
            if (listItem == null || !listItem.isSelected()) continue;
            selectedElements.add(listItem);
        }
        return selectedElements;
    }

    public List<Integer> getListIds() {
        ArrayList<Integer> value = new ArrayList<Integer>();
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            BGUListItem item = listModel.elementAt(i);
            if (!item.isSelected()) continue;
            value.add(item.getId());
        }
        return value;
    }

    public int[] getSelectedIds() {
        int j = 0;
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        int[] value = new int[listModel.size()];
        for (int i = 0; i < listModel.getSize(); ++i) {
            BGUListItem item = listModel.elementAt(i);
            if (!item.isSelected()) continue;
            value[j++] = item.getId();
        }
        return Arrays.copyOf(value, j);
    }

    public String getListValues() {
        StringBuilder value = new StringBuilder();
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            BGUListItem item = listModel.elementAt(i);
            if (!item.isSelected()) continue;
            value.append(value.length() == 0 ? "" : ", ").append(item.getIdStr());
        }
        return value.toString();
    }

    public String getListValuesByTitle() {
        Object value = "";
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            BGUListItem item = listModel.elementAt(i);
            if (!item.isSelected()) continue;
            value = (String)value + (((String)value).length() == 0 ? "" : ", ") + item.getTitle();
        }
        return value;
    }

    public String getAllListValues() {
        Object value = "";
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            BGUListItem item = listModel.elementAt(i);
            value = (String)value + (((String)value).length() == 0 ? "" : ", ") + item.getIdStr();
        }
        return value;
    }

    public long getValue() {
        long f = 0L;
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            BGUListItem item = listModel.elementAt(i);
            if (!item.isSelected()) continue;
            try {
                f += 1L << item.getId();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return f;
    }

    public void setListValues(String values) {
        List<String> valuesList = Utils.toList(values);
        DefaultListModel<BGUListItem> listModel = this.getListModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            BGUListItem item;
            item.setSelected(valuesList.indexOf((item = listModel.elementAt(i)).getIdStr()) >= 0);
        }
        if (this.isVisible()) {
            this.list.repaint();
        }
    }

    public void setButtonPanelVisible(boolean buttonPanelVisible) {
        this.buttonPanelVisible = buttonPanelVisible;
        this.jPanel1.setVisible(buttonPanelVisible);
    }

    public boolean isButtonPanelVisible() {
        return this.buttonPanelVisible;
    }

    public void setTitledBorder1(TitledBorder titledBorder1) {
        this.setBorder(titledBorder1);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.buttonAllSelect.setEnabled(b);
        this.buttonClearSelect.setEnabled(b);
        this.buttonInvertSelect.setEnabled(b);
        this.list.setEnabled(b);
    }
}

