/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.customer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerAccount;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerContactItem;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerContactType;
import ru.bitel.bgbilling.kernel.customer.common.bean.CustomerEmployee;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class CustomerDao
extends BGLogger {
    public static final String TABLE_CUSTOMER = "customer";
    public static final String TABLE_CUSTOMER_LOG = "customer_log";
    public static final String TABLE_CUSTOMER_LINK = "customer_link";
    public static final String TABLE_CUSTOMER_ACCOUNT = "customer_account";
    private Connection con;

    public CustomerDao(Connection con) {
        this.con = con;
    }

    public void searchCustomer(SearchResult<Customer> searchResult, Customer.CustomerType customerType, List<KeyValue> filters) throws SQLException {
        ResultSet rs;
        Page page = searchResult.getPage();
        List<Customer> list = searchResult.getList();
        boolean filter = filters != null && !filters.isEmpty();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM customer WHERE type=?" + (filter ? this.getSQLFilter(filters) : "") + Page.toSqlLimit(page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, customerType.getType());
            if (filter) {
                for (KeyValue keyValue : filters) {
                    ps.setString(index++, keyValue.getKey());
                    ps.setString(index++, "%" + keyValue.getValue() + "%");
                }
            }
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    list.add(new Customer().setId(rs.getInt("id")).setCustomerType(Customer.CustomerType.defineType(rs.getString("type"))).setData(rs.getString("data")));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            Page.setRecordCount(page, ServerUtils.foundRows((Connection)this.con));
        }
        if (!list.isEmpty()) {
            List<Integer> customerIds = list.stream().map(a -> a.getId()).toList();
            query = "SELECT customer_id, COUNT(contract_id) AS contract_count FROM customer_link WHERE (`date_to` IS NULL OR `date_to` >= now()) AND customer_id IN (" + Utils.toString(customerIds) + ") GROUP BY customer_id";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        int customerid = rs.getInt("customer_id");
                        int contractCount = rs.getInt("contract_count");
                        list.stream().filter(a -> a.getId() == customerid).findFirst().ifPresent(a -> a.setContractCount(contractCount));
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
    }

    private String getSQLFilter(List<KeyValue> filters) {
        return filters != null && !filters.isEmpty() ? " AND id IN ( SELECT customer_id FROM customer_log WHERE old=0 AND field_key=? AND field_value LIKE ? )".repeat(filters.size()) : "";
    }

    public List<CustomerContactItem> getCustomerEmailsByContractId(int contractId) throws SQLException {
        JSONArray emails;
        int customerId;
        JSONObject customerJson;
        ArrayList<CustomerContactItem> contactItems = new ArrayList<CustomerContactItem>();
        Optional<CustomerLink> customerLink = this.getCustomerLink(contractId, LocalDateTime.now());
        if (customerLink.isPresent() && (customerJson = this.getCustomerDataJson(customerId = customerLink.get().getCustomerId()).optJSONObject(TABLE_CUSTOMER)) != null && (emails = (JSONArray)customerJson.optQuery("/contact/email")) != null) {
            for (int index = 0; index < emails.length(); ++index) {
                Object object = emails.get(index);
                if (!(object instanceof JSONObject)) continue;
                JSONObject email = (JSONObject)object;
                contactItems.add(new CustomerContactItem().setName(email.optString("name")).setValue(email.optString("value")));
            }
        }
        return contactItems;
    }

    public Optional<CustomerLink> getCustomerLink(int contractId, LocalDateTime dateTime) throws SQLException {
        String query = "SELECT * FROM customer_link WHERE contract_id=? AND ( date_from<=? AND (date_to IS NULL OR date_to>=?))";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp(dateTime));
            ps.setTimestamp(index, TimeUtils.convertLocalDateTimeToTimestamp(dateTime));
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    Optional<CustomerLink> optional = Optional.of(new CustomerLink().setCustomerId(rs.getInt("customer_id")).setContractId(rs.getInt("contract_id")).setCustomerAccount(rs.getLong("account")).setPeriod(new PeriodWithTime(rs.getTimestamp("date_from"), rs.getTimestamp("date_to"))));
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    public Map<Integer, JSONObject> getCustomerDataListForContracts(List<Integer> contractIds) throws SQLException {
        HashMap<Integer, JSONObject> result = new HashMap<Integer, JSONObject>();
        String query = "SELECT customer.data, link.contract_id FROM customer LEFT JOIN customer_link AS link ON customer.id=link.customer_id WHERE link.contract_id IN (" + Utils.toString(contractIds) + ") AND ( link.date_from<=? AND (link.date_to IS NULL OR link.date_to>=?))";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            LocalDateTime time = LocalDateTime.now();
            ps.setTimestamp(1, TimeUtils.convertLocalDateTimeToTimestamp(time));
            ps.setTimestamp(2, TimeUtils.convertLocalDateTimeToTimestamp(time));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.put(rs.getInt("link.contract_id"), new JSONObject(rs.getString("customer.data")));
                }
            }
        }
        return result;
    }

    public void addCustomerLink(CustomerLink customerLink) throws SQLException {
        if (customerLink == null) {
            return;
        }
        String query = "INSERT INTO customer_link SET customer_id=?, contract_id=?, date_from=?, date_to=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, customerLink.getCustomerId());
            ps.setInt(index++, customerLink.getContractId());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp(customerLink.getPeriod().getLocalDateTimeFrom()));
            ps.setTimestamp(index, TimeUtils.convertLocalDateTimeToTimestamp(customerLink.getPeriod().getLocalDateTimeTo()));
            ps.executeUpdate();
        }
    }

    public int getNewCustomerId(Customer.CustomerType type) throws SQLException {
        int customerId;
        String query = "INSERT INTO customer SET `type`=?, `data`=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setString(1, type.getType());
            ps.setString(2, "{}");
            ps.executeUpdate();
            customerId = ServerUtils.lastInsertId((PreparedStatement)ps);
        }
        return customerId;
    }

    public String updateCustomerFieldValue(int customerId, String fieldKey, String fieldValue, int userId) throws SQLException {
        String data = null;
        String querySelect = "SELECT data FROM customer WHERE id=?";
        String queryUpdate = "UPDATE customer SET data=? WHERE id=? AND data=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            int updateRow;
            do {
                String oldText;
                JSONObject customerFromDB;
                String oldData = "{}";
                psSelect.setInt(1, customerId);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        oldData = rs.getString("data");
                    }
                }
                JSONObject parentOfCustomer = customerFromDB = new JSONObject(oldData);
                String[] fields = (fieldKey.startsWith("/") ? fieldKey.substring(1) : fieldKey).split("/");
                for (int index = 0; index < fields.length - 1; ++index) {
                    JSONObject innerParent = parentOfCustomer.optJSONObject(fields[index]);
                    if (innerParent == null) {
                        innerParent = new JSONObject();
                        parentOfCustomer.put(fields[index], (Object)innerParent);
                    }
                    parentOfCustomer = innerParent;
                }
                String key = fields[fields.length - 1];
                String string = oldText = parentOfCustomer.has(key) ? parentOfCustomer.getString(key) : null;
                if (oldText != null && oldText.equals(fieldValue)) break;
                if (Utils.isBlankString(fieldValue) && this.isContactField(fieldKey)) {
                    JSONObject contacts = (JSONObject)parentOfCustomer.optQuery("/customer/contact");
                    if (contacts.has(fieldKey)) {
                        contacts.remove(fieldKey);
                    }
                } else if (Utils.isBlankString(fieldValue)) {
                    if (parentOfCustomer.has(key)) {
                        parentOfCustomer.remove(key);
                    }
                } else {
                    parentOfCustomer.put(key, (Object)fieldValue);
                }
                data = customerFromDB.toString();
                psUpdate.setString(1, data);
                psUpdate.setInt(2, customerId);
                psUpdate.setString(3, oldData);
                updateRow = psUpdate.executeUpdate();
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("updateCustomerFieldValue() => customerId = {}; newData = {}; oldData = {}; updateRow = {}", new Object[]{customerId, data, oldData, updateRow});
            } while (updateRow <= 0);
            this.updateLog(customerId, fieldKey, fieldValue, userId);
        }
        return data;
    }

    public String updateCustomerContact(int customerId, CustomerContactType contactType, String value, int userId) throws SQLException {
        String data = null;
        String querySelect = "SELECT data FROM customer WHERE id=?";
        String queryUpdate = "UPDATE customer SET data=? WHERE id=? AND data=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            int updateRow;
            do {
                JSONObject contact;
                String oldData = "{}";
                psSelect.setInt(1, customerId);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        oldData = rs.getString("data");
                    }
                }
                JSONObject customerFromDB = new JSONObject(oldData);
                JSONObject customer = (JSONObject)customerFromDB.optQuery("/customer");
                if (customer == null) {
                    customer = new JSONObject();
                    customerFromDB.put(TABLE_CUSTOMER, (Object)customer);
                }
                if ((contact = (JSONObject)customerFromDB.optQuery("/customer/contact")) == null) {
                    contact = new JSONObject();
                    customer.put("contact", (Object)contact);
                }
                String key = contactType.name().toLowerCase();
                if (Utils.notEmptyString(value)) {
                    contact.put(key, (Object)new JSONArray(value));
                } else if (contact.has(key)) {
                    contact.remove(key);
                }
                data = customerFromDB.toString();
                if (oldData.equals(data)) break;
                psUpdate.setString(1, data);
                psUpdate.setInt(2, customerId);
                psUpdate.setString(3, oldData);
                updateRow = psUpdate.executeUpdate();
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("updateCustomerContact() => customerId = {}; newData = {}; oldData = {}; updateRow = {}", new Object[]{customerId, data, oldData, updateRow});
            } while (updateRow <= 0);
            StringBuilder emails = new StringBuilder();
            new JSONArray(value).forEach(a -> emails.append(emails.length() > 0 ? "; " : "").append(((JSONObject)a).optString("value")));
            this.updateLog(customerId, contactType.key, emails.toString(), userId);
        }
        return data;
    }

    public String updateCustomerBank(int customerId, String text, int userId) throws SQLException {
        String data = null;
        String querySelect = "SELECT data FROM customer WHERE id=?";
        String queryUpdate = "UPDATE customer SET data=? WHERE id=? AND data=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            int updateRow;
            do {
                String oldData = "{}";
                psSelect.setInt(1, customerId);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        oldData = rs.getString("data");
                    }
                }
                JSONObject customerFromDB = new JSONObject(oldData);
                JSONObject customer = (JSONObject)customerFromDB.optQuery("/customer");
                if (customer == null) {
                    customer = new JSONObject();
                    customerFromDB.put(TABLE_CUSTOMER, (Object)customer);
                }
                if (Utils.notEmptyString(text)) {
                    JSONArray banks = new JSONArray(text);
                    for (int index = 0; index < banks.length(); ++index) {
                        JSONObject a2 = banks.getJSONObject(index);
                        if (!a2.optString("uuid").isBlank()) continue;
                        a2.put("uuid", (Object)UUID.randomUUID().toString());
                    }
                    customer.put("banks", (Object)banks);
                }
                if (oldData.equals(data = customerFromDB.toString())) break;
                psUpdate.setString(1, data);
                psUpdate.setInt(2, customerId);
                psUpdate.setString(3, oldData);
                updateRow = psUpdate.executeUpdate();
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("updateCustomerBank() => customerId = {}; newData = {}; oldData = {}; updateRow = {}", new Object[]{customerId, data, oldData, updateRow});
            } while (updateRow <= 0);
            StringBuilder banks = new StringBuilder();
            new JSONArray(text).forEach(a -> banks.append(banks.length() > 0 ? "; " : "").append(((JSONObject)a).optString("value")));
            this.updateLog(customerId, "/customer/bank", banks.toString(), userId);
        }
        return data;
    }

    public List<CustomerEmployee> customerEmployeeList(int customerId) throws SQLException {
        String query = "SELECT data FROM customer WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ArrayList<CustomerEmployee> customerEmployees = new ArrayList<CustomerEmployee>();
            ps.setInt(1, customerId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    JSONArray array;
                    JSONObject json = new JSONObject(rs.getString("data"));
                    if (json == null || (array = (JSONArray)json.optQuery("/customer/employee")) == null) continue;
                    for (int index = 0; index < array.length(); ++index) {
                        customerEmployees.add(CustomerEmployee.fromJSON(array.getJSONObject(index)));
                    }
                }
            }
            ArrayList<CustomerEmployee> arrayList = customerEmployees;
            return arrayList;
        }
    }

    public String customerEmployeeUpdate(int customerId, CustomerEmployee value, int userId) throws SQLException {
        String data = null;
        String querySelect = "SELECT data FROM customer WHERE id=?";
        String queryUpdate = "UPDATE customer SET data=? WHERE id=? AND data=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            int updateRow;
            if (Utils.isEmptyString(value.getUuid())) {
                value.setUuid(UUID.randomUUID().toString());
            }
            do {
                JSONArray employee;
                String oldData = "{}";
                psSelect.setInt(1, customerId);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        oldData = rs.getString("data");
                    }
                }
                JSONObject customerFromDB = new JSONObject(oldData);
                JSONObject customer = (JSONObject)customerFromDB.optQuery("/customer");
                if (customer == null) {
                    customer = new JSONObject();
                    customerFromDB.put(TABLE_CUSTOMER, (Object)customer);
                }
                if ((employee = (JSONArray)customer.optQuery("/employee")) == null) {
                    employee = new JSONArray();
                    customer.put("employee", (Object)employee);
                }
                boolean update = false;
                String uuid = value.getUuid();
                for (int index = 0; index < employee.length(); ++index) {
                    JSONObject json = employee.getJSONObject(index);
                    if (!json.optString("uuid").equals(uuid)) continue;
                    employee.put(index, (Object)value.toJSON());
                    update = true;
                }
                if (!update) {
                    employee.put((Object)value.toJSON());
                }
                if (oldData.equals(data = customerFromDB.toString())) break;
                psUpdate.setString(1, data);
                psUpdate.setInt(2, customerId);
                psUpdate.setString(3, oldData);
                updateRow = psUpdate.executeUpdate();
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("updateCustomerEmployee() => customerId = {}; newData = {}; oldData = {}; updateRow = {}", new Object[]{customerId, data, oldData, updateRow});
            } while (updateRow <= 0);
            this.updateLog(customerId, "/customer/employee-" + value.getUuid(), value.toJSON().toString(), userId);
        }
        return data;
    }

    public String customerEmployeeDelete(int customerId, String uuid, int userId) throws SQLException {
        String data = null;
        String querySelect = "SELECT data FROM customer WHERE id=?";
        String queryUpdate = "UPDATE customer SET data=? WHERE id=? AND data=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            int updateRow;
            do {
                JSONArray employee;
                String oldData = "{}";
                psSelect.setInt(1, customerId);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        oldData = rs.getString("data");
                    }
                }
                JSONObject customerFromDB = new JSONObject(oldData);
                JSONObject customer = (JSONObject)customerFromDB.optQuery("/customer");
                if (customer == null) {
                    customer = new JSONObject();
                    customerFromDB.put(TABLE_CUSTOMER, (Object)customer);
                }
                if ((employee = (JSONArray)customer.optQuery("/employee")) == null) {
                    employee = new JSONArray();
                    customer.put("employee", (Object)employee);
                }
                for (int index = 0; index < employee.length(); ++index) {
                    JSONObject json = employee.getJSONObject(index);
                    if (!json.optString("uuid").equals(uuid)) continue;
                    employee.remove(index);
                    break;
                }
                if (oldData.equals(data = customerFromDB.toString())) break;
                psUpdate.setString(1, data);
                psUpdate.setInt(2, customerId);
                psUpdate.setString(3, oldData);
                updateRow = psUpdate.executeUpdate();
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("updateCustomerEmployee() => customerId = {}; newData = {}; oldData = {}; updateRow = {}", new Object[]{customerId, data, oldData, updateRow});
            } while (updateRow <= 0);
            this.updateLog(customerId, "/customer/employee-" + uuid, null, userId);
        }
        return data;
    }

    private boolean isContactField(String fieldKey) {
        return fieldKey.contains("phone") || fieldKey.contains("home_phone") || fieldKey.contains("email");
    }

    private void updateLog(int customerId, String fieldKey, String fieldValue, int userId) throws SQLException {
        if (!((String)fieldKey).startsWith("/")) {
            fieldKey = "/" + (String)fieldKey;
        }
        if (this.isContactField((String)fieldKey) && !((String)fieldKey).startsWith("/customer/contact")) {
            fieldKey = "/customer/contact" + (String)fieldKey;
        }
        String queryUpdate = "UPDATE customer_log SET `old`=1 WHERE customer_id=? AND `field_key`=?";
        String queryInsert = "INSERT INTO customer_log SET `customer_id`=?, `update_time`=NOW(), `user_id`=?, `field_key`=?, `field_value`=?";
        try (PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);
             PreparedStatement psInsert = this.con.prepareStatement(queryInsert);){
            psUpdate.setInt(1, customerId);
            psUpdate.setString(2, (String)fieldKey);
            psUpdate.executeUpdate();
            int parameterIndex = 1;
            psInsert.setInt(parameterIndex++, customerId);
            psInsert.setInt(parameterIndex++, userId);
            psInsert.setString(parameterIndex++, (String)fieldKey);
            psInsert.setString(parameterIndex, Utils.maskBlank(fieldValue, ""));
            psInsert.executeUpdate();
        }
    }

    public JSONObject getCustomerDataJson(int customerId) throws SQLException {
        if (customerId <= 0) {
            return new JSONObject();
        }
        return new JSONObject(this.getCustomer(customerId).getData());
    }

    public Customer getCustomer(int customerId) throws SQLException {
        try (PreparedStatement psSelect = this.con.prepareStatement("SELECT * FROM customer WHERE id=?");){
            psSelect.setInt(1, customerId);
            try (ResultSet rs = psSelect.executeQuery();){
                if (rs.next()) {
                    Customer customer = new Customer().setId(customerId).setCustomerType(Customer.CustomerType.defineType(rs.getString("type"))).setData(rs.getString("data"));
                    return customer;
                }
            }
        }
        return null;
    }

    public JSONArray searchByKey(Customer.CustomerType customerType, String key, String value) throws SQLException {
        JSONArray customers = new JSONArray();
        String query = "SELECT c.`id`, c.`data` FROM customer AS c LEFT JOIN customer_log AS cl ON cl.`customer_id`=c.`id` WHERE c.`type`=? AND cl.`old`=0 AND cl.`field_key`=? AND cl.`field_value`=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setString(parameterIndex++, customerType.getType());
            psSelect.setString(parameterIndex++, key);
            psSelect.setString(parameterIndex, value);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    JSONObject customerFromDB = new JSONObject(rs.getString("data"));
                    JSONObject customer = new JSONObject();
                    if (customerType == Customer.CustomerType.JUR_CUSTOMER) {
                        customer.put("id", rs.getInt("id"));
                        customer.put("title", customerFromDB.optQuery(Customer.Keys.NAME.key()));
                        customer.put("inn", customerFromDB.optQuery(Customer.Keys.INN.key()));
                        customer.put("ogrn", customerFromDB.optQuery(Customer.Keys.OGRN.key()));
                    } else if (customerType == Customer.CustomerType.FIZ_CUSTOMER) {
                        StringBuilder fio = new StringBuilder();
                        Object last = customerFromDB.optQuery(Customer.Keys.LAST_NAME.key());
                        fio.append((String)(last == null ? "" : String.valueOf(last) + " "));
                        Object first = customerFromDB.optQuery(Customer.Keys.FIRST_NAME.key());
                        fio.append((String)(first == null ? "" : String.valueOf(first) + " "));
                        Object middle = customerFromDB.optQuery(Customer.Keys.MIDDLE_NAME.key());
                        fio.append(middle == null ? "" : String.valueOf(middle));
                        StringBuilder passport = new StringBuilder();
                        Object passportRF = customerFromDB.optQuery(Customer.CustomerFizDocument.PASSPORT_RF.key());
                        if (passportRF != null) {
                            JSONObject passportObject = (JSONObject)passportRF;
                            passport.append(passportObject.optString("series")).append(" ").append(passportObject.optString("number"));
                        }
                        Object birthday = customerFromDB.optQuery(Customer.Keys.BIRTHDAY.key());
                        customer.put("id", rs.getInt("id"));
                        customer.put("title", (Object)fio.toString().trim());
                        customer.put("birthday", (Object)(birthday == null ? "" : TimeUtils.format(LocalDate.parse((String)birthday), "dd.MM.yyyy")));
                        customer.put("passport", (Object)passport.toString().trim());
                    }
                    customers.put((Object)customer);
                }
            }
        }
        return customers;
    }

    public void setCustomerLink(int contractId, int customerId, LocalDateTime linkDateTimeFrom) throws SQLException {
        if (linkDateTimeFrom == null) {
            return;
        }
        String selectQuery = "SELECT * FROM customer_link WHERE contract_id=?";
        String insertQuery = "INSERT INTO customer_link SET contract_id=?, customer_id=?, date_from=?";
        String updateQuery = "UPDATE customer_link SET date_to=? WHERE contract_id=? AND customer_id=? AND date_from=?";
        String deleteQuery = "DELETE FROM customer_link WHERE contract_id=? AND customer_id=? AND date_from=? AND date_to=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(selectQuery);
             PreparedStatement psInsert = this.con.prepareStatement(insertQuery);
             PreparedStatement psUpdate = this.con.prepareStatement(updateQuery);
             PreparedStatement psDelete = this.con.prepareStatement(deleteQuery);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, contractId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    int linkCustomerId = rs.getInt("customer_id");
                    LocalDateTime dateFrom = TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp("date_from"));
                    LocalDateTime dateTo = TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp("date_to"));
                    if (dateFrom != null && dateFrom.isBefore(linkDateTimeFrom) && dateTo != null && dateTo.isBefore(linkDateTimeFrom)) continue;
                    if (dateFrom != null && linkDateTimeFrom.isBefore(dateFrom)) {
                        parameterIndex = 1;
                        psDelete.setInt(parameterIndex++, contractId);
                        psDelete.setInt(parameterIndex++, linkCustomerId);
                        psDelete.setTimestamp(parameterIndex++, rs.getTimestamp("date_from"));
                        psDelete.setTimestamp(parameterIndex, rs.getTimestamp("date_to"));
                        psDelete.executeUpdate();
                        continue;
                    }
                    if (dateFrom == null || !dateFrom.isBefore(linkDateTimeFrom) || dateTo != null && !linkDateTimeFrom.isBefore(dateTo)) continue;
                    parameterIndex = 1;
                    psUpdate.setTimestamp(parameterIndex++, TimeUtils.convertLocalDateTimeToTimestamp(linkDateTimeFrom.minusSeconds(1L)));
                    psUpdate.setInt(parameterIndex++, contractId);
                    psUpdate.setInt(parameterIndex++, linkCustomerId);
                    psUpdate.setTimestamp(parameterIndex, rs.getTimestamp("date_from"));
                    psUpdate.executeUpdate();
                }
            }
            parameterIndex = 1;
            psInsert.setInt(parameterIndex++, contractId);
            psInsert.setInt(parameterIndex++, customerId);
            psInsert.setTimestamp(parameterIndex, TimeUtils.convertLocalDateTimeToTimestamp(linkDateTimeFrom));
            psInsert.executeUpdate();
        }
    }

    public List<CustomerContract> getCustomerContracts(int customerId, LocalDateTime onTime) throws SQLException {
        ArrayList<CustomerContract> contracts = new ArrayList<CustomerContract>();
        String selectQuery = "SELECT c.id, c.title, c.comment, cl.account FROM customer_link AS cl LEFT JOIN contract AS c ON c.id=cl.contract_id WHERE cl.customer_id=?" + (onTime != null ? " AND ( cl.date_from IS NULL OR cl.date_from<?) AND ( cl.date_to IS NULL OR cl.date_to>? )" : "");
        try (PreparedStatement psSelect = this.con.prepareStatement(selectQuery);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, customerId);
            if (onTime != null) {
                psSelect.setTimestamp(parameterIndex++, TimeUtils.convertLocalDateTimeToTimestamp(onTime));
                psSelect.setTimestamp(parameterIndex, TimeUtils.convertLocalDateTimeToTimestamp(onTime));
            }
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    int id = rs.getInt("id");
                    if (id <= 0) continue;
                    contracts.add(new CustomerContract().setContractId(id).setTitle(rs.getString("title")).setComment(rs.getString("comment")).setAccount(rs.getLong("account")));
                }
            }
        }
        return contracts;
    }

    public boolean setCustomerUnlinkContract(int contractId, LocalDateTime unlinkTime) throws SQLException {
        boolean result;
        String updateQuery = "UPDATE customer_link SET date_to=? WHERE contract_id=? AND date_to IS NULL";
        try (PreparedStatement psUpdate = this.con.prepareStatement(updateQuery);){
            int parameterIndex = 1;
            psUpdate.setTimestamp(parameterIndex++, TimeUtils.convertLocalDateTimeToTimestamp(unlinkTime));
            psUpdate.setInt(parameterIndex, contractId);
            result = psUpdate.executeUpdate() > 0;
        }
        return result;
    }

    public String getCustomerParameterHistory(int customerId, String fieldKey, int lastRecordCount) throws SQLException {
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM `customer_log` WHERE `customer_id`=? AND `field_key`=? ORDER BY `update_time` DESC " + (lastRecordCount > 0 ? " LIMIT ?" : "");
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, customerId);
            psSelect.setString(parameterIndex++, fieldKey);
            if (lastRecordCount > 0) {
                psSelect.setInt(parameterIndex, lastRecordCount);
            }
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    JSONObject json = new JSONObject();
                    json.put("value", (Object)rs.getString("field_value"));
                    json.put("date", (Object)TimeUtils.format((Date)rs.getTimestamp("update_time"), "dd.MM.yyyy HH:mm:ss"));
                    json.put("userId", rs.getInt("user_id"));
                    jsonArray.put((Object)json);
                }
            }
        }
        return jsonArray.toString();
    }

    public String getCustomerParameter(int customerId, String fieldKey) throws SQLException {
        String value = null;
        String query = "SELECT * FROM `customer_log` WHERE `customer_id`=? AND old=0 AND `field_key`=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            psSelect.setInt(parameterIndex++, customerId);
            psSelect.setString(parameterIndex++, fieldKey);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    value = rs.getString("field_value");
                }
            }
        }
        return value;
    }

    public void deleteCustomer(int customerId) throws SQLException {
        String queryDelete = "DELETE FROM customer WHERE id=?";
        String queryDeleteLog = "DELETE FROM customer_log WHERE customer_id=?";
        String queryDeleteLink = "DELETE FROM customer_link WHERE customer_id=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);
             PreparedStatement psDeleteLog = this.con.prepareStatement(queryDeleteLog);
             PreparedStatement psDeleteLink = this.con.prepareStatement(queryDeleteLink);){
            psDelete.setInt(1, customerId);
            psDelete.executeUpdate();
            psDeleteLog.setInt(1, customerId);
            psDeleteLog.executeUpdate();
            psDeleteLink.setInt(1, customerId);
            psDeleteLink.executeUpdate();
        }
    }

    public Customer customerByCustomerAccount(long account) throws SQLException {
        Customer customer = null;
        String query = "SELECT * FROM customer_account AS ca LEFT JOIN customer AS c ON c.id=ca.customer_id WHERE ca.account=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setLong(1, account);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    customer = new Customer().setId(rs.getInt("id")).setCustomerType(Customer.CustomerType.defineType(rs.getString("type"))).setData(rs.getString("data"));
                }
            }
        }
        return customer;
    }

    public List<CustomerAccount> customerAccounts(int customerId) throws SQLException {
        ArrayList<CustomerAccount> accounts = new ArrayList<CustomerAccount>();
        accounts.add(new CustomerAccount());
        String querySelect = "SELECT * FROM customer_account WHERE `customer_id`=? ORDER BY `account`";
        String querySelectCount = "SELECT `account`, COUNT(*) FROM customer_link WHERE `customer_id`=? AND `date_from`<now() AND `date_to` IS NULL GROUP BY `account`";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psSelectCount = this.con.prepareStatement(querySelectCount);){
            psSelect.setInt(1, customerId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    accounts.add(new CustomerAccount(rs.getLong("account"), 0));
                }
            }
            psSelectCount.setInt(1, customerId);
            rs = psSelectCount.executeQuery();
            try {
                while (rs.next()) {
                    long account = rs.getLong(1);
                    int count = rs.getInt(2);
                    accounts.stream().filter(a -> a.getAccount() == account).forEach(a -> a.setContractCount(count));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        return accounts;
    }

    public CustomerAccount customerAccountAdd(int customerId, long account, int userId) throws SQLException {
        CustomerAccount customerAccount = new CustomerAccount();
        customerAccount.setAccount(account);
        long freeStart = Setup.getSetup().getLong("customer.account.mode.free.start", 0L);
        String accountMode = Setup.getSetup().get("customer.account.mode", "max");
        String querySelect = "SELECT a+1 FROM (SELECT @account a, @account := `account` b FROM customer_account, (SELECT @account := NULL)T WHERE `account`>=? ORDER BY `account`)T WHERE a+1<>b LIMIT 1";
        String queryInsert = "INSERT customer_account SET " + (account > 0L || "free".equals(accountMode) ? "`account`=?, " : "") + "`customer_id`=?, `user_id`=?";
        String queryUpdate = "UPDATE customer_account SET `customer_id`=? WHERE `account`=? AND `customer_id`=0";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);
             PreparedStatement psInsert = this.con.prepareStatement(queryInsert, 1);){
            if (account == 0L && "free".equals(accountMode)) {
                psSelect.setLong(1, freeStart);
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        account = rs.getLong(1);
                    }
                }
                if (account == 0L) {
                    account = 1L;
                }
            }
            customerAccount.setAccount(account);
            boolean update = false;
            if (account > 0L) {
                psUpdate.setInt(1, customerId);
                psUpdate.setLong(2, account);
                boolean bl = update = psUpdate.executeUpdate() > 0;
            }
            if (!update) {
                int index = 1;
                if (account > 0L) {
                    psInsert.setLong(index++, account);
                }
                psInsert.setInt(index++, customerId);
                psInsert.setInt(index++, userId);
                psInsert.executeUpdate();
                customerAccount.setAccount(ServerUtils.lastInsertLongId((PreparedStatement)psInsert));
            }
        }
        return customerAccount;
    }

    public void customerAccountDelete(int customerId, long account) throws SQLException {
        String querySelect = "SELECT count(*) FROM customer_link WHERE `account`=? AND `customer_id`=? AND date_from<now() AND date_to IS NULL";
        String queryUpdate = "UPDATE customer_account SET customer_id=0 WHERE account=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            psSelect.setLong(1, account);
            psSelect.setInt(2, customerId);
            try (ResultSet rs = psSelect.executeQuery();){
                int count = 0;
                while (rs.next()) {
                    count = rs.getInt(1);
                }
                if (count > 0) {
                    throw new SQLException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 (" + count + " \u0434\u043e\u0433.)");
                }
                psUpdate.setLong(1, account);
                psUpdate.executeUpdate();
            }
        }
    }

    public void customerAccountSet(int customerId, int contractId, long account) throws SQLException {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE customer_link SET `account`=? WHERE `customer_id`=? AND `contract_id`=? AND `date_from`<=now() AND `date_to` IS NULL");){
            ps.setLong(1, account);
            ps.setInt(2, customerId);
            ps.setInt(3, contractId);
            ps.executeUpdate();
        }
    }
}

