/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.limit.server.bean;

import bitel.billing.server.contract.bean.LimitChangeTask;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitAvto;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitAvtoStatus;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitLog;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitParameters;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractSubPanelManage;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.ContractLimitLogManager;
import ru.bitel.bgbilling.kernel.contract.limit.server.bean.LimitManagerConfig;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.LimitChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.SystemLimitChangedEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public final class LimitManager
extends BGLogger {
    public static final int VPAY_NOT_PAYOFFED = 0;
    public static final int VPAY_PARTIAL_PAYOFFED = 1;
    public static final int VPAY_PAYOFFED = 2;
    public static final int VPAY_EXPIRED = 3;
    private static final int MODE_ENABLED = 0;
    private static final int MODE_DISABLED = 1;
    private static final int MODE_DISABLED_FOR_EXPIRED = 2;
    public static final Object limitMutex = new Object();
    private PreparedStatement psSelectPeriodLimits;
    private PreparedStatement psUpdatePeriodLimit;
    private PreparedStatement psDeletePeriodLimit;
    private PreparedStatement psUpdateLimit;
    private PreparedStatement psGetUserLimitMove;
    private PreparedStatement psUpdateUserLimitMoveStatus;
    private PreparedStatement psUpdateUserLimitManageMode;
    private PreparedStatement psInsertManageMode;
    private Connection con;

    public LimitManager(Connection con) {
        this.con = con;
    }

    public void searchContractLimitAvto(SearchResult<ContractLimitAvto> searchResult, int contractId, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            if (page == null) {
                throw new BGException("Page is null");
            }
            List<ContractLimitAvto> list = searchResult.getList();
            boolean statusFilter = status != null && !ContractLimitAvtoStatus.ALL.getCode().equals(status);
            String query = "SELECT SQL_CALC_FOUND_ROWS * FROM contract_limit_period WHERE cid=?" + (statusFilter ? " AND status=?" : "") + " ORDER BY dt" + Page.toSqlLimit(page);
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                ps.setInt(1, contractId);
                if (statusFilter) {
                    ps.setString(2, status);
                }
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        ContractLimitAvto contractLimitAvto = new ContractLimitAvto();
                        contractLimitAvto.setId(rs.getInt("id"));
                        contractLimitAvto.setUserId(rs.getInt("uid"));
                        User user = UserMap.getUser((Integer)contractLimitAvto.getUserId());
                        contractLimitAvto.setUserName(user == null ? "???" : user.getName());
                        contractLimitAvto.setDate(rs.getDate("dt"));
                        contractLimitAvto.setValue(rs.getBigDecimal("value"));
                        contractLimitAvto.setStatus(rs.getString("status"));
                        list.add(contractLimitAvto);
                    }
                }
                Page.setRecordCount(page, ServerUtils.foundRows((Connection)this.con));
            }
            catch (Exception ex) {
                throw new BGException(ex);
            }
        }
    }

    public List<LimitChangeTask> getContractMoveTasks(int contractId) throws SQLException {
        ArrayList<LimitChangeTask> result = new ArrayList<LimitChangeTask>();
        String query = "SELECT per.*, low.id as low_id FROM contract_limit_period as per LEFT JOIN contract_limit_manage as low ON per.id=low.clp_id WHERE per.cid=? AND per.status=? ORDER BY dt";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setString(2, ContractLimitAvtoStatus.ON.getCode());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getMoveFromRSContract(rs));
                }
            }
        }
        return result;
    }

    public int addMoveTask(LimitChangeTask task) throws BGException {
        int id = -1;
        String query = "INSERT INTO contract_limit_period SET cid=?, dt=?, uid=?, value=?, status=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setInt(1, task.getContractId());
            ps.setDate(2, TimeUtils.convertDateToSqlDate(task.getDate()));
            ps.setInt(3, task.getUserId());
            ps.setBigDecimal(4, task.getDeltaSum());
            ps.setString(5, task.getStatus().getCode());
            ps.executeUpdate();
            id = ServerUtils.lastInsertId((PreparedStatement)ps);
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return id;
    }

    public void cancelMoveTask(int contractId, List<Integer> taskIds) throws SQLException {
        String querySelect = "SELECT id FROM contract_limit_manage WHERE cid=? AND clp_id=?";
        String queryUpdate = "UPDATE contract_limit_period SET status=? WHERE id=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            for (int taskId : taskIds) {
                psSelect.setInt(1, contractId);
                psSelect.setInt(2, taskId);
                boolean fl = psSelect.executeQuery().next();
                if (fl) {
                    throw new SQLException("\u0414\u0430\u043d\u043d\u043e\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0441\u043e\u0437\u0434\u0430\u043d\u043e \u0434\u043b\u044f \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0435\u0433\u043e \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c. \u0415\u0433\u043e \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c.");
                }
                psUpdate.setString(1, ContractLimitAvtoStatus.CANCEL.getCode());
                psUpdate.setInt(2, taskId);
                psUpdate.executeUpdate();
            }
        }
    }

    public void deleteMoveTaskAndLog(int taskId, int contractId, int userId) throws SQLException {
        String queryDelete = "DELETE FROM contract_limit_manage WHERE clp_id=? AND cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(queryDelete);){
            this.cancelMoveTask(contractId, Arrays.asList(taskId));
            ps.setInt(1, taskId);
            ps.setInt(2, contractId);
            ps.executeUpdate();
            new ContractLimitLogManager(this.con).deleteContractLimitLog(contractId, -1);
        }
    }

    public List<LimitChangeTask> getFullTaskList() throws SQLException {
        ArrayList<LimitChangeTask> result = new ArrayList<LimitChangeTask>();
        String query = "SELECT * FROM contract_limit_period GROUP BY cid";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getMoveFromRS(rs));
            }
        }
        return result;
    }

    private LimitChangeTask getMoveFromRS(ResultSet rs) throws SQLException {
        LimitChangeTask limitMove = new LimitChangeTask();
        limitMove.setId(rs.getInt("id"));
        limitMove.setContractId(rs.getInt("cid"));
        limitMove.setDate((Date)rs.getDate("dt"));
        limitMove.setUserId(rs.getInt("uid"));
        limitMove.setDeltaSum(rs.getBigDecimal("value"));
        limitMove.setStatus(ContractLimitAvtoStatus.ALL.getStatusByCode(rs.getString("status")));
        return limitMove;
    }

    private LimitChangeTask getMoveFromRSContract(ResultSet rs) throws SQLException {
        LimitChangeTask limitMove = this.getMoveFromRS(rs);
        limitMove.setCreateByContract(rs.getInt("low_id") != 0);
        return limitMove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContractLimit(int userId, BigDecimal limitValue, int contractId, String comment, int days) throws SQLException {
        Object object = limitMutex;
        synchronized (object) {
            ContractLimitLog contractLimitLog = new ContractLimitLog().setUserId(userId).setLimitValue(limitValue).setContractId(contractId).setComment(comment).setDays(days);
            String query = "UPDATE contract SET closesumma=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                new ContractLimitLogManager(this.con).addContractLimitLog(contractLimitLog);
                ps.setBigDecimal(1, limitValue);
                ps.setInt(2, contractId);
                ps.executeUpdate();
            }
        }
    }

    public boolean initRestoreLimitTask(Calendar date) {
        boolean result = false;
        try {
            String query = "SELECT id, cid, value FROM contract_limit_period WHERE dt<=? AND status=? ORDER BY id";
            this.psSelectPeriodLimits = this.con.prepareStatement(query);
            this.psSelectPeriodLimits.setDate(1, TimeUtils.convertCalendarToSqlDate(date));
            this.psSelectPeriodLimits.setString(2, ContractLimitAvtoStatus.ON.getCode());
            query = "UPDATE contract_limit_period SET status=? WHERE id=?";
            this.psUpdatePeriodLimit = this.con.prepareStatement(query);
            this.psUpdatePeriodLimit.setString(1, ContractLimitAvtoStatus.OFF.getCode());
            query = "DELETE FROM contract_limit_period WHERE dt< NOW() - INTERVAL 1 YEAR";
            this.psDeletePeriodLimit = this.con.prepareStatement(query);
            query = "UPDATE contract SET closesumma=closesumma-? WHERE id=?";
            this.psUpdateLimit = this.con.prepareStatement(query);
            query = "SELECT * FROM contract_limit_manage WHERE clp_id=? AND cid=? ";
            this.psGetUserLimitMove = this.con.prepareStatement(query);
            this.psUpdateUserLimitMoveStatus = this.con.prepareStatement("UPDATE contract_limit_manage SET status=?, clp_id = NULL WHERE id=? ");
            this.psUpdateUserLimitManageMode = this.con.prepareStatement("UPDATE contract_limit_manage_mode SET cnt=cnt+1 WHERE cid=?");
            this.psInsertManageMode = this.con.prepareStatement("INSERT INTO contract_limit_manage_mode SET cid=?, mode=?, cnt=?");
            result = true;
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeRestoreLimitTask(Calendar now, String comment) {
        Object object = limitMutex;
        synchronized (object) {
            try (ContractDao contractDao = new ContractDao(this.con, 0);
                 BalanceUtils balanceUtils = new BalanceUtils(this.con);
                 ResultSet rs = this.psSelectPeriodLimits.executeQuery();){
                ContractLimitLogManager contractLimitLogManager = new ContractLimitLogManager(this.con);
                while (rs.next()) {
                    int id = rs.getInt(1);
                    int contractId = rs.getInt(2);
                    BigDecimal value = Utils.maskNull(rs.getBigDecimal(3));
                    this.psUpdatePeriodLimit.setInt(2, id);
                    this.psUpdatePeriodLimit.executeUpdate();
                    if (value.equals(BigDecimal.ZERO)) continue;
                    this.psUpdateLimit.setBigDecimal(1, value);
                    this.psUpdateLimit.setInt(2, contractId);
                    this.psUpdateLimit.executeUpdate();
                    Contract contract = (Contract)contractDao.get(contractId);
                    if (contract != null) {
                        BigDecimal contractBalance = balanceUtils.getBalance(new Date(), contract);
                        this.psGetUserLimitMove.setInt(1, id);
                        this.psGetUserLimitMove.setInt(2, contractId);
                        try (ResultSet rs2 = this.psGetUserLimitMove.executeQuery();){
                            if (rs2.next()) {
                                if (contractBalance.compareTo(contract.getBalanceLimit()) < 0) {
                                    if (rs2.getInt("status") != 3) {
                                        this.psUpdateUserLimitMoveStatus.setInt(1, 3);
                                        this.psUpdateUserLimitMoveStatus.setInt(2, rs2.getInt("id"));
                                        this.psUpdateUserLimitMoveStatus.executeUpdate();
                                        this.psUpdateUserLimitManageMode.setInt(1, contractId);
                                        if (this.psUpdateUserLimitManageMode.executeUpdate() <= 0) {
                                            this.psInsertManageMode.setInt(1, contractId);
                                            this.psInsertManageMode.setInt(2, 0);
                                            this.psInsertManageMode.setInt(3, 1);
                                            this.psInsertManageMode.executeUpdate();
                                        }
                                    }
                                } else {
                                    this.psUpdateUserLimitMoveStatus.setInt(1, 2);
                                    this.psUpdateUserLimitMoveStatus.setInt(2, rs2.getInt("id"));
                                    this.psUpdateUserLimitMoveStatus.executeUpdate();
                                }
                            }
                        }
                    }
                    EventProcessor.getInstance().publish(new SystemLimitChangedEvent(contractId, contract.getBalanceLimit()));
                    EventProcessor.getInstance().publish(new LimitChangedEvent(contractId, contract.getBalanceLimit()));
                    ContractLimitLog contractLimitLog = new ContractLimitLog().setUserId(0).setLimitValue(contract.getBalanceLimit()).setContractId(contractId).setComment(comment);
                    contractLimitLogManager.addContractLimitLog(contractLimitLog);
                }
                this.psDeletePeriodLimit.executeUpdate();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreLimit(Connection con, int id, int contractId, BigDecimal limitValue) {
        Object object = limitMutex;
        synchronized (object) {
            block24: {
                try {
                    if (limitValue.compareTo(BigDecimal.ZERO) == 0) break block24;
                    String query = "DELETE FROM contract_limit_period WHERE id=?";
                    try (PreparedStatement ps = con.prepareStatement(query);){
                        ps.setInt(1, id);
                        ps.executeUpdate();
                    }
                    query = "UPDATE contract_limit_manage SET clp_id = NULL WHERE clp_id=?";
                    ps = con.prepareStatement(query);
                    try {
                        ps.setInt(1, id);
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    query = "UPDATE contract SET closesumma=closesumma-? WHERE id=?";
                    ps = con.prepareStatement(query);
                    try {
                        ps.setBigDecimal(1, limitValue);
                        ps.setInt(2, contractId);
                        ps.executeUpdate();
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    Contract contract = ContractDao.getContract(con, contractId);
                    if (contract != null) {
                        ContractLimitLog contractLimitLog = new ContractLimitLog().setLimitValue(contract.getBalanceLimit()).setUserId(0).setContractId(contractId).setComment("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u0430 \u043d\u0430 " + limitValue.toPlainString());
                        new ContractLimitLogManager(con).addContractLimitLog(contractLimitLog);
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void clientPaymentEvent(PaymentEvent event) throws BGException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ContractLimitParameters getContractLimitParameters(Setup setup, Contract contract) throws BGException {
        Objects.requireNonNull(setup, "setup is null");
        Objects.requireNonNull(contract, "contract is null");
        List<ContractLimitParameters> contractLimitParameters = ((LimitManagerConfig)setup.getConfig((int)0, LimitManagerConfig.class)).contractLimitParameters;
        if (contractLimitParameters == null) {
            contractLimitParameters = LimitManagerConfig.load(setup);
        }
        try {
            ContractLabelManager contractLabelManager = new ContractLabelManager(this.con);
            List<Integer> contractLableIds = contractLabelManager.getContractLabelIds(contract.getId());
            this.getLogger().debug("contractLableIds = {}", (Object)Utils.toString(contractLableIds));
            for (ContractLimitParameters l : contractLimitParameters) {
                this.getLogger().debug("contractLimitParameters = {}", (Object)Utils.toString(l.getContractLabelIds()));
                if (!l.getContractLabelIds().stream().anyMatch(a -> contractLableIds.contains(a))) continue;
                int mode = 1;
                int cnt = 0;
                try (PreparedStatement ps = this.con.prepareStatement("SELECT mode, cnt FROM contract_limit_manage_mode WHERE cid=?");){
                    ps.setInt(1, contract.getId());
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            mode = rs.getInt(1);
                            cnt = rs.getInt(2);
                        }
                    }
                }
                switch (mode) {
                    case 1: {
                        throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430");
                    }
                    case 2: {
                        throw new BGMessageException(setup.get("limit.max.nopayed.msg", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430"));
                    }
                }
                if (l.getMaxExpiredForBlock() > 0 && l.getMaxExpiredForBlock() <= cnt) {
                    this.setLimitManageMode(0, contract.getId(), 2);
                    throw new BGMessageException(setup.get("limit.max.nopayed.msg", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430"));
                }
                int notPayoffed = 0;
                int partialPayoffed = 0;
                try (PreparedStatement ps = this.con.prepareStatement("SELECT COUNT(id) FROM contract_limit_manage WHERE cid=? AND status=?");){
                    ps.setInt(1, contract.getId());
                    ps.setInt(2, 0);
                    try (ResultSet rs = ps.executeQuery();){
                        notPayoffed = rs.next() ? rs.getInt(1) : 0;
                    }
                    ps.setInt(2, 1);
                    rs = ps.executeQuery();
                    try {
                        partialPayoffed = rs.next() ? rs.getInt(1) : 0;
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                if (l.getMaxNotPayoffed() < notPayoffed || l.getMaxPartialPayoffed() < partialPayoffed) {
                    throw new BGMessageException(setup.get("limit.max.current.msg", "\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043e\u043d\u0438\u0437\u0438\u0442\u044c \u043b\u0438\u043c\u0438\u0442. \u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435 \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0445 \u0438/\u0438\u043b\u0438 \u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439"));
                }
                LocalDate lastDate = null;
                try (PreparedStatement ps = this.con.prepareStatement("SELECT MAX(date1) FROM contract_limit_manage WHERE cid=?");){
                    ps.setInt(1, contract.getId());
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            Timestamp timestamp = rs.getTimestamp(1);
                            lastDate = timestamp != null ? TimeUtils.convertTimestampToLocalDateTime(timestamp).toLocalDate() : null;
                        }
                    }
                }
                if (lastDate != null && (lastDate = lastDate.plusDays(l.getDelayDays())).isAfter(LocalDate.now())) {
                    throw new BGMessageException(setup.get("limit.delay.msg", "\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043e\u043d\u0438\u0437\u0438\u0442\u044c \u043b\u0438\u043c\u0438\u0442. \u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0434\u043e " + TimeUtils.format(lastDate, "dd.MM.yyyy")));
                }
                return l;
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430 (\u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lowLimit(int cntractId, BigDecimal sum, int days) throws BGException {
        Object object = limitMutex;
        synchronized (object) {
            GregorianCalendar now = new GregorianCalendar();
            Calendar limitDate = (Calendar)((Calendar)now).clone();
            limitDate.add(5, days);
            try {
                BigDecimal newLimit = ContractDao.getContract(this.con, cntractId).getBalanceLimit().subtract(sum);
                this.updateContractLimit(-1, newLimit, cntractId, "", days);
                LimitChangeTask task = new LimitChangeTask();
                task.setContractId(cntractId);
                task.setUserId(-1);
                task.setDate(limitDate.getTime());
                task.setDeltaSum(sum.negate());
                int taskId = this.addMoveTask(task);
                String query = "INSERT INTO contract_limit_manage (cid, clp_id, summ, date1, date2, status) VALUES (?,?,?,?,?,?)";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    ps.setInt(1, cntractId);
                    ps.setInt(2, taskId);
                    ps.setBigDecimal(3, sum);
                    ps.setTimestamp(4, TimeUtils.convertCalendarToTimestamp(now));
                    ps.setTimestamp(5, TimeUtils.convertCalendarToTimestamp(limitDate));
                    ps.setInt(6, 0);
                    ps.executeUpdate();
                }
                if (!this.con.getAutoCommit()) {
                    this.con.commit();
                }
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
    }

    public List<UserLimitMove> getUserLimitMove(int contractId, int yy, int mm) {
        GregorianCalendar date1 = new GregorianCalendar(yy, mm - 1, 1);
        Calendar date2 = (Calendar)((Calendar)date1).clone();
        date2.add(2, 1);
        date2.add(5, -1);
        return this.getUserLimitMove(contractId, date1, date2);
    }

    public List<UserLimitMove> getUserLimitMove(int contractId, Calendar date1, Calendar date2) {
        ArrayList<UserLimitMove> result = new ArrayList<UserLimitMove>();
        String query = "SELECT * FROM contract_limit_manage WHERE cid=?" + (date1 != null ? " AND (date2 IS NULL OR date2>?)" : "") + (date2 != null ? " AND (date1 IS NULL OR date1<?)" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, contractId);
            if (date1 != null) {
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate(date1));
            }
            if (date2 != null) {
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate(date2));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    UserLimitMove m = new UserLimitMove(this);
                    m.date1 = TimeUtils.convertTimestampToCalendar(rs.getTimestamp("date1"));
                    m.date2 = TimeUtils.convertDateToCalendar(rs.getDate("date2"));
                    m.summ = rs.getFloat("summ");
                    m.status = rs.getInt("status");
                    m.id = rs.getInt("id");
                    result.add(m);
                }
            }
        }
        catch (SQLException ex) {
            this.logError(ex);
        }
        return result;
    }

    public int getLimitMode(int contractId) throws BGException {
        int mode = 0;
        String query = "SELECT mode FROM contract_limit_manage_mode WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    mode = rs.getInt(1);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return mode;
    }

    public List<ContractSubPanelManage> getContractManage(SearchResult<ContractSubPanelManage> searchResult, int contractId) throws BGException {
        PreparedStatement ps;
        Page page = searchResult.getPage();
        ArrayList<ContractSubPanelManage> list = new ArrayList<ContractSubPanelManage>();
        searchResult.setAttribute("mode", String.valueOf(this.getLimitMode(contractId)));
        Object query = "SELECT dt, uid, mode FROM log_contract_limit_manage_mode WHERE cid=? ORDER BY dt " + Page.toSqlLimit(page);
        try {
            ps = this.con.prepareStatement((String)query);
            try {
                ps.setInt(1, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        User u = UserMap.getUser((Integer)rs.getInt(2));
                        ContractSubPanelManage manage = new ContractSubPanelManage();
                        manage.setContractId(contractId);
                        manage.setDate(rs.getTimestamp(1));
                        manage.setUser(u != null ? u.getTitle() : "?????");
                        manage.setValue(rs.getInt(3) == 0 ? "\u0440\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e" : "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u043e");
                        list.add(manage);
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        query = "SELECT COUNT(*) FROM log_contract_limit_manage_mode where cid=? ";
        try {
            ps = this.con.prepareStatement((String)query);
            try {
                ps.setInt(1, contractId);
                int records = 0;
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        records = rs.getInt(1);
                    }
                }
                Page.setRecordCount(page, records);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return list;
    }

    public void setLimitManageMode(int userId, int contractId, int mode) throws BGException {
        PreparedStatement ps;
        boolean update = false;
        String query = "UPDATE contract_limit_manage_mode SET mode=?, cnt=? WHERE cid=?";
        try {
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, mode);
                ps.setInt(2, 0);
                ps.setInt(3, contractId);
                update = ps.executeUpdate() > 0;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        if (!update) {
            query = "INSERT INTO contract_limit_manage_mode SET cid=?, mode=?";
            try {
                ps = this.con.prepareStatement(query);
                try {
                    ps.setInt(1, contractId);
                    ps.setInt(2, mode);
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException ex) {
                throw new BGException(ex);
            }
        }
        query = "INSERT INTO log_contract_limit_manage_mode VALUES ( now(), ?, ?, ? )";
        try {
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, userId);
                ps.setInt(2, mode);
                ps.setInt(3, contractId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public class UserLimitMove {
        private int id;
        private float summ;
        private Calendar date1;
        private Calendar date2;
        private int status;

        public UserLimitMove(LimitManager this$0) {
        }

        public Calendar getDate1() {
            return this.date1;
        }

        public void setDate1(Calendar date1) {
            this.date1 = date1;
        }

        public Calendar getDate2() {
            return this.date2;
        }

        public void setDate2(Calendar date2) {
            this.date2 = date2;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public float getSumm() {
            return this.summ;
        }

        public void setSumm(float summ) {
            this.summ = summ;
        }
    }
}

