/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObjectType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;

public class ContractObjectTypeDao
extends AbstractDirectoryIdDao<ContractObjectType> {
    private PreparedStatement getModuleIdsPS = null;

    public ContractObjectTypeDao(Connection con) {
        super(con, 0, "object_type");
    }

    @Override
    protected ContractObjectType getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractObjectType result = (ContractObjectType)ContractObjectType.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setEntityTitleMacros(rs.getString("name_macros")).setComment(rs.getString("comment")).setHidden(rs.getBoolean("ishidden")).build();
        PreparedStatement ps = this.getModuleIdsPS;
        if (ps == null) {
            ps = this.getModuleIdsPS = this.con.prepareStatement("SELECT mid FROM object_type_module WHERE type_id=?");
        }
        ps.setInt(1, result.getId());
        HashSet<Integer> moduleIds = new HashSet<Integer>();
        try (ResultSet getModuleIdsRS = ps.executeQuery();){
            while (getModuleIdsRS.next()) {
                moduleIds.add(getModuleIdsRS.getInt(1));
            }
        }
        result.setModuleIds(moduleIds);
        return result;
    }

    @Override
    protected void updateImpl(ContractObjectType contractObjectType) throws BGException, SQLException {
        Objects.requireNonNull(contractObjectType);
        boolean update = contractObjectType.getId() > 0;
        Object query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, name_macros=?, comment=?, ishidden=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement((String)query, 1);){
            int index = 1;
            ps.setString(index++, contractObjectType.getTitle());
            ps.setString(index++, contractObjectType.getEntityTitleMacros());
            ps.setString(index++, contractObjectType.getComment());
            ps.setBoolean(index++, contractObjectType.isHidden());
            if (update) {
                ps.setInt(index++, contractObjectType.getId());
            }
            ps.executeUpdate();
            if (!update) {
                contractObjectType.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        query = "DELETE FROM object_type_module WHERE type_id=?";
        ps = this.con.prepareStatement((String)query);
        try {
            ps.setInt(1, contractObjectType.getId());
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        query = "INSERT INTO object_type_module SET type_id=?, mid=?";
        ps = this.con.prepareStatement((String)query);
        try {
            ps.setInt(1, contractObjectType.getId());
            for (Integer moduleId : contractObjectType.getModuleIds()) {
                ps.setInt(1, moduleId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    @Override
    protected int deleteImpl(int id) throws BGException, SQLException {
        int result = super.deleteImpl(id);
        String query = "DELETE FROM object_type_module WHERE type_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        return result;
    }

    @Override
    public void close() throws BGException {
        super.close();
        try {
            if (this.getModuleIdsPS != null) {
                this.getModuleIdsPS.close();
                this.getModuleIdsPS = null;
            }
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    @Override
    public ContractObjectType get(String title) throws BGException {
        return (ContractObjectType)((Object)super.get("title=?", title));
    }

    @Override
    public List<ContractObjectType> list() throws BGException {
        return super.list(null, null, new Object[0]);
    }
}

