/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.customer.common.service.CustomerService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class BGEmailDialog
extends BGDialog {
    private BGTextArea writeEmail = new BGTextArea(3, 20);
    private BGUCheckList<IdTitle> emailCheckList = new BGUCheckList();
    private BGButtonPanelOkCancel okCancelPanel = new BGButtonPanelOkCancel();

    public BGEmailDialog() {
        this.jbInit();
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() {
        this.emailCheckList.setMinimumSize(new Dimension(500, 150));
        this.emailCheckList.setPreferredSize(new Dimension(500, 150));
        this.writeEmail.setFont(new Font("Dialog", 0, 12));
        this.writeEmail.setEmptyText("\u0414\u043b\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439\u0445 e-mail\n(\u043f\u043e \u043e\u0434\u043d\u043e\u043c\u0443 \u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0443).");
        BGButton pasteButton = new BGButton();
        pasteButton.setIcon(ClientUtils.getIcon("paste.png"));
        pasteButton.setToolTipText("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430");
        pasteButton.addActionListener(event -> {
            Transferable clipboardContents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (clipboardContents != null) {
                try {
                    Object data = clipboardContents.getTransferData(DataFlavor.stringFlavor);
                    if (data != null && data instanceof String) {
                        String txt = this.writeEmail.getText();
                        if (!txt.isEmpty() && !txt.endsWith("\n")) {
                            this.writeEmail.append("\n");
                        }
                        this.writeEmail.append(data.toString());
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        bottomPanel.add((Component)pasteButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        bottomPanel.add((Component)this.okCancelPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 15, 0, 0), 0, 0));
        this.okCancelPanel.addActionListener(e -> {
            if (e.getActionCommand() == BGButtonPanelOkCancel.OK.command) {
                String email;
                StringBuilder sb = new StringBuilder();
                sb.append(Utils.toString(this.emailCheckList.getSelected().stream().map(a -> a.getTitle()).toList(), ","));
                if (Utils.notBlankString(this.writeEmail.getText())) {
                    sb.append(",");
                    sb.append(this.writeEmail.getText().replaceAll("\n\r|\r|\n", ", "));
                }
                if (Utils.isBlankString(email = sb.toString().replaceAll("^[, ]*", ""))) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0438 \u043e\u0434\u0438\u043d e-mail!");
                    return;
                }
                this.firePropertyChange("selectEmail", "", email);
            }
            this.setVisible(false);
            this.dispose();
        });
        JScrollPane scrollPane = new JScrollPane(this.writeEmail);
        scrollPane.setMinimumSize(new Dimension(500, 60));
        scrollPane.setPreferredSize(new Dimension(500, 60));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(this.emailCheckList, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("\u0414\u0440\u0443\u0433\u043e\u0439 e-mail:"), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)bottomPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setModal(true);
        this.setTitle("\u0412\u044b\u0431\u043e\u0440 e-mail");
        this.setDefaultCloseOperation(2);
        this.setContentPane(panel);
    }

    public void setEmailList(List<String> emailList) {
        if (emailList != null && emailList.size() > 0) {
            ArrayList<IdTitle> data = new ArrayList<IdTitle>();
            for (String email : emailList) {
                data.add(new IdTitle(0, email));
            }
            this.emailCheckList.setData(data);
        }
    }

    public void loadEmailListFromContractParameter(int contractId, int parameterId) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            Map<Integer, EntityAttr> map = this.getContext().getPort(ContractService.class).contractParameterMapByType(contractId, EntitySpecAttrType.EMAIL.getCode()).getMap();
            map.forEach((a, b) -> {
                if (b != null && (parameterId < 1 || a == parameterId)) {
                    list.addAll(((EntityAttrEmail)b).getContactList().stream().map(c -> c.toString()).collect(Collectors.toList()));
                }
            });
            list.addAll(this.getContext().getPort(CustomerService.class).customerEmails(0, contractId));
            this.setEmailList(list);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }
}

