/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;

public class BGFlashButton
extends JButton
implements Runnable {
    private List<Icon> iconList;
    private long timeout;
    private Thread thread;
    private int animateIndex1;
    private int animateIndex2;

    public BGFlashButton(List<Icon> iconList, long timeout, boolean suspendedCreate) {
        this.iconList = iconList;
        this.timeout = timeout;
        if (suspendedCreate) {
            this.stopFlash();
        } else {
            this.startFlash();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int currFrame = this.animateIndex1;
        try {
            while (!Thread.interrupted()) {
                if (this.iconList != null && this.iconList.size() > this.animateIndex2) {
                    List<Icon> list = this.iconList;
                    synchronized (list) {
                        this.setIcon(this.iconList.get(currFrame));
                        if (++currFrame > this.animateIndex2) {
                            currFrame = this.animateIndex1;
                        }
                    }
                }
                Thread.sleep(this.timeout);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void startFlash() {
        this.startFlash(1, this.iconList.size() - 1);
    }

    public void startFlash(int index1, int index2) {
        this.animateIndex1 = index1;
        this.animateIndex2 = index2;
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stopFlash() {
        this.stopFlash(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopFlash(int index) {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
        if (this.iconList != null && this.iconList.size() > index) {
            List<Icon> list = this.iconList;
            synchronized (list) {
                this.setIcon(this.iconList.get(index));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconToIndex(int index, Icon icon, boolean setIcon) {
        List<Icon> list = this.iconList;
        synchronized (list) {
            this.iconList.set(index, icon);
            if (setIcon) {
                this.setIcon(icon);
            }
        }
    }
}

