/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.service;

import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentTypeItem;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService")
public class ChargeServiceImpl
extends AbstractService
implements ChargeService {
    @Override
    public Charge chargeGet(int chargeId) throws Exception {
        return (Charge)new ChargeDao(this.getConnection()).get(chargeId);
    }

    @Override
    public SearchResult<Charge> chargeList(int contractId, int type, Period period, int members) throws Exception {
        return new ChargeDao(this.getConnection()).getChargeList(contractId, type, period, members);
    }

    @Override
    public SearchResult<Charge> paybackList(int contractId, int paybackTypeId, Period period, int members) throws Exception {
        return new ChargeDao(this.getConnection()).getPaybackList(contractId, paybackTypeId, period, members);
    }

    @Override
    public int chargeDelete(int contractId, int chargeId) throws Exception {
        return this.chargeDelete(chargeId);
    }

    @Override
    public int chargeDelete(int chargeId) throws Exception {
        int result = 0;
        try (BalanceUtils bu = new BalanceUtils(this.getConnection());){
            ChargeDao chargeDao = new ChargeDao(this.getConnection());
            Charge charge = (Charge)chargeDao.get(chargeId);
            if (charge != null) {
                Calendar closedDate = null;
                closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeleteContractCharge", (int)this.moduleId, (int)this.userId);
                if (closedDate != null) {
                    ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)charge.getDate());
                }
                result = chargeDao.delete(chargeId);
                this.getConnection().commit();
                bu.updateBalance(charge.getDate(), charge.getContractId());
                this.context.publishAfterCommit(new ContractBalanceChangedEvent(charge.getContractId(), 4, charge.getSum().negate()));
            }
        }
        return result;
    }

    @Override
    public int chargeUpdate(Charge charge) throws Exception {
        int result = 0;
        try (BalanceUtils bu = new BalanceUtils(this.getConnection());){
            boolean allowClosedCharge;
            ChargeDao chargeDao = new ChargeDao(this.getConnection());
            if (charge.getId() < -1 || charge.getDate() == null || charge.getContractId() <= 0 || charge.getTypeId() <= 0) {
                throw new BGIllegalArgumentException();
            }
            if (this.getSetup().getInt("allow.future.charge", 0) == 0 && TimeUtils.dateBefore(new Date(), charge.getDate())) {
                throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b \u0440\u0430\u0441\u0445\u043e\u0434\u044b/\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u044b \u0441 \u0434\u0430\u0442\u043e\u0439 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0439");
            }
            Date oldDate = null;
            Charge oldCharge = null;
            if (charge.getId() > 0 && (oldCharge = (Charge)chargeDao.get(charge.getId())) != null) {
                if (charge.getContractId() != oldCharge.getContractId()) {
                    throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u043e");
                }
                oldDate = oldCharge.getDate();
            }
            Contract contract = Optional.ofNullable(this.getContract(charge.getContractId())).orElseThrow(() -> new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d"));
            boolean bl = allowClosedCharge = this.getSetup().getInt("allow.closed.charge", 0) == 1;
            if (!allowClosedCharge && !TimeUtils.dateInRange(charge.getDate(), contract.getDateFrom(), contract.getDateTo())) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u043e\u043c\u0435\u043d\u0442");
            }
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionUpdateContractCharge", (int)this.moduleId, (int)this.userId);
            if (closedDate != null) {
                ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)oldDate, (Date)charge.getDate());
            }
            boolean editMode = charge.getId() >= 0;
            charge.setUserId(this.userId);
            chargeDao.update(charge);
            result = charge.getId();
            this.getConnection().commit();
            bu.updateBalance(charge.getDate(), contract);
            if (oldDate != null && TimeUtils.monthsDelta(oldDate, charge.getDate()) != 0) {
                bu.updateBalance(oldDate, contract);
            }
            BigDecimal balanceChange = charge.getSum();
            if (oldCharge != null) {
                balanceChange = balanceChange.subtract(oldCharge.getSum());
            }
            this.context.publishAfterCommit(new ChargeEvent(this.userId, charge, editMode));
            this.context.publishAfterCommit(new ContractBalanceChangedEvent(contract.getId(), 4, balanceChange));
        }
        return result;
    }

    @Override
    public ChargeType chargeTypeGet(int chargeTypeId) throws Exception {
        return this.context.getDirectory(ChargeType.class, 0).get(chargeTypeId);
    }

    @Override
    public List<ChargeType> chargeTypeList(Integer editable, Integer type, Boolean isPayback) throws Exception {
        try (ChargeTypeDao chargeTypeDao = new ChargeTypeDao(this.getConnection());){
            List<ChargeType> list = chargeTypeDao.list(editable, type, isPayback);
            return list;
        }
    }

    @Override
    public PaymentTypeItem chargeTypeTree(int editable, boolean isPayback, boolean showEmptyRoot) throws Exception {
        try (ChargeTypeDao chargeTypeDao = new ChargeTypeDao(this.getConnection());){
            PaymentTypeItem paymentTypeItem = chargeTypeDao.getTree(editable, isPayback, showEmptyRoot);
            return paymentTypeItem;
        }
    }

    @Override
    public void chargeTypeMove(int chargeTypeId, List<Integer> idList) throws Exception {
        try (ChargeTypeDao chargeTypeDao = new ChargeTypeDao(this.getConnection());){
            chargeTypeDao.move(chargeTypeId, idList);
        }
    }

    @Override
    public int chargeTypeUpdate(ChargeType chargeType) throws Exception {
        this.context.getDirectory(ChargeType.class, 0).update(chargeType);
        return chargeType.getId();
    }

    @Override
    public int chargeTypeDelete(int chargeTypeId) throws Exception {
        return this.context.getDirectory(ChargeType.class, 0).delete(chargeTypeId);
    }
}

