/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.action;

import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.contract.object.action.base.ActionBase;
import java.time.LocalDateTime;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractNote;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractNoteDao;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ObjectDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;

public class ActionMoveObject
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        int objectId = this.getIntParameter("oid", -1);
        int cidTo = this.getIntParameter("cid_to", -1);
        if (this.cid <= 0 || cidTo <= 0 || objectId <= 0) {
            throw new BGIllegalArgumentException();
        }
        try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.con, this.userId);){
            ContractUtils cu = new ContractUtils(this.con);
            EventProcessor.getInstance().request(new ObjectMoveEvent(this.userId, this.cid, objectId, cidTo));
            ContractObject object = (ContractObject)contractObjectDao.get(objectId);
            object.setContractId(cidTo);
            new ObjectDao(this.con).moveObject(objectId, cidTo);
            String contractFrom = cu.getContractTitle(this.cid, true);
            String contractTo = cu.getContractTitle(this.cid, true);
            ContractNoteDao contractNoteDao = new ContractNoteDao(this.con);
            ContractNote contractNote = new ContractNote().setTitle("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u043e\u0431\u044a\u0435\u043a\u0442").setComment("\u041e\u0431\u044a\u0435\u043a\u0442 " + object.getTitle() + " \u043f\u0435\u0440\u0435\u043d\u0435\u0441\u0435\u043d \u0438\u0437 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + contractFrom + " \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + contractTo).setDateTime(LocalDateTime.now()).setContractId(this.cid);
            contractNoteDao.update((Object)contractNote);
            contractNote.setId(0);
            contractNote.setContractId(cidTo);
            contractNoteDao.update((Object)contractNote);
        }
    }
}

