/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.old;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class PrefixTariffTreeNode
extends DefaultTariffTreeNode {
    private List<String> prefixes = new ArrayList<String>();

    @Override
    public void processRequest(TariffRequest request) {
        if ("reset".equals(request.getRequestParam("action"))) {
            this.processForChilds(request);
            return;
        }
        String phone = (String)request.getRequestParam("phone");
        if (phone != null) {
            phone = phone.trim();
            int relevanceBefore = request.getRelevance();
            for (String pref : this.prefixes) {
                if (phone.startsWith(pref)) {
                    int relevance = pref.length();
                    if (relevance <= request.getRelevance()) continue;
                    request.setRelevance(relevance);
                    continue;
                }
                if (!pref.equals("*") || request.getRelevance() != 0) continue;
                request.setRelevance(0);
            }
            if (request.getRelevance() > relevanceBefore && this._childs != null) {
                this.processForChilds(request);
            }
        }
    }

    private void initPrefixes() {
        try {
            StringTokenizer st = new StringTokenizer(this._data, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                StringTokenizer dashSt = new StringTokenizer(token, "-");
                String start = dashSt.nextToken().trim();
                if (dashSt.hasMoreTokens()) {
                    int cnt;
                    long startInterval = Utils.parseLong((String)start, (long)0L);
                    long endInterval = Utils.parseLong((String)dashSt.nextToken().trim(), (long)0L);
                    for (cnt = 0; startInterval <= endInterval && cnt < 200; ++startInterval, ++cnt) {
                        this.prefixes.add(String.valueOf(startInterval));
                    }
                    if (cnt != 200) continue;
                    System.err.println("error load pref " + start + " - " + endInterval);
                    continue;
                }
                this.prefixes.add(start.trim());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this._data = null;
    }

    @Override
    public void init(String data, int deep, int nodeID) {
        super.init(data, deep, nodeID);
        this.initPrefixes();
    }
}

