/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.table;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.table.TableRowReorderable;

public class TableRowTransferHandler
extends TransferHandler {
    private final DataFlavor localObjectFlavor = new ActivationDataFlavor(Integer.class, "application/x-java-Integer;class=java.lang.Integer", "Integer Row Index");
    private JTable table = null;

    public TableRowTransferHandler(JTable table) {
        this.table = table;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        return new DataHandler((Object)this.table.getSelectedRow(), this.localObjectFlavor.getMimeType());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport info) {
        boolean b = info.getComponent() == this.table && info.isDrop() && info.isDataFlavorSupported(this.localObjectFlavor);
        this.table.setCursor(b ? DragSource.DefaultMoveDrop : DragSource.DefaultMoveNoDrop);
        return b;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport info) {
        JTable target = (JTable)info.getComponent();
        JTable.DropLocation dl = (JTable.DropLocation)info.getDropLocation();
        int index = dl.getRow();
        int max = this.table.getModel().getRowCount();
        if (index < 0 || index > max) {
            index = max;
        }
        target.setCursor(Cursor.getPredefinedCursor(0));
        try {
            Integer rowFrom = (Integer)info.getTransferable().getTransferData(this.localObjectFlavor);
            if (rowFrom != -1 && rowFrom != index) {
                ((TableRowReorderable)((Object)this.table.getModel())).reorder(rowFrom, index);
                if (index > rowFrom) {
                    --index;
                }
                target.getSelectionModel().addSelectionInterval(index, index);
                return true;
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c, Transferable t, int act) {
        if (act == 2 || act == 0) {
            this.table.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

