/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import bitel.billing.server.tariff.TariffModuleTree;
import bitel.billing.server.tariff.TariffTreesCache;
import bitel.billing.server.tariff.detail.TariffDetailKey;
import bitel.billing.server.tariff.detail.TariffDetailUtils;
import bitel.billing.server.tariff.detail.TariffDetailValue;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractStatusDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public abstract class MaxTrafficCalculator
extends TaskBase {
    protected Calendar startMonth;
    protected Calendar endMonth;
    private ParameterMap maxTraffics;
    private ContractManager contractManager;
    private Preferences moduleSetup;
    private String cids;
    private Map<Integer, TariffTreeSet> treeSetMap = new HashMap<Integer, TariffTreeSet>();

    @Override
    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c " + this.getModule() + ". \u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0431\u0441\u0447\u0435\u0442\u0430 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0440\u0430\u0444\u0438\u043a\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f " + this.moduleId + ". \u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + this.cids;
    }

    public static final String getModuleServicesWithoutMaxTraf(Connection con, int mid, Preferences moduleConfig) {
        StringBuilder result = new StringBuilder();
        ParameterMap maxTraffics = moduleConfig.sub("max.traffic.");
        List ignoreService = Utils.toList((String)moduleConfig.get("service.recalc.ignore"));
        for (Service service : ModuleCache.getInstance().getModuleServicesList(mid)) {
            int serviceId = service.getId();
            if (maxTraffics.get(String.valueOf(serviceId)) != null || ignoreService.contains(String.valueOf(service.getId()))) continue;
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(serviceId);
        }
        return result.toString();
    }

    public void setCids(String cids) {
        this.cids = cids;
    }

    @Override
    protected boolean initTask() {
        TariffTreesCache.getCache().clearCache();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.startMonth = (Calendar)this.getOperatingTime().clone();
            this.startMonth.add(11, -1);
            this.startMonth.set(5, 1);
            this.startMonth.set(11, 0);
            this.endMonth = (Calendar)this.startMonth.clone();
            this.endMonth.add(2, 1);
            this.endMonth.add(6, -1);
            this.moduleSetup = new ModuleSetup(con, this.moduleId);
            this.maxTraffics = this.moduleSetup.sub("max.traffic.");
            if (this.maxTraffics.entrySet().size() == 0) {
                this.getLogger().error("No max traffics defined!");
                return;
            }
            if (this.getLogger().isDebugEnabled()) {
                for (Map.Entry me : this.maxTraffics.entrySet()) {
                    this.getLogger().debug("{} => {}", me.getKey(), me.getValue());
                }
            }
            this.contractManager = new ContractManager(con);
            ServiceCostCache costCache = new ServiceCostCache();
            HashSet<Integer> affectedContracts = new HashSet<Integer>();
            StringBuilder maxSids = new StringBuilder(20);
            HashMap<TariffDetailKey, TariffDetailValue> tariffDetailMap = new HashMap<TariffDetailKey, TariffDetailValue>(1024);
            Set<Integer> tariffDetailRangeTakeAllSet = TariffDetailUtils.getCostTypeRangeTakeAllIdSet(this.moduleSetup);
            for (Map.Entry me : this.maxTraffics.entrySet()) {
                int maxService = Utils.parseInt((String)((String)me.getKey()), (int)0);
                String services = (String)me.getValue();
                if (maxSids.length() > 0) {
                    maxSids.append(",");
                }
                maxSids.append(maxService);
                this.getLogger().info("Processing service " + maxService);
                this.processService(con, maxService, services, costCache, affectedContracts, tariffDetailMap);
            }
            try (BalanceUtils bu = new BalanceUtils(con);){
                bu.setAccount(con, this.getLogger(), this.startMonth, costCache, maxSids.toString(), this.cids, null);
            }
            TariffDetailUtils.flushTariffDetail(this.getLogger(), this.getModule(), Setup.getSetup(), this.moduleSetup, con, this.moduleId, this.startMonth, this.endMonth, this.cids, 0L, tariffDetailMap, tariffDetailRangeTakeAllSet, 2);
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        finally {
            ServerUtils.closeConnection(con, conSlave);
        }
    }

    private void processService(Connection con, int maxService, String sids, ServiceCostCache costCache, Set<Integer> affectedCotracts, Map<TariffDetailKey, TariffDetailValue> tariffDetailMap) throws SQLException, BGException {
        Object andCidPart = "";
        if (Utils.notBlankString((String)this.cids)) {
            andCidPart = " AND cid IN (" + this.cids + ")";
        }
        String query = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        query = "SELECT cid, date1, date2 FROM contract_service WHERE sid=? AND (date1 IS NULL OR date1<=?) AND (date2 IS NULL OR date2>=?) " + (String)andCidPart;
        ps = con.prepareStatement(query);
        ps.setInt(1, maxService);
        ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.endMonth));
        ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)this.startMonth));
        rs = ps.executeQuery();
        Set<Integer> suspendedOrClosed = StatusCache.getInstance().getModuleSuspendStatusSet(this.moduleId);
        ContractStatusDao contractStatusDao = new ContractStatusDao(con);
        while (rs.next()) {
            int contractId = rs.getInt(1);
            List<Period> suspendPeriodList = contractStatusDao.getPeriodList(contractId, 0, suspendedOrClosed, this.startMonth.getTime(), this.endMonth.getTime());
            Calendar date1 = TimeUtils.convertDateToCalendar((Date)rs.getDate(2));
            Calendar date2 = TimeUtils.convertDateToCalendar((Date)rs.getDate(3));
            this.getLogger().debug("contractId: {}", (Object)contractId);
            TariffTreeSet treeSet = this.getTreeSet(contractId);
            for (TariffTreeSet.TariffSetEntry entry : treeSet.getEntries()) {
                int daysInMonth;
                int days;
                Period tariffPeriod = new Period();
                tariffPeriod.setDateFrom(entry.getDateFrom());
                tariffPeriod.setDateTo(entry.getDateTo());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Tariff period: {}", (Object)TimeUtils.formatPeriod((Date)tariffPeriod.getDateFrom(), (Date)tariffPeriod.getDateTo()));
                }
                if (tariffPeriod.getDateFrom() != null && TimeUtils.dateBefore((Calendar)this.endMonth, (Calendar)tariffPeriod.getDateFromCalendar())) continue;
                if (tariffPeriod.getDateFrom() != null && TimeUtils.dateBeforeOrEq((Calendar)tariffPeriod.getDateFromCalendar(), (Calendar)this.startMonth)) {
                    tariffPeriod.setDateFrom(null);
                }
                if (tariffPeriod.getDateTo() != null && TimeUtils.dateBefore((Calendar)this.endMonth, (Calendar)tariffPeriod.getDateToCalendar())) {
                    tariffPeriod.setDateTo(null);
                }
                if (tariffPeriod.getDateFrom() != null && date2 != null && TimeUtils.dateBefore((Calendar)date2, (Calendar)tariffPeriod.getDateFromCalendar())) {
                    this.getLogger().debug("Skipping service already stop");
                    continue;
                }
                if (tariffPeriod.getDateTo() != null && date1 != null && TimeUtils.dateBefore((Calendar)tariffPeriod.getDateToCalendar(), (Calendar)date1)) {
                    this.getLogger().debug("Skipping service not start");
                    continue;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Process period: " + TimeUtils.formatPeriod((Date)tariffPeriod.getDateFrom(), (Date)tariffPeriod.getDateTo()));
                }
                TariffModuleTree tree = entry.getTree();
                long amount = this.getMaxServiceAmount(contractId, tariffPeriod, sids);
                Calendar time = tariffPeriod.getDateToCalendar();
                if (time == null) {
                    time = this.endMonth;
                }
                this.getLogger().debug("Amount: {}", (Object)amount);
                this.initTree(tree, contractId, time, maxService, amount);
                TariffRequest req = new TariffRequest();
                req.setRequestParam("cid", contractId);
                req.setRequestParam("time", time);
                req.setRequestParam("sid", maxService);
                req.setRequestParam("amount", amount);
                req.setRequestParam("action", "calculate");
                if (date1 == null || TimeUtils.dateBefore((Calendar)date1, (Calendar)this.startMonth)) {
                    date1 = this.startMonth;
                }
                if (date2 == null || TimeUtils.dateBefore((Calendar)this.endMonth, (Calendar)date2)) {
                    date2 = this.endMonth;
                }
                if ((days = TimeUtils.daysDelta((Calendar)date1, (Calendar)date2) + 1) < (daysInMonth = this.startMonth.getActualMaximum(5))) {
                    req.setRequestParam("part", Float.valueOf((float)days / (float)daysInMonth));
                }
                req.setRequestParam("part_tariff", Float.valueOf(entry.getPartOnPeriod(this.startMonth, this.endMonth)));
                req.setRequestParam("part_tariff_suspended", Float.valueOf(entry.getPartOnPeriod(this.startMonth, this.endMonth, suspendPeriodList)));
                tree.processRequest(req);
                if (!req.wasAccepted()) continue;
                Float costAmount = (Float)req.getResponseParam("costAmount");
                Float cost = (Float)req.getResponseParam("cost");
                Long divisor = (Long)req.getResponseParam("divisor");
                double recordCost = -1.0;
                if (costAmount != null) {
                    recordCost = costAmount.floatValue();
                } else if (cost != null && divisor != null && divisor > 0L) {
                    recordCost = (float)amount * cost.floatValue() / (float)divisor.longValue();
                }
                if (recordCost >= 0.0) {
                    CostSum am = new CostSum(contractId, maxService, BigDecimal.valueOf(recordCost));
                    costCache.addAmount(am);
                }
                affectedCotracts.add(contractId);
                TariffDetailUtils.putTariffDetail(tariffDetailMap, req, contractId, maxService, recordCost, amount);
            }
        }
        ps.close();
    }

    protected void initTree(TariffModuleTree tree, int cid, Calendar time, int maxService, long amount) {
    }

    private TariffTreeSet getTreeSet(int cid) {
        TariffTreeSet result = this.treeSetMap.get(cid);
        if (result == null) {
            result = this.contractManager.getRealtimeTariffTreeSet(cid, this.startMonth.getTime(), this.getModule(), this.moduleId, true);
            this.treeSetMap.put(cid, result);
            TariffRequest request = new TariffRequest();
            request.setRequestParam("action", "reset");
            request.setRequestParam("cid", cid);
            for (TariffModuleTree tree : result.getTreeList()) {
                tree.processRequest(request);
            }
        }
        return result;
    }

    protected abstract String getModule();

    protected abstract long getMaxServiceAmount(int var1, Period var2, String var3);

    @Override
    public List<TaskParameter> taskParameters() {
        List<TaskParameter> taskParameters = super.taskParameters();
        taskParameters.add(new TaskParameter().setKey("mid").setTitle("module ID").setDefaultValue("-1"));
        return taskParameters;
    }
}

