/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.server.service;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.RangeMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.RangeMapItem;
import ru.bitel.bgbilling.kernel.base.phone.common.service.RangeMapService;
import ru.bitel.bgbilling.kernel.base.phone.server.bean.RangeMapDao;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.base.phone.common.service.RangeMapService")
public class RangeMapServiceImpl
extends AbstractService
implements RangeMapService {
    private RangeMapDao rangeMapDao;

    @PostConstruct
    protected void init() {
        this.rangeMapDao = new RangeMapDao(this.getConnection(), this.moduleId);
    }

    @Override
    public List<RangeMap> rangeMapList(String order) throws BGException {
        return this.rangeMapDao.list(order);
    }

    @Override
    public RangeMap rangeMapGet(int id) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        return (RangeMap)this.rangeMapDao.get(id);
    }

    @Override
    public void rangeMapUpdate(RangeMap rangeMap) throws BGException {
        this.tryCall(() -> this.rangeMapDao.update((Object)rangeMap));
    }

    @Override
    public void rangeMapDelete(int id) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        this.tryCall(() -> this.rangeMapDao.delete(id));
    }

    @Override
    public List<RangeMapItem> rangeMapItemList(int id, Date date) throws BGException {
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        return (List)this.tryReturn(() -> this.rangeMapDao.listItems(id, date));
    }

    @Override
    public int rangeMapItemUpdate(int rangeMapId, RangeMapItem item) throws BGException {
        if (rangeMapId <= 0 || Utils.isBlankString((String)item.getRangeFrom()) || Utils.isBlankString((String)item.getRangeTo())) {
            throw new BGIllegalArgumentException();
        }
        return (Integer)this.tryReturn(() -> {
            this.rangeMapDao.updateItem(rangeMapId, item);
            return item.getId();
        });
    }

    @Override
    public void rangeMapItemDelete(int rangeMapId, int id) throws BGException {
        if (rangeMapId <= 0 || id <= 0) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
        }
        this.rangeMapDao.deleteItem(rangeMapId, id);
    }

    @Override
    public void rangeMapImport(int rangeMapId, boolean update, String prefix, String data) throws BGException {
        if (rangeMapId <= 0 || Utils.isBlankString((String)data)) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
        }
        try (RangeMapDao rangeMapDao = new RangeMapDao(this.getConnection(), this.moduleId);){
            rangeMapDao.importMap(rangeMapId, data, prefix, update);
        }
    }

    @Override
    public void rangeMapExport(int rangeMapId, String code, @XmlMimeType(value="application/octet-stream") Holder<DataHandler> data) throws BGException {
        if (rangeMapId <= 0) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430!");
        }
        this.tryCall(() -> {
            try (RangeMapDao rangeMapDao = new RangeMapDao(this.getConnection(), this.moduleId);){
                final byte[] result = rangeMapDao.exportMap(rangeMapId).getBytes("cp1251");
                data.value = new DataHandler(new DataSource(){

                    public String getContentType() {
                        return "text/csv";
                    }

                    public InputStream getInputStream() throws IOException {
                        return new ByteArrayInputStream(result);
                    }

                    public String getName() {
                        return "ranges";
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return null;
                    }
                });
            }
        });
    }
}

