/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.table.server.table;

import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowValue;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TableContractObjectStatus
extends BGTableInfoBase {
    public TableContractObjectStatus() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnPeriod(), BGUTableColumn.buildColumnTextCenter("\u0421\u0442\u0430\u0442\u0443\u0441", "status"), BGUTableColumn.buildColumnComment(), BGUTableColumn.buildColumnId().setWidth(90)};
    }

    @Override
    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        int objectId = Utils.parseInt((String)tableParams.get("objectId"));
        SearchResult<ContractStatus> searchResult = this.getContext().newService(ContractStatusService.class, 0).contractStatusSearch(tableParams.getContractId(), objectId, tableParams.getPage());
        List<Status> statusList = StatusCache.getInstance().getStatusList();
        this.page = searchResult.getPage();
        ArrayList<BGUTableRowData> rowDatas = new ArrayList<BGUTableRowData>();
        for (ContractStatus contractStatus : searchResult.getList()) {
            BGUTableRowData rowData = new BGUTableRowData().addValue(this.getId(contractStatus.getId())).addValue(this.getComment(contractStatus.getComment())).addValue(this.getPeriod(new Period(contractStatus.getDateFrom(), contractStatus.getDateTo()))).addValue(new BGUTableRowValue("status", statusList.stream().filter(a -> a.getId() == contractStatus.getStatus()).map(a -> a.getGuiTitle() + (contractStatus.getObjectId() == 0 ? " [\u0434\u043e\u0433.]" : "")).findFirst().orElse("??? [#" + contractStatus.getStatus() + "]")));
            rowDatas.add(rowData);
        }
        return rowDatas;
    }
}

