/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.job.server;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.WorkerTask;
import ru.bitel.oss.kernel.job.server.JobCalendar;
import ru.bitel.oss.kernel.job.server.JobContext;
import ru.bitel.oss.kernel.job.server.JobRuntime;
import ru.bitel.oss.kernel.job.server.JobScheduler;
import ru.bitel.oss.kernel.job.server.JobStore;

public class JobTriggerRuntime
extends WorkerTask<JobContext> {
    protected final ReentrantLock lock = new ReentrantLock();
    protected final JobScheduler jobScheduler;
    protected final JobStore jobStore;
    public final JobRuntime jobRuntime;
    public final long id;
    private long timeFromMillis;
    private long timeToMillis;
    private boolean persistent;
    private long fireTimePrevMillis;
    private long fireTimeNextMillis;
    private long fireCount;
    private JobTriggerTimer triggerTimer;
    private long futureTime;
    private ScheduledFuture<?> future;

    JobTriggerRuntime(JobScheduler jobScheduler, JobStore jobStore, long id, JobRuntime jobRuntime) {
        this.jobScheduler = jobScheduler;
        this.jobStore = jobStore;
        this.id = id;
        this.jobRuntime = jobRuntime;
    }

    public long getFireTimeNextMillis() {
        return this.fireTimeNextMillis;
    }

    public void run() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            super.run();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTrigger(long timeFromMillis, long timeToMillis, boolean persistent, int type, String data, long fireTimePrevMillis, long fireTimeNextMillis, long fireCount, long version) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.timeFromMillis = timeFromMillis;
            this.timeToMillis = timeToMillis;
            this.persistent = persistent;
            this.fireTimePrevMillis = fireTimePrevMillis;
            this.fireTimeNextMillis = fireTimeNextMillis;
            this.fireCount = fireCount;
            switch (type) {
                case 1: {
                    this.triggerTimer = new CalendarJobTriggerTimer(this, data);
                    break;
                }
                default: {
                    this.triggerTimer = new SimpleJobTriggerTimer(data);
                }
            }
            this.schedule();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTrigger(long fireTimePrevMillis, long fireTimeNextMillis, long fireCount, long version) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.fireTimePrevMillis = fireTimePrevMillis;
            this.fireTimeNextMillis = fireTimeNextMillis;
            this.fireCount = fireCount;
        }
        finally {
            lock.unlock();
        }
    }

    public long fire(long millis) throws Exception {
        this.getLogger().debug("Fire");
        ((JobContext)this.context).jobTriggerTime = new Date(this.fireTimeNextMillis);
        ((JobContext)this.context).jobParamsString = this.jobRuntime.getParamsString();
        ((JobContext)this.context).jobParams = this.jobRuntime.getParams();
        try {
            this.jobRuntime.call();
        }
        finally {
            ((JobContext)this.context).jobTriggerTime = null;
            ((JobContext)this.context).jobParamsString = null;
            ((JobContext)this.context).jobParams = null;
        }
        if (this.persistent) {
            return this.triggerTimer.next(this.fireTimeNextMillis, this.fireCount + 1L);
        }
        return this.triggerTimer.next(System.currentTimeMillis(), this.fireCount + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        this.lock.lock();
        try {
            long fireTimeNextMillis;
            long startMillis;
            if (this.triggerTimer == null) {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.fireTimeNextMillis = 0L;
            }
            long l = startMillis = this.persistent ? this.fireTimePrevMillis : System.currentTimeMillis();
            if (startMillis < this.timeFromMillis) {
                startMillis = this.timeFromMillis;
            }
            if ((fireTimeNextMillis = this.triggerTimer.next(startMillis, this.fireCount)) > 0L) {
                if (this.futureTime == fireTimeNextMillis && this.future != null && this.future.getDelay(TimeUnit.MILLISECONDS) / 50L == (this.fireTimeNextMillis - System.currentTimeMillis()) / 50L) {
                    return;
                }
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.futureTime = this.fireTimeNextMillis = fireTimeNextMillis;
                this.future = this.jobScheduler.schedule((Runnable)((Object)this), Math.max(0L, this.fireTimeNextMillis - System.currentTimeMillis()));
            } else {
                if (this.future != null) {
                    this.future.cancel(false);
                }
                this.fireTimeNextMillis = 0L;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void runImpl() throws Exception {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            long millis = System.currentTimeMillis();
            long count = this.triggerTimer instanceof SimpleJobTriggerTimer ? ((SimpleJobTriggerTimer)this.triggerTimer).count : 0L;
            long next = this.jobStore.fire((ServerContext)this.context, this, millis, count);
            if (next != -1L) {
                this.fireTimePrevMillis = millis;
                this.fireTimeNextMillis = next;
                ++this.fireCount;
            }
            if (this.fireTimeNextMillis > 0L) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Schedule to " + (this.fireTimeNextMillis - System.currentTimeMillis()) + "ms");
                }
                this.futureTime = this.fireTimeNextMillis;
                this.future = this.jobScheduler.schedule((Runnable)((Object)this), Math.max(0L, this.fireTimeNextMillis - System.currentTimeMillis()));
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            lock.unlock();
        }
    }

    public void cancel() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.triggerTimer = null;
            if (this.future != null) {
                this.future.cancel(false);
            }
            this.fireTimeNextMillis = 0L;
        }
        finally {
            lock.unlock();
        }
    }

    class CalendarJobTriggerTimer
    extends JobCalendar
    implements JobTriggerTimer {
        CalendarJobTriggerTimer(JobTriggerRuntime this$0, String data) {
            Preferences params = new Preferences(data, "\n");
            this.setYear(params.get("year", "*"));
            this.setMonth(params.get("month", "*"));
            this.setDayOfMonth(params.get("dayOfMonth", "*"));
            this.setDayOfWeek(params.get("dayOfWeek", "*"));
            this.setHour(params.get("hour", "*"));
            this.setMinute(params.get("minute", "*"));
            this.setSecond(params.get("second", "*"));
        }

        @Override
        public long next(long millis, long fireCount) {
            Calendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(millis);
            calendar = this.next(calendar);
            return calendar != null ? calendar.getTimeInMillis() : 0L;
        }
    }

    static interface JobTriggerTimer {
        public long next(long var1, long var3);
    }

    class SimpleJobTriggerTimer
    implements JobTriggerTimer {
        private long periodMillis;
        private long count;

        SimpleJobTriggerTimer(String data) {
            if (Utils.notBlankString((String)data)) {
                Preferences params = new Preferences(data, "\n");
                this.periodMillis = params.getLong("periodMillis", 0L);
                this.count = params.getLong("count", 0L);
            } else {
                this.periodMillis = 0L;
                this.count = 1L;
            }
        }

        @Override
        public long next(long millis, long fireCount) {
            long startMillis;
            if (fireCount >= this.count) {
                return 0L;
            }
            long l = startMillis = JobTriggerRuntime.this.persistent ? JobTriggerRuntime.this.fireTimeNextMillis : millis;
            if (startMillis < JobTriggerRuntime.this.timeFromMillis) {
                startMillis = JobTriggerRuntime.this.timeFromMillis;
            }
            long result = startMillis + this.periodMillis;
            if (JobTriggerRuntime.this.timeToMillis != 0L && result > JobTriggerRuntime.this.timeToMillis) {
                return 0L;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeInMillis(result);
            return calendar.getTimeInMillis();
        }
    }
}

