/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.KeyStroke;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.table.BGTableModel;

public abstract class BGUPanel
extends AbstractBGUPanel<ClientContext, BGUPanel> {
    public BGUPanel() {
    }

    public BGUPanel(ClientContext context) {
        super(context);
    }

    public BGUPanel(LayoutManager layout, ClientContext context) {
        super(layout, context);
    }

    public BGUPanel(LayoutManager layout) {
        super(layout);
    }

    @Override
    protected final void init() {
        super.init();
    }

    @Override
    public final void build() {
        super.build();
    }

    @Override
    protected final void beforeAsyncJbInit(ClientContext initContext) {
        ClientContext.push(initContext);
    }

    @Override
    protected final void afterAsyncJbInit() {
        ClientContext.pop();
    }

    @Override
    protected final ClientContext innerGetContext(Container parent) {
        if (parent instanceof BGPanel) {
            return ((BGPanel)parent).getContext();
        }
        if (parent instanceof BGDialog) {
            return ((BGDialog)parent).getContext();
        }
        if (parent == null) {
            return ClientContext.get();
        }
        return null;
    }

    @Override
    protected void initAction(AbstractBGUPanel.DefaultAction result, String command, KeyStroke stroke) {
        if ("new".equals(command)) {
            result.putValue("SmallIcon", ClientUtils.getIcon("item_add"));
        } else if ("edit".equals(command)) {
            result.putValue("SmallIcon", ClientUtils.getIcon("item_edit"));
        } else if ("delete".equals(command)) {
            result.putValue("SmallIcon", ClientUtils.getIcon("item_delete"));
        } else if ("move_up".equals(command)) {
            result.putValue("SmallIcon", ClientUtils.getIcon("item_up"));
        } else if ("move_down".equals(command)) {
            result.putValue("SmallIcon", ClientUtils.getIcon("item_down"));
        }
    }

    public void setParameter(Object parameter) {
    }

    protected String getUserEmail(String key) {
        List<String> email = ClientSetup.getInstance().getUserEmail(key);
        return Utils.toString(email, ",");
    }

    protected ItemListener comboBoxSelect(Consumer<ItemEvent> consumer) {
        return e -> {
            if (e.getStateChange() == 1) {
                consumer.accept(e);
            }
        };
    }

    protected void saveUserEmail(String key, String email) {
        ClientSetup.getInstance().saveUserEmail(key, Utils.toList(email));
    }

    protected <T, K extends BGEditorDialog<T>> void showEditDialog(BGTableModel<T> tableModel, Class<K> dialogClass, String dialogTitle) {
        this.showEditDialog((T)tableModel, dialogClass, new ShowEditDialogParams().setDialogTitle(dialogTitle));
    }

    protected <T, K extends BGEditorDialog<T>> void showEditDialog(T a, Class<K> dialogClass, String dialogTitle) {
        this.showEditDialog(a, dialogClass, new ShowEditDialogParams().setDialogTitle(dialogTitle));
    }

    protected <T, K extends BGEditorDialog<T>> void showEditDialog(BGTableModel<T> tableModel, Class<K> dialogClass, ShowEditDialogParams params) {
        tableModel.optSelectedRow().ifPresentOrElse(a -> this.showEditDialog(a, dialogClass, params), () -> ClientUtils.showErrorMessageDialog(params.getErrorMessage()));
    }

    protected <T, K extends BGEditorDialog<T>> void showEditDialog(T a, Class<K> dialogClass, ShowEditDialogParams params) {
        this.tryCall(() -> ((BGEditorDialog)dialogClass.getConstructor(this.getClass(), String.class, a.getClass()).newInstance(this, params.getDialogTitle(), a)).open());
    }

    protected static class ShowEditDialogParams {
        private String dialogTitle = "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440";
        private String errorMessage = "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f";

        protected ShowEditDialogParams() {
        }

        public String getDialogTitle() {
            return this.dialogTitle;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public ShowEditDialogParams setDialogTitle(String dialogTitle) {
            this.dialogTitle = dialogTitle;
            return this;
        }
    }

    protected class WebServiceHolder<T> {
        private T t;
        private Class<?> clazz;
        private int moduleId = -1;

        public WebServiceHolder(Class<?> clazz) {
            this.clazz = clazz;
        }

        public WebServiceHolder(Class<?> clazz, int moduleId) {
            this.clazz = clazz;
            this.moduleId = moduleId;
        }

        public T get() {
            if (this.t == null) {
                this.t = ((ClientContext)BGUPanel.this.getContext()).getWebService(this.clazz, this.moduleId > -1 ? this.moduleId : ((ClientContext)BGUPanel.this.getContext()).getModuleId());
            }
            return this.t;
        }
    }
}

