/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.client;

import bitel.billing.module.common.ActualDateFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.modules.megogo.client.MegogoContractPanel;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractCredentials;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubscription;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;

public class MegogoContractSubscriptionPanel
extends MegogoContractPanel {
    private int contractId;
    private ActualDateFilter date = new ActualDateFilter((BGUPanel)this);
    private MegogoContractSubscriptionTableModel model;
    private BGUTable table = new BGUTable((TableModel)((Object)this.model));
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGUList<Service> subscriptionList = new BGUList();
    private BGTextField commentField = new BGTextField();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private JCheckBox sendToMegogo = new JCheckBox("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0441\u0440\u0430\u0437\u0443");
    private MegogoContractCredentials credentials = null;
    private JTextField loginLabel = new JTextField();
    private BGButton createCredentialsButton = new BGButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");

    @Override
    protected void jbInit() {
        this.model = new MegogoContractSubscriptionTableModel(MegogoContractSubscriptionTableModel.class.getName());
        this.contractId = ((ClientContext)this.getContext()).getContractId();
        this.editor.setVisible(false);
        this.table.setModel((TableModel)((Object)this.model));
        this.date.updateDate();
        this.sendToMegogo.setToolTipText("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0441\u0440\u0430\u0437\u0443 \u0432 Megogo, \u043d\u0435 \u0434\u043e\u0436\u0438\u0434\u0430\u044f\u0441\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u0434\u0430\u0447\u0438 \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a\u0430");
        this.subscriptionList.setSelectionMode(0);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.period, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.commentField, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.sendToMegogo, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        JPanel serviceListPanel = new JPanel(new GridBagLayout());
        serviceListPanel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        serviceListPanel.add((Component)new JScrollPane((Component)this.subscriptionList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        JPanel editorPanel = new JPanel(new GridBagLayout());
        editorPanel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
        editorPanel.add((Component)leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        editorPanel.add((Component)serviceListPanel, new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGSwingUtilites.handleLDMouseClicked((Component)this.table, e -> this.startEdit(false));
        this.period.addPropertyChangeListener(e -> {
            if (TimeUtils.dateBeforeOrEq((Date)this.period.getDateFrom(), (Date)this.period.getDateTo()) || this.period.getDateTo() == null) {
                MegogoContractSubscription contractSub = (MegogoContractSubscription)this.model.getSelectedRow();
                if (contractSub == null && this.period.getDateTo() != null || contractSub != null && !TimeUtils.dateEqual((Date)this.period.getDateTo(), (Date)new Date())) {
                    this.sendToMegogo.setEnabled(false);
                    return;
                }
                if (TimeUtils.dateBeforeOrEq((Date)this.period.getDateTo(), (Date)new Date()) && contractSub != null && contractSub.getDateActivated() != null || TimeUtils.dateBeforeOrEq((Date)this.period.getDateFrom(), (Date)new Date()) && (contractSub == null || contractSub.getDateActivated() == null)) {
                    this.sendToMegogo.setEnabled(true);
                    return;
                }
            }
            this.sendToMegogo.setEnabled(false);
        });
        this.createCredentialsButton.addActionListener(e -> {
            try {
                this.getMegogoService().requestCredentials(this.contractId, null, null);
                this.performAction("refresh", "refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        this.loginLabel.setEditable(false);
        this.loginLabel.setBorder(null);
        this.loginLabel.setBackground(null);
        this.editor.add((Component)editorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.date, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.loginLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.add((Component)this.createCredentialsButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.editor, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    private void startEdit(boolean newService) {
        MegogoContractSubscription contractSub = null;
        if (!newService) {
            contractSub = (MegogoContractSubscription)this.model.getSelectedRow();
        } else {
            this.model.setSelectedRow(-1);
        }
        if (!newService && contractSub == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        if (this.subscriptionList.getModel().getSize() == 0) {
            try {
                ArrayList<Service> serList = new ArrayList<Service>();
                for (Service service : this.getServiceDirectory().list()) {
                    if (!service.isUsing() || service.getModuleId() != ((ClientContext)this.getContext()).getModuleId()) continue;
                    serList.add(service);
                }
                this.subscriptionList.setData(serList);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
        }
        this.period.setPeriod(null);
        this.sendToMegogo.setSelected(false);
        this.subscriptionList.setSelectedIndex(-1);
        if (contractSub != null) {
            try {
                this.period.setPeriod(contractSub.getPeriod());
                this.commentField.setText(contractSub.getComment());
                this.subscriptionList.setSelectedValue((Object)this.getServiceDirectory().get(contractSub.getServiceId()), true);
                this.subscriptionList.setEnabled(false);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
        } else {
            this.period.setLocalDateFrom(LocalDate.now());
            this.commentField.setText("");
            this.subscriptionList.setSelectedValue(null, false);
            this.subscriptionList.setEnabled(true);
        }
        this.table.setEnabled(false);
        this.editor.setVisible(true);
        this.period.firePropertyChange("date1", false, true);
    }

    private void stopEdit(boolean save) {
        if (save) {
            Service service;
            MegogoContractSubscription megogoContractSubscription = (MegogoContractSubscription)this.model.getSelectedRow();
            if (megogoContractSubscription == null) {
                megogoContractSubscription = new MegogoContractSubscription();
            }
            if ((service = (Service)this.subscriptionList.getSelectedValue()) == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0443\u0441\u043b\u0443\u0433\u0443!");
                return;
            }
            if (this.period.getDateFrom() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                return;
            }
            if (this.period.getDateTo() != null && TimeUtils.dateBefore((Date)this.period.getDateTo(), (Date)this.period.getDateFrom())) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u044c\u0448\u0435 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430!");
                return;
            }
            megogoContractSubscription.setCount(1);
            megogoContractSubscription.setPeriod(this.period.getPeriod());
            megogoContractSubscription.setContractId(this.contractId);
            megogoContractSubscription.setComment(this.commentField.getText());
            megogoContractSubscription.setServiceId(service.getId());
            try {
                this.getMegogoService().updateContractSubscription(megogoContractSubscription, this.sendToMegogo.isSelected() && this.sendToMegogo.isEnabled());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
                return;
            }
            this.performAction("refresh");
        }
        this.table.setEnabled(true);
        this.editor.setVisible(false);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (e.getActionCommand() == "refresh") {
                this.resetServiceDirectory();
                this.resetUserDirectory();
                this.credentials = this.getMegogoService().getContractCredentials(this.contractId);
                if (this.credentials != null) {
                    this.loginLabel.setText("\u041b\u043e\u0433\u0438\u043d: " + this.credentials.getLogin() + "  \u041f\u0430\u0440\u043e\u043b\u044c: " + this.credentials.getPwd() + "  uid: " + this.credentials.getUid());
                    this.createCredentialsButton.setText("\u041f\u0435\u0440\u0435\u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
                } else {
                    this.loginLabel.setText("\u0423\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0442!");
                    this.createCredentialsButton.setText("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435");
                }
            }
            this.model.setData(this.getMegogoService().contractSubscriptionList(this.contractId, -1, this.date.getDate()));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> this.startEdit(true));
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.startEdit(false));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            MegogoContractSubscription contractService = (MegogoContractSubscription)this.model.getSelectedRow();
            if (contractService == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443!");
                return;
            }
            if (ClientUtils.confirm((String)("\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0443: " + String.valueOf(this.getServiceDirectory().get(contractService.getServiceId())) + " " + String.valueOf(contractService.getPeriod())), (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435")) {
                this.getMegogoService().deleteContractSubscription(contractService.getId());
                this.model.setData(this.getMegogoService().contractSubscriptionList(this.contractId, -1, this.date.getDate()));
            }
        });
    }

    class MegogoContractSubscriptionTableModel
    extends BGTableModel<MegogoContractSubscription> {
        public MegogoContractSubscriptionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", -1, 250, 600, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 150, 150, 150, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", true);
            this.addColumn("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", -1, 150, 200, "dateActivated", true);
            this.addColumn("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", -1, 150, 200, "dateDeactivated", true);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 150, 200, 250, "user", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(MegogoContractSubscription val, int column) throws Exception {
            switch (column) {
                case 1: {
                    return MegogoContractSubscriptionPanel.this.getServiceDirectory().get(val.getServiceId()) == null ? "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ((Service)MegogoContractSubscriptionPanel.this.getServiceDirectory().get(val.getServiceId())).getTitle();
                }
                case 2: {
                    return val.getStatusText();
                }
                case 6: {
                    return MegogoContractSubscriptionPanel.this.getUserDirectory().get(val.getUserId()) == null ? "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ((UserInfo)MegogoContractSubscriptionPanel.this.getUserDirectory().get(val.getUserId())).getName();
                }
            }
            return super.getValue((Object)val, column);
        }
    }
}

