/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.task;

import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.function.Function;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccountDetail;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.CalculateEvent;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTree;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskParameter;
import ru.bitel.bgbilling.modules.npay.common.bean.ServiceObject;
import ru.bitel.bgbilling.modules.npay.server.bean.NpayDetailDao;
import ru.bitel.bgbilling.modules.npay.server.bean.account.ModuleAccount;
import ru.bitel.bgbilling.modules.npay.server.bean.amount.ModuleAmount;
import ru.bitel.bgbilling.modules.npay.server.bean.quantity.ModuleQuantity;
import ru.bitel.bgbilling.modules.npay.server.bean.sets.ServiceSetManager;
import ru.bitel.bgbilling.modules.npay.server.calculate.AddCostItem;
import ru.bitel.bgbilling.modules.npay.server.calculate.AmountDetail;
import ru.bitel.bgbilling.modules.npay.server.calculate.AmountDetailCache;
import ru.bitel.bgbilling.modules.npay.server.calculate.ServiceConfigCache;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class Calculator
extends TaskBase {
    private Calendar startMonth;
    private Calendar endMonth;
    private int daysInMonth;
    private NPayTariffContext context;
    private List<Integer> contractIds;
    private List<Integer> contractLabelIds;
    private boolean preCalcMode;
    private int preCalcStatus;
    private Calendar activeFromDate;
    private List<ServiceObject> serviceObjectList;
    private List<ContractTariff> tariffList;
    private boolean tariffOptionEnable = true;
    private boolean calcErrors = false;
    private Map<Integer, ModuleAmount> moduleAmountMap = null;
    private Map<Integer, ModuleAccount> moduleAccountMap = null;
    private Map<Integer, ModuleQuantity> moduleQuantityMap = null;
    private ServiceCostCache costCache = new ServiceCostCache();
    private AmountDetailCache amountDetailCache = new AmountDetailCache();
    private AddCostDetail addCostDetail = new AddCostDetail();
    private ServiceConfigCache configCache = new ServiceConfigCache();
    private PeriodicErrorManager errorManager;
    private ConnectionSet connectionSet;
    private Connection con;
    private Connection conSlave;
    private Map<Integer, SoftReference<Map<Integer, Map<Integer, TariffModuleTreeSet>>>> treeSetMap = new HashMap<Integer, SoftReference<Map<Integer, Map<Integer, TariffModuleTreeSet>>>>(1024);

    public Calculator setContractIds(List<Integer> contractIds) {
        this.contractIds = contractIds;
        return this;
    }

    public Calculator setContractLabelIds(List<Integer> contractLabelIds) {
        this.contractLabelIds = contractLabelIds;
        return this;
    }

    @Deprecated
    public void setPreCalc() {
        this.setPreCalc(0);
    }

    public void setPreCalc(int status) {
        this.preCalcMode = true;
        this.preCalcStatus = status;
        if (this.activeFromDate == null && this.getOperatingTime() != null) {
            this.activeFromDate = this.getOperatingTime();
        }
    }

    public void setActiveFromDate(Calendar value) {
        this.activeFromDate = value;
    }

    public void setServiceObjectList(List<ServiceObject> serviceObjectList) {
        this.serviceObjectList = serviceObjectList;
    }

    public void setTariffList(List<ContractTariff> tariffList) {
        this.tariffList = tariffList;
    }

    public void setTariffOptionEnable(boolean tariffOptionEnable) {
        this.tariffOptionEnable = tariffOptionEnable;
    }

    public ServiceCostCache getCostCache() {
        return this.costCache;
    }

    public ServiceConfigCache getConfigCache() {
        return this.configCache;
    }

    public boolean isCalcErrors() {
        return this.calcErrors;
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Npay. \u0417\u0430\u0434\u0430\u0447\u0430 \u043e\u0431\u0441\u0447\u0435\u0442\u0430 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". " + this.contractModeDescription();
    }

    private String contractModeDescription() {
        if (Utils.notEmptyCollection(this.contractIds)) {
            return "\u041a\u043e\u0434\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + Utils.toString(this.contractIds);
        }
        if (Utils.notEmptyCollection(this.contractLabelIds)) {
            return "\u041a\u043e\u0434\u044b \u043c\u0435\u0442\u043e\u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432: " + Utils.toString(this.contractLabelIds);
        }
        return "\u0412\u0441\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u044b";
    }

    protected boolean initTask() {
        if (this.moduleId <= 0) {
            this.getLogger().error("Param mid NOT found in task config");
            String key = "npay.calculator.mid.empty";
            String message = "mid \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0437\u0430\u0434\u0430\u0447\u0438 id=>" + this.taskId;
            AlarmSender.sendAlarm((String)key, (long)30000L, (String)"mid \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", (String)message);
            return false;
        }
        return true;
    }

    private Set<Integer> getContractModuleIds(int contractId) throws Exception {
        return ContractRuntimeMap.getInstance().getContractRuntime(this.connectionSet, Integer.valueOf(contractId)).getModuleIds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeTask() {
        threadContext = (ServerContext)ThreadContext.get();
        this.connectionSet = threadContext != null ? threadContext.getConnectionSet() : ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
        this.con = this.connectionSet.getConnection();
        this.conSlave = this.connectionSet.getSlaveConnection();
        serviceIds = null;
        try {
            balanceUtils = new BalanceUtils(this.con);
            tariffModuleTreeSetDao = new TariffModuleTreeSetDao(this.con);
            minusHour = this.taskSetup.getBoolean("hour.minus", true);
            if (!this.preCalcMode && minusHour) {
                this.getOperatingTime().add(11, -1);
            }
            this.startMonth = TimeUtils.getStartMonth((Calendar)this.getOperatingTime());
            this.startMonth = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)this.startMonth);
            this.endMonth = TimeUtils.getEndMonth((Calendar)this.getOperatingTime());
            this.daysInMonth = this.startMonth.getActualMaximum(5);
            sidSetId = this.taskSetup.getInt("service.set", 0);
            moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            setManager = new ServiceSetManager(this.con, this.moduleId, (Preferences)moduleSetup);
            set = setManager.getServiceSetMap().get(sidSetId);
            if (set == null) {
                this.getLogger().error("Not found service set with id=" + sidSetId);
                key = "npay.calculator.service.empty";
                message = "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 service.set \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0437\u0430\u0434\u0430\u0447\u0438 id=>" + this.taskId;
                AlarmSender.sendAlarm((String)key, (long)30000L, (String)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 service.set \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", (String)message);
            }
            ** GOTO lbl80
            tariffModuleTreeSetDao.close();
            balanceUtils.close();
            ** GOTO lbl67
        }
        catch (Exception e) {
            block96: {
                try {
                    this.calcErrors = true;
                    if (!this.preCalcMode && this.errorManager != null && !this.errorManager.isCapReached()) {
                        subject = e.getMessage();
                        text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (" + this.contractModeDescription() + ")\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438: " + String.valueOf(serviceIds);
                        this.errorManager.addErrorToList(subject, text, e);
                    }
                    this.getLogger().error("error calculate", (Throwable)e);
                    if (this.preCalcMode) ** GOTO lbl228
                    try {
                        EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(2, this.moduleId, 0, this.startMonth.getTime(), this.endMonth.getTime(), serviceIds, this.contractIds, this.taskSetup.get("comment", null)));
                    }
                    catch (BGException ex) {
                        this.getLogger().error("error request CalculateEvent(TYPE_ERROR)", (Throwable)ex);
                    }
                }
                catch (Throwable var33_58) {
                    try {
                        if (this.preCalcMode != false) throw var33_58;
                        if (this.errorManager == null) throw var33_58;
                        if (Utils.isEmptyCollection(this.contractIds) && Utils.isEmptyCollection(this.contractLabelIds)) {
                            this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                        }
                        this.errorManager.processErrors();
                        throw var33_58;
                    }
                    catch (Exception var34_59) {
                        throw var33_58;
                    }
                    finally {
                        if (threadContext == null) {
                            this.connectionSet.close();
                        }
                    }
                }
lbl67:
                // 1 sources

                try {
                    if (this.preCalcMode != false) return;
                    if (this.errorManager == null) return;
                    if (Utils.isEmptyCollection(this.contractIds) && Utils.isEmptyCollection(this.contractLabelIds)) {
                        this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                    }
                    this.errorManager.processErrors();
                    return;
                }
                catch (Exception var12_25) {
                    return;
                }
                finally {
                    if (threadContext == null) {
                        this.connectionSet.close();
                    }
                }
lbl80:
                // 1 sources

                ** try [egrp 7[TRYBLOCK] [13 : 393->1944)] { 
lbl81:
                // 1 sources

                serviceIds = set.getServiceIds();
                if (!this.preCalcMode) {
                    EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(0, this.moduleId, 0, this.startMonth.getTime(), this.endMonth.getTime(), serviceIds, this.contractIds, this.taskSetup.get("comment", null)));
                }
                this.context = new NPayTariffContext((Preferences)moduleSetup, this.con, this.moduleId, this.startMonth, this.endMonth, this.getOperatingTime(), this.contractIds, this.contractLabelIds, serviceIds);
                this.context.setTariffOptionEnable(this.tariffOptionEnable);
                if (this.preCalcMode) {
                    if (this.activeFromDate != null) {
                        this.context.setPrecalcOpenPeriod(this.preCalcStatus, new Period(TimeUtils.convertCalendarToDate((Calendar)this.activeFromDate), null));
                    }
                    if (this.moduleAmountMap != null) {
                        this.context.setModuleAmountMap(this.moduleAmountMap);
                    }
                    if (this.moduleAccountMap != null) {
                        this.context.setModuleAccountMap(this.moduleAccountMap);
                    }
                    if (this.moduleQuantityMap != null) {
                        this.context.setModuleQuantityMap(this.moduleQuantityMap);
                    }
                } else {
                    this.errorManager = new PeriodicErrorManager(this.con);
                    this.errorManager.initErrorMessage(this.moduleId, "Npay", String.valueOf(this.moduleId), this.startMonth.getTime());
                }
                this.getLogger().debug("Services: {}", serviceIds);
                if (!this.preCalcMode) {
                    this.addCostDetail.init(this.startMonth.getTime(), this.moduleId, this.con);
                }
                cnt = 0;
                if (this.preCalcMode && this.serviceObjectList != null) {
                    contractRuntimeMap = ContractRuntimeMap.getInstance();
                    for (ServiceObject serviceObject : this.serviceObjectList) {
                        contractRuntime = contractRuntimeMap.getContractRuntime(this.con, Integer.valueOf(serviceObject.getContractId()));
                        cnt = this.processServiceObject(cnt, serviceObject, tariffModuleTreeSetDao, contractRuntime.getDomainId(), null);
                    }
                } else {
                    contractId = 0;
                    serviceAccountDetails = null;
                    saveDetails = null;
                    service = null;
                    contractJoin = "";
                    contractJoin = "INNER JOIN contract ON contract.id=npay.cid ";
                    contractJoin = (String)contractJoin + "LEFT JOIN object ON object.id=npay.oid ";
                    query = "SELECT npay.cid, npay.sid, npay.date1, npay.date2, npay.col, npay.emid, npay.eid, contract.domainId, npay.comment, npay.cost, npay.oid, contract.title, object.title FROM npay_service_object_" + this.moduleId + " AS npay " + (String)contractJoin + "WHERE (npay.date1 IS NULL OR npay.date1<=?) AND (npay.date2 IS NULL OR npay.date2>=?) AND npay.sid IN (" + String.valueOf(serviceIds) + ") ";
                    if (Utils.notEmptyCollection(this.contractIds)) {
                        query = query + " AND npay.cid IN (" + String.valueOf(this.contractIds) + ")";
                    } else if (Utils.notEmptyCollection(this.contractLabelIds)) {
                        query = query + " AND contract.id IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString(this.contractLabelIds) + " ))";
                    }
                    query = query + " ORDER BY cid, sid";
                    ps = this.conSlave.prepareStatement(query);
                    try {
                        ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)this.endMonth));
                        ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)this.startMonth));
                        rs = ps.executeQuery();
                        try {
                            if (this.getLogger().isInfoEnabled()) {
                                this.getLogger().info(Utils.memoryStatus());
                            }
                            if (!this.preCalcMode) {
                                balanceDao = new BalanceDao(this.con);
                                try {
                                    balanceDao.cleanContractAccountDetail();
                                }
                                finally {
                                    balanceDao.close();
                                }
                                saveDetails = new SaveDetails(this.startMonth.get(1), this.startMonth.get(2) + 1);
                                service = Executors.newSingleThreadExecutor();
                                service.submit(saveDetails);
                            }
                            while (rs.next()) {
                                nextContractId = rs.getInt("npay.cid");
                                serviceId = rs.getInt("npay.sid");
                                objectId = rs.getInt("npay.oid");
                                entityModuleId = rs.getInt("npay.emid");
                                entityId = rs.getInt("npay.eid");
                                date1 = rs.getDate("npay.date1");
                                date2 = rs.getDate("npay.date2");
                                amount = rs.getBigDecimal("npay.col");
                                accountDetail = null;
                                if (!this.preCalcMode) {
                                    if (contractId != nextContractId) {
                                        saveDetails.addDetails(serviceAccountDetails);
                                        serviceAccountDetails = new HashMap<Integer, ArrayList<E>>();
                                        contractId = nextContractId;
                                    }
                                    if ((accountDetails = (ArrayList<ContractAccountDetail>)serviceAccountDetails.get(serviceId)) == null) {
                                        accountDetails = new ArrayList<ContractAccountDetail>();
                                        serviceAccountDetails.put(serviceId, accountDetails);
                                    }
                                    period = new Period(date1 == null || date1.before(this.startMonth.getTime()) != false ? this.startMonth.getTime() : date1, date2 == null || date2.after(this.endMonth.getTime()) != false ? this.endMonth.getTime() : date2);
                                    accountDetail = ContractAccountDetail.builder().setContractId(contractId).setObjectId(objectId).setServiceId(serviceId).setEntityModuleId(entityModuleId).setEntityId(entityId).setEntityTitle((objectId > 0 ? "\u041e\u0431\u044a\u0435\u043a\u0442: " + rs.getString("object.title") + "[ID#" + objectId + "]" : "\u0414\u043e\u0433\u043e\u0432\u043e\u0440: " + rs.getString("contract.title")) + (String)(entityModuleId > 0 ? " [" + entityModuleId + ":" + entityId + "]" : "")).setPeriod(period).setAmount(amount).setComment(rs.getString("npay.comment")).build();
                                    accountDetails.add(accountDetail);
                                }
                                serviceObject = ServiceObject.builder().setContractId(nextContractId).setObjectId(objectId).setServiceId(serviceId).setDate1((Date)date1).setDate2((Date)date2).setCost(rs.getBigDecimal("npay.cost")).setCol(amount).setEntityModuleId(entityModuleId).setEntityId(entityId).build();
                                cnt = this.processServiceObject(cnt, serviceObject, tariffModuleTreeSetDao, rs.getInt("contract.domainId"), accountDetail);
                            }
                            if (!this.preCalcMode) {
                                if (contractId > 0) {
                                    saveDetails.addDetails(serviceAccountDetails);
                                }
                                saveDetails.finish();
                                service.shutdown();
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                tariffModuleTreeSetDao.close();
                if (!this.preCalcMode) {
                    npayDetailDao = new NpayDetailDao(this.con, this.moduleId, this.startMonth.getTime());
                    npayDetailDao.createTable();
                    autoCommit = this.con.getAutoCommit();
                    try {
                        this.con.setAutoCommit(false);
                        this.con.commit();
                        if (this.taskSetup.getInt("detail", 1) > 0) {
                            npayDetailDao.delete(this.contractIds, serviceIds);
                            npayDetailDao.insert(this.amountDetailCache);
                        }
                        this.con.commit();
                        this.addCostDetail.flushCache(this.con);
                        this.con.commit();
                        this.con.setAutoCommit(autoCommit);
                        balanceUtils.setAccount(this.con, this.getLogger(), this.startMonth, this.costCache, Utils.toString(serviceIds), Utils.toString(this.contractIds), this.contractLabelIds);
                    }
                    finally {
                        this.con.setAutoCommit(autoCommit);
                    }
                }
                if (!this.preCalcMode) {
                    EventProcessor.getInstance().request((QueueEvent)new CalculateEvent(1, this.moduleId, 0, this.startMonth.getTime(), this.endMonth.getTime(), serviceIds, this.contractIds, this.taskSetup.get("comment", null)));
                }
                break block96;
lbl211:
                // 1 sources

                finally {
                    tariffModuleTreeSetDao.close();
                }
            }
            try {
                if (this.preCalcMode != false) return;
                if (this.errorManager == null) return;
                if (Utils.isEmptyCollection(this.contractIds) && Utils.isEmptyCollection(this.contractLabelIds)) {
                    this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                }
                this.errorManager.processErrors();
                return;
            }
            catch (Exception balanceUtils) {
                return;
            }
            finally {
                if (threadContext == null) {
                    this.connectionSet.close();
                }
            }
lbl228:
            // 3 sources

            try {
                if (this.preCalcMode != false) return;
                if (this.errorManager == null) return;
                if (Utils.isEmptyCollection(this.contractIds) && Utils.isEmptyCollection(this.contractLabelIds)) {
                    this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                }
                this.errorManager.processErrors();
                return;
            }
            catch (Exception var3_6) {
                return;
            }
            finally {
                if (threadContext == null) {
                    this.connectionSet.close();
                }
            }
        }
    }

    private int processServiceObject(int cnt, ServiceObject serviceObject, TariffModuleTreeSetDao tariffModuleTreeSetDao, int domainId, ContractAccountDetail accountDetail) {
        int contractId = serviceObject.getContractId();
        int objectId = serviceObject.getObjectId();
        int serviceId = serviceObject.getServiceId();
        try {
            Set<Integer> moduleIds = this.getContractModuleIds(contractId);
            if (moduleIds == null || !moduleIds.contains(this.moduleId)) {
                this.calcErrors = true;
                if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                    String subject = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438";
                    String text = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u043e\u0434\u0443\u043b\u044c mid=" + this.moduleId + " \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 cid=" + contractId + ", \u043d\u043e \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430 sid=" + serviceId;
                    this.errorManager.addErrorToList(subject, text);
                }
                this.getLogger().error("No module mid={} on the contract cid={}, but the presence active sid={}", new Object[]{this.moduleId, contractId, serviceId});
            }
            int emid = serviceObject.getEntityMid();
            int eid = serviceObject.getEntityId();
            Calendar serviceStart = TimeUtils.convertDateToCalendar((Date)serviceObject.getDate1());
            Calendar serviceEnd = TimeUtils.convertDateToCalendar((Date)serviceObject.getDate2());
            BigDecimal col = serviceObject.getCol();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Found service taker: contractId -> {}; objectId -> {}; serviceId -> {}; date1 -> {}; date2 -> {}; amount -> {}", new Object[]{contractId, objectId, serviceId, TimeUtils.formatDate((Calendar)serviceStart), TimeUtils.formatDate((Calendar)serviceEnd), col});
            }
            if (serviceEnd != null && TimeUtils.dateBefore((Calendar)serviceEnd, (Calendar)this.startMonth)) {
                this.getLogger().debug("Service end before month start.");
                return 0;
            }
            if (serviceStart != null && TimeUtils.dateBefore((Calendar)this.endMonth, (Calendar)serviceStart)) {
                this.getLogger().debug("Service starting after month end.");
                return 0;
            }
            Calendar serviceDate1 = this.trimByMonthStart(serviceStart);
            Calendar serviceDate2 = this.trimByMonthEnd(serviceEnd);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("After trimming service period: date1 -> " + TimeUtils.formatDate((Calendar)serviceDate1) + "; date2 -> " + TimeUtils.formatDate((Calendar)serviceDate2));
            }
            TariffModuleTreeSet tariffModuleTreeSet = this.getTreeSet(contractId, emid, eid, tariffModuleTreeSetDao);
            boolean accept = false;
            for (TariffModuleTreeSet.Entry tariffTree : tariffModuleTreeSet.entries()) {
                Calendar tariffFrom = tariffTree.getCalendarFrom();
                Calendar tariffTo = tariffTree.getCalendarTo();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Tariff period: " + TimeUtils.formatPeriod((Calendar)tariffFrom, (Calendar)tariffTo));
                }
                Calendar date1 = (Calendar)serviceDate1.clone();
                Calendar date2 = (Calendar)serviceDate2.clone();
                if (tariffFrom != null && TimeUtils.dateBefore((Calendar)date2, (Calendar)tariffFrom)) {
                    this.getLogger().debug("Tariff from future, skip");
                    continue;
                }
                if (tariffFrom != null && TimeUtils.dateBefore((Calendar)date1, (Calendar)tariffFrom)) {
                    this.getLogger().debug("Trim left service date");
                    date1 = tariffFrom;
                }
                if (tariffTo != null && TimeUtils.dateBefore((Calendar)tariffTo, (Calendar)date2)) {
                    if (!TimeUtils.dateBeforeOrEq((Calendar)date1, (Calendar)tariffTo)) continue;
                    this.getLogger().debug("Trim right service date");
                    date2 = tariffTo;
                }
                NPayServiceCost npayServiceCost = (NPayServiceCost)new NPayServiceCost().setServiceId(serviceId).setServiceStart(serviceStart == null ? null : TimeUtils.convertDateToLocalDate((Date)serviceStart.getTime())).setServiceEnd(serviceEnd == null ? null : TimeUtils.convertDateToLocalDate((Date)serviceEnd.getTime())).setDate1(date1).setDate2(date2).to(NPayServiceCost.class);
                npayServiceCost.amount = col;
                NPayTariffRequest tariffRequest = new NPayTariffRequest(domainId, this.moduleId, serviceObject);
                tariffRequest.setInfoEnable(this.getLogger().isDebugEnabled());
                tariffRequest.setConnectionSet(this.connectionSet);
                tariffRequest.setAccountingMonthDays(this.daysInMonth);
                tariffRequest.tariffDateFrom = tariffFrom;
                tariffRequest.tariffDateTo = tariffTo;
                tariffRequest.setMonthStart(this.startMonth);
                tariffRequest.setMonthEnd(this.endMonth);
                tariffRequest.setTime(date1);
                tariffRequest.setServiceCost(serviceId, Collections.singletonList(npayServiceCost));
                tariffRequest.setTariffTreeSetEntry(tariffTree);
                TariffModuleTree tree = tariffTree.getTree();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Request in tree (treeId={}):", (Object)tree.getTreeId());
                    this.getLogger().debug(tariffRequest.toString());
                }
                tree.execute((AbstractTariffRequest)tariffRequest, (TariffContext)this.context);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Request after processing (treeId={}):", (Object)tree.getTreeId());
                    this.getLogger().debug(tariffRequest.toString());
                }
                if (!tariffRequest.isAccepted()) continue;
                accept = true;
                for (NPayServiceCost serviceCost : tariffRequest.getServiceCostList()) {
                    BigDecimal addCost = serviceCost.addCost;
                    if (addCost != null) {
                        this.addCostDetail.addRecord(new AddCostItem(contractId, serviceCost.getServiceId(), addCost));
                    }
                    if (accountDetail != null) {
                        accountDetail.setCost(serviceCost.getUnitCost());
                        accountDetail.setSum(serviceCost.getCost());
                        this.getLogger().debug("AccountDetail contractId: {}; serviceId: {}; cost: {}; sum: {}", new Object[]{contractId, serviceCost.getServiceId(), accountDetail.getCost(), accountDetail.getSum()});
                    }
                    CostSum sum = new CostSum(contractId, serviceCost.getServiceId(), serviceCost.getCost());
                    this.costCache.addAmount(sum);
                    this.getLogger().debug("Add cost cache contractId: {}; serviceId: {}; cost: {}", new Object[]{contractId, serviceCost.getServiceId(), serviceCost.getCost()});
                    AmountDetail detail = new AmountDetail(contractId, serviceCost.getServiceId(), emid, eid, tree.getTreeId());
                    detail.col = col;
                    detail.cost = sum.cost;
                    this.amountDetailCache.addAmount(detail);
                    this.getLogger().debug("Add detail amount cache contractId: {}; serviceId: {}; moduleId: {}; eid: {}; cost: {}", new Object[]{contractId, serviceCost.getServiceId(), this.moduleId, eid, sum.cost});
                    this.configCache.addConfig(contractId, tariffRequest.getConfig());
                    this.getLogger().debug("Add config cache contractId: {}; serviceId: {}; config: {}", new Object[]{contractId, serviceCost.getServiceId(), tariffRequest.getConfig()});
                }
            }
            if (!accept) {
                this.calcErrors = true;
                if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                    String subject = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438";
                    String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + "\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + serviceId;
                    this.errorManager.addErrorToList(subject, text);
                }
                this.getLogger().error("Tariff error (no accept) contractId: {}; serviceId: {}", (Object)contractId, (Object)serviceId);
            }
            if (++cnt % 1000 == 0 && this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Item count " + cnt);
            }
        }
        catch (Exception e) {
            this.calcErrors = true;
            if (!this.preCalcMode && !this.errorManager.isCapReached()) {
                String subject = "\u041d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 " + e.getMessage();
                String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + "\n\u041e\u0431\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u043c\u0430\u044f \u0443\u0441\u043b\u0443\u0433\u0430: " + serviceId;
                this.errorManager.addErrorToList(subject, text, e);
            }
            Contract c = null;
            try {
                c = ContractDao.getContract((Connection)this.con, (int)contractId);
            }
            catch (BGException e1) {
                this.getLogger().error("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u044b \u0441 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c " + contractId + " \u0438\u0437 \u0411\u0414", (Throwable)e1);
            }
            this.getLogger().error("Fatal tariff error contractId: " + contractId + "; serviceId: " + serviceId + "; contractStatus: " + c.getStatus(), (Throwable)e);
        }
        return cnt;
    }

    private Calendar trimByMonthEnd(Calendar date) {
        if (date == null || TimeUtils.dateBefore((Calendar)this.endMonth, (Calendar)date)) {
            date = (Calendar)this.endMonth.clone();
        }
        return date;
    }

    private Calendar trimByMonthStart(Calendar date1) {
        if (date1 == null || TimeUtils.dateBefore((Calendar)date1, (Calendar)this.startMonth)) {
            date1 = (Calendar)this.startMonth.clone();
        }
        return date1;
    }

    private TariffModuleTreeSet getTreeSet(int contractId, int entityModuleid, int entityId, TariffModuleTreeSetDao tariffModuleTreeSetDao) throws BGException {
        TariffModuleTreeSet result;
        Map<Integer, TariffModuleTreeSet> eidMap;
        Map<Integer, Map<Integer, TariffModuleTreeSet>> emidMap;
        SoftReference<Map<Integer, Map<Integer, TariffModuleTreeSet>>> emidMapRef = this.treeSetMap.get(contractId);
        Map<Integer, Map<Integer, TariffModuleTreeSet>> map = emidMap = emidMapRef != null ? emidMapRef.get() : null;
        if (emidMap == null) {
            emidMap = new HashMap<Integer, Map<Integer, TariffModuleTreeSet>>(8);
            this.treeSetMap.put(contractId, new SoftReference<Map<Integer, Map<Integer, TariffModuleTreeSet>>>(emidMap));
        }
        if ((eidMap = emidMap.get(entityModuleid)) == null) {
            eidMap = new HashMap<Integer, TariffModuleTreeSet>(8);
            emidMap.put(entityModuleid, eidMap);
        }
        if ((result = eidMap.get(entityId)) == null) {
            result = this.tariffList != null ? tariffModuleTreeSetDao.getRealtimeTariffTreeSet("npay", this.moduleId, this.tariffList) : tariffModuleTreeSetDao.getRealtimeTariffTreeSet(contractId, this.startMonth.getTime(), "npay", this.moduleId, entityModuleid, entityId);
            eidMap.put(entityId, result);
        }
        return result;
    }

    public void setModuleAmountMap(Map<Integer, ModuleAmount> moduleAmountMap) {
        this.moduleAmountMap = moduleAmountMap;
    }

    public void setModuleAccountMap(Map<Integer, ModuleAccount> moduleAccountMap) {
        this.moduleAccountMap = moduleAccountMap;
    }

    public void setModuleQuantityMap(Map<Integer, ModuleQuantity> moduleQ\u043auantityMap) {
        this.moduleQuantityMap = moduleQ\u043auantityMap;
    }

    public List<TaskParameter> taskParameters() {
        List taskParameters = super.taskParameters();
        taskParameters.add(new TaskParameter().setKey("hour.minus").setTitle("hour.minus").setDefaultValue("true"));
        return taskParameters;
    }

    class AddCostDetail {
        private String tableName;
        private Map<String, AddCostItem> cache = new HashMap<String, AddCostItem>(100);

        public void init(Date month, int mid, Connection con) {
            this.tableName = ServerUtils.getModuleMonthTableName((String)"npay_add_cost_detail", (Date)month, (int)mid);
            String query = null;
            try {
                Statement st;
                if (!ServerUtils.tableExists((Connection)con, (String)this.tableName)) {
                    query = "CREATE TABLE " + this.tableName + " ( cid INT NOT NULL, sid INT NOT NULL, summa DECIMAL(15,2) NOT NULL, KEY cid(cid) )";
                    st = con.createStatement();
                    try {
                        st.executeUpdate(query);
                    }
                    finally {
                        if (st != null) {
                            st.close();
                        }
                    }
                }
                query = "DELETE FROM " + this.tableName;
                if (Utils.notEmptyCollection(Calculator.this.contractIds)) {
                    query = query + " WHERE cid IN ( " + String.valueOf(Calculator.this.contractIds) + ")";
                }
                st = con.createStatement();
                try {
                    st.executeUpdate(query);
                }
                finally {
                    if (st != null) {
                        st.close();
                    }
                }
            }
            catch (Exception e) {
                Calculator.this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }

        public void addRecord(AddCostItem item) {
            this.cache.put(item.getKey(), item);
        }

        public void flushCache(Connection con) {
            String query = "INSERT INTO " + this.tableName + " SET cid=?, sid=?, summa=?";
            try (PreparedStatement ps = con.prepareStatement(query);){
                for (AddCostItem item : this.cache.values()) {
                    ps.setInt(1, item.cid);
                    ps.setInt(2, item.sid);
                    ps.setBigDecimal(3, item.summa);
                    ps.executeUpdate();
                }
            }
            catch (Exception ex) {
                Calculator.this.logError(ex);
            }
        }
    }

    class SaveDetails
    implements Runnable {
        private boolean run = true;
        private int year;
        private int month;
        private Deque<Map<Integer, List<ContractAccountDetail>>> deque = new ArrayDeque<Map<Integer, List<ContractAccountDetail>>>();

        public SaveDetails(int year, int month) {
            this.year = year;
            this.month = month;
        }

        public void addDetails(Map<Integer, List<ContractAccountDetail>> map) {
            if (map != null) {
                this.deque.addLast(map);
            }
        }

        public void finish() {
            this.run = false;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                con = Setup.getSetup().getDBConnection();
                try {
                    balanceDao = new BalanceDao(con);
                    try {
                        block18: while (true) {
                            if ((map = this.deque.poll()) == null) {
                                if (this.run == false) return;
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                continue;
                            }
                            try {
                                contractId = map.values().stream().findFirst().map((Function<List, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$run$0(java.util.List ), (Ljava/util/List;)Ljava/lang/Integer;)()).orElse(0);
                                balanceDao.removeContractAccountDetail(contractId, this.year, this.month, map.keySet());
                            }
                            catch (Exception ex) {
                                Calculator.this.logError(ex);
                            }
                            var4_8 = map.values().iterator();
                            while (true) {
                                if (var4_8.hasNext()) ** break;
                                continue block18;
                                accountDetails = var4_8.next();
                                try {
                                    balanceDao.addContractAccountDetail(accountDetails);
                                }
                                catch (Exception ex) {
                                    Calculator.this.logError(ex);
                                }
                            }
                            break;
                        }
                    }
                    finally {
                        balanceDao.close();
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (Exception ex) {
                Calculator.this.logError(ex);
            }
        }

        private static /* synthetic */ Integer lambda$run$0(List a) {
            return ((ContractAccountDetail)a.get(0)).getContractId();
        }
    }
}

