/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.bean.filter;

import java.lang.ref.SoftReference;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.engine.JRDataset;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class BGReportFilter {
    private Map<String, String> filter;
    private Preferences setup;
    private Map<String, Object> parameterMap;
    private int userId;
    private JRDataset dataset;
    private static Map<String, SoftReference<Object>> cacheMap = new ConcurrentHashMap<String, SoftReference<Object>>();

    public BGReportFilter(Map<String, String> filter, Preferences setup, int userId) {
        this(filter, setup, Collections.emptyMap(), null, userId);
    }

    public BGReportFilter(Map<String, Object> parameterMap, int userId) {
        this(Collections.emptyMap(), null, parameterMap, null, userId);
    }

    public BGReportFilter(Map<String, String> filter, Preferences setup, Map<String, Object> parameterMap, JRDataset dataset, int userId) {
        this.filter = filter;
        this.setup = setup;
        this.parameterMap = parameterMap;
        this.dataset = dataset;
        this.userId = userId;
    }

    public final String getStringParam(String name) {
        String result = this.filter.get(name);
        if (result == null && this.setup != null) {
            return this.setup.get(name, null);
        }
        return result;
    }

    public int getIntParam(String name) {
        return Utils.parseInt((String)this.getStringParam(name), (int)0);
    }

    public int getIntParam(String name, int def) {
        return Utils.parseInt((String)this.getStringParam(name), (int)def);
    }

    public long getLongParam(String name) {
        return Utils.parseLong((String)this.getStringParam(name), (long)0L);
    }

    public boolean getBooleanParam(String name) {
        return Utils.parseBoolean((String)this.getStringParam(name));
    }

    public long getLongParam(String name, long def) {
        return Utils.parseLong((String)this.getStringParam(name), (long)def);
    }

    public Calendar getCalendarParam(String name) {
        return this.getCalendarParam(name, null);
    }

    public Calendar getCalendarParam(String name, Calendar defaultValue) {
        String value = this.getStringParam(name);
        return value != null ? TimeUtils.parseCalendar((String)value, (String)"dd.MM.yyyy") : defaultValue;
    }

    public LocalDate getLocalDateParam(String name) {
        return this.getLocalDateParam(name, null);
    }

    public LocalDate getLocalDateParam(String name, LocalDate defaultValue) {
        return Optional.ofNullable(this.getStringParam(name)).filter(a -> Utils.notBlankString((String)a)).map(a -> TimeUtils.parseLocalDate((String)a)).orElse(defaultValue);
    }

    public Date getDateParam(String name) {
        return TimeUtils.parseDate((String)this.getStringParam(name), (String)"dd.MM.yyyy");
    }

    public Period getPeriod() {
        Period period = new Period();
        period.setDateFrom(TimeUtils.parseDate((String)this.getStringParam("date1"), (String)"dd.MM.yyyy"));
        period.setDateTo(TimeUtils.parseDate((String)this.getStringParam("date2"), (String)"dd.MM.yyyy"));
        return period;
    }

    public void setCalendarParam(String name, Calendar value) {
        this.filter.put(name, TimeUtils.formatDate((Calendar)value));
    }

    public void setStringParam(String name, String value) {
        this.filter.put(name, value);
    }

    public Map<String, Object> getReportParametersMap() {
        return this.parameterMap;
    }

    public ParameterMap getHashValuesWithPrefix(String prefix) {
        return this.setup.sub(prefix);
    }

    public void cachePut(String key, Object o) {
        cacheMap.put(key, new SoftReference<Object>(o));
    }

    public Object cacheGet(String key) {
        SoftReference<Object> ref = cacheMap.get(key);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }

    public JRDataset getDataset() {
        return this.dataset;
    }

    public int getUserId() {
        return this.userId;
    }
}

