/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sberbank.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.sberbank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.sberbank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.sberbank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.sberbank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.sberbank.server.event.SberbankAutopaymentEvent;
import ru.bitel.bgbilling.modules.sberbank.server.event.SberbankCheckEvent;
import ru.bitel.bgbilling.modules.sberbank.server.event.worker.SberbankAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.sberbank.server.event.worker.SberbankCheckEventWorker;
import ru.bitel.bgbilling.modules.sberbank.server.service.SberbankServiceImpl;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.sberbank.server"};
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), SberbankServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(module.getId())).getBoolean("sberbank.event.worker", true)) {
            new SberbankCheckEventWorker(Setup.getSetup(), module.getId());
            new SberbankAutopaymentEventWorker(Setup.getSetup(), module.getId());
        } else {
            this.addListeners(module);
        }
    }

    @Deprecated
    private void addListeners(final BGModule module) throws BGException {
        EventProcessor.getInstance().addListener((EventListener)new EventListener<SberbankCheckEvent>(){

            public void notify(SberbankCheckEvent event, EventListenerContext ctx) throws Exception {
                TransactionManager transactionManager = new TransactionManager(ctx.getConnection(), module.getId());
                transactionManager.doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            }
        }, SberbankCheckEvent.class, module.getId(), null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<SberbankAutopaymentEvent>(){

            public void notify(SberbankAutopaymentEvent event, EventListenerContext ctx) throws Exception {
                Contract contract;
                int moduleId = module.getId();
                int contractId = event.getContractId();
                Connection con = ctx.getConnection();
                Autopayment autopayment = new AutopaymentManager(con, moduleId).getCurrentAutopayment(contractId);
                BigDecimal sum = event.getSum();
                if (sum == null) {
                    sum = autopayment.getSum();
                }
                if (autopayment != null && autopayment.getMode().getCode() == event.getMode() && (contract = ContractDao.getContract((Connection)con, (int)contractId)) != null) {
                    String customerAddress = ContractUtils.getCustomerAddress((Connection)con, (int)moduleId, (int)contractId);
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    TransactionManager transactionManager = new TransactionManager(con, moduleId);
                    Transaction transaction = transactionManager.registerOrder(contractId, contract.getTitle(), customerAddress, sum, dataMap, true, true, "");
                    String result = transactionManager.paymentOrderBinding(transaction, autopayment);
                    if (result != null) {
                        Map parameterMap = Utils.stringToPairsHash((String)result.replace("\n", ";"));
                        if ("0".equals(parameterMap.get("errorCode"))) {
                            transactionManager.doCheckRequest(contractId, true);
                        } else {
                            transaction.setStatus(TransactionStatus.ERROR.getCode());
                            TransactionManager.addTransactionParameters(transaction, result);
                            transactionManager.update(transaction);
                        }
                    }
                }
            }
        }, SberbankAutopaymentEvent.class, module.getId(), null);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "sberbank", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        ArrayList<PaymentMethod> methods = new ArrayList<PaymentMethod>();
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getBoolean("sberbank.sbp.enable", false)) {
            methods.add(PaymentMethod.SBP);
        }
        methods.add(PaymentMethod.CARD);
        return methods;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

