/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemType;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.treetable.BGTreeTableModel;

public class StockItemTypePanel
extends BGUPanel {
    private StockItemTypeTreeTableModel treeTableModel;
    private BGUTreeTable treeTable;
    private WarehouseService warehouseService;

    protected void jbInit() throws Exception {
        this.treeTableModel = new StockItemTypeTreeTableModel();
        this.treeTable = new BGUTreeTable((BGTreeTableModel)this.treeTableModel);
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    StockItemTypePanel.this.performAction("edit");
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.treeTable), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new ItemTypeEditorPanel(null, (ClientContext)this.getContext()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            StockItemType selected = (StockItemType)this.treeTableModel.getSelectedRow();
            if (selected == null || selected.getId() <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                return;
            }
            new ItemTypeEditorPanel(selected, (ClientContext)this.getContext()).open();
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            StockItemType selected = (StockItemType)this.treeTableModel.getSelectedRow();
            if (selected == null || selected.getId() <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
                return;
            }
            if (ClientUtils.confirm((String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 \u043f\u0440\u0438\u0432\u0435\u0434\u0451\u0442 \u043a \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044e \u0432\u0441\u0435\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430. \u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c?", (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435")) {
                if (Utils.notEmptyCollection((Collection)selected.getChildren())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0427\u0442\u043e\u0431\u044b \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f - \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0434\u043e\u0447\u0435\u0440\u043d\u0438\u0435");
                    return;
                }
                this.getWarehouseService().deleteStockItemType(selected.getId());
                this.performAction("refresh");
            }
        });
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.treeTableModel.setData(this.getWarehouseService().getStockItemTypeTreeRoot());
            this.treeTable.expandAfterUpdate();
        });
    }

    private WarehouseService getWarehouseService() {
        if (this.warehouseService == null) {
            this.warehouseService = (WarehouseService)((ClientContext)this.getContext()).getPort(WarehouseService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.warehouseService;
    }

    private final class StockItemTypeTreeTableModel
    extends BGTreeTableModel<StockItemType> {
        private final Icon rootIcon;
        private final Icon folderIcon;
        private final Icon childIcon;

        public StockItemTypeTreeTableModel() {
            super("stockItemTypeTreeTable");
            this.rootIcon = ClientUtils.getIcon((String)"fugue/tree");
            this.folderIcon = ClientUtils.getIcon((String)"fugue/category");
            this.childIcon = ClientUtils.getIcon((String)"fugue/zone");
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", StockItemType.class, false);
            this.addColumnId();
        }

        public Icon getIcon(StockItemType type) {
            if (type.getId() == 0) {
                return this.rootIcon;
            }
            if (Utils.isEmptyCollection((Collection)type.getChildren())) {
                return this.childIcon;
            }
            return this.folderIcon;
        }

        public Object getValue(StockItemType stockItemType, int column) throws Exception {
            if (column == 0) {
                return stockItemType.getId() == 0 ? this.root : stockItemType;
            }
            return super.getValue((Object)stockItemType, column);
        }
    }

    private final class ItemTypeEditorPanel
    extends BGEditorDialog<StockItemType> {
        private final JTextField title;
        private final BGUComboBox<StockItemType> parentTypeCombobox;
        private final BGUComboBox<StockItemAttributeKit> attributeKit;

        public ItemTypeEditorPanel(StockItemType data, ClientContext clientContext) {
            super("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", (Object)data, clientContext);
            this.title = new JTextField();
            this.parentTypeCombobox = new BGUComboBox();
            this.attributeKit = new BGUComboBox();
        }

        public void doDialogPanel() {
            JPanel editorPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
            editorPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), constraints);
            editorPanel.add((Component)this.title, constraints);
            editorPanel.add((Component)new JLabel("\u041d\u0430\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u044c \u043e\u0442"), constraints);
            editorPanel.add((Component)this.parentTypeCombobox, constraints);
            editorPanel.add((Component)new JLabel("\u041d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432"), constraints);
            editorPanel.add((Component)this.attributeKit, constraints);
            this.panel.add((Component)editorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.openEditor();
        }

        public boolean doApply() throws Exception {
            StockItemType type = this.getEditorData();
            if (Utils.isBlankString((String)type.getTitle())) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!");
                return false;
            }
            if (type.getParentTypeId() <= 0 && type.getAttributeKit() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0430\u0431\u043e\u0440 \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432");
                return false;
            }
            try {
                StockItemTypePanel.this.getWarehouseService().updateStockItemType(type);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            StockItemTypePanel.this.performAction("refresh");
            return true;
        }

        void openEditor() {
            this.reloadCombobox();
            if (this.data != null) {
                this.title.setText(((StockItemType)this.data).getTitle());
                this.parentTypeCombobox.getData().stream().filter(i -> i.getId() == ((StockItemType)this.data).getParentTypeId()).findAny().ifPresent(arg_0 -> this.parentTypeCombobox.setSelectedItem(arg_0));
                if (((StockItemType)this.data).getAttributeKit() != null) {
                    this.attributeKit.setSelectedItem((Object)((StockItemType)this.data).getAttributeKit());
                }
            } else {
                this.title.setText("");
                this.parentTypeCombobox.setSelectedIndex(0);
                this.attributeKit.setSelectedIndex(0);
            }
        }

        private void reloadCombobox() {
            try {
                ArrayList<StockItemType> types = new ArrayList<StockItemType>();
                types.add(new StockItemType(-1, "----------"));
                types.addAll(StockItemTypePanel.this.getWarehouseService().stockItemTypeList());
                this.parentTypeCombobox.setData(types);
                ArrayList<StockItemAttributeKit> kits = new ArrayList<StockItemAttributeKit>();
                kits.add(new StockItemAttributeKit(-1, "----------"));
                kits.addAll(StockItemTypePanel.this.getWarehouseService().getAttributeKitList());
                this.attributeKit.setData(kits);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        StockItemType getEditorData() {
            if (this.data == null) {
                this.data = new StockItemType();
            }
            ((StockItemType)this.data).setTitle(this.title.getText());
            if (((StockItemAttributeKit)this.attributeKit.getSelectedItem()).getId() > 0) {
                ((StockItemType)this.data).setAttributeKit((StockItemAttributeKit)this.attributeKit.getSelectedItem());
            }
            if (((StockItemType)this.parentTypeCombobox.getSelectedItem()).getId() > 0) {
                ((StockItemType)this.data).setParentTypeId(((StockItemType)this.parentTypeCombobox.getSelectedItem()).getId());
            }
            return (StockItemType)this.data;
        }
    }
}

