/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean.flussonicwatcher;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.flussonicwatcher.FlussonicWatcherCamera;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class FlussonicWatcherCameraDao
extends AbstractIdDao<FlussonicWatcherCamera> {
    public FlussonicWatcherCameraDao(Connection con, int moduleId) {
        super(con, "smarthouse_flussonicwatcher_camera", moduleId);
    }

    public void searchCameraList(SearchResult<FlussonicWatcherCamera> searchResult) throws SQLException {
        ResultSet rs;
        Objects.requireNonNull(searchResult, "searchResult must be not null");
        Page page = searchResult.getPage();
        List cameras = searchResult.getList();
        String query = "SELECT * FROM " + this.tableName + Page.toSqlLimit((Page)page);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    cameras.add(this.getFromRS(rs));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        query = "SELECT COUNT(*) FROM " + this.tableName;
        ps = this.con.prepareStatement(query);
        try {
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    page.setRecordCount(rs.getInt(1));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    protected FlussonicWatcherCamera getFromRS(ResultSet rs) throws SQLException {
        return new FlussonicWatcherCamera().setId(rs.getInt("id")).setCameraModel(rs.getString("camera_model")).setCameraSerial(rs.getString("camera_serial")).setCreateTime(TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp("create_date"))).setCreateUserId(rs.getInt("create_user_id")).setFlussonicWatcherCameraId(rs.getInt("fw_camera_id"));
    }

    protected void updateImpl(FlussonicWatcherCamera camera) throws SQLException {
        Objects.requireNonNull(camera);
        String querySet = "camera_model=?, camera_serial=?, create_date=?, create_user_id=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)camera, querySet);){
            int index = 1;
            ps.setString(index++, camera.getCameraModel());
            ps.setString(index++, camera.getCameraSerial());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp((LocalDateTime)camera.getCreateTime()));
            ps.setInt(index++, camera.getCreateUserId());
            this.executeUpdate((Id)camera, index, ps);
        }
    }
}

