/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccount;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseAccountType;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHouseOption;
import ru.bitel.bgbilling.modules.smarthouse.common.handler.SmartHouseFlussonicWatcherHandler;
import ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseService;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseAccountDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseAccountTypeDao;
import ru.bitel.bgbilling.modules.smarthouse.server.bean.SmartHouseOptionDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.smarthouse.common.service.SmartHouseService")
public class SmartHouseServiceImpl
extends AbstractService
implements SmartHouseService {
    private SmartHouseOptionDao smartHouseOptionDao;
    private SmartHouseAccountDao smartHouseAccountDao;
    private SmartHouseAccountTypeDao smartHouseAccountTypeDao;

    @PostConstruct
    private void init() {
        this.smartHouseOptionDao = new SmartHouseOptionDao(this.getConnection(), this.moduleId);
        this.smartHouseAccountDao = new SmartHouseAccountDao(this.getConnection(), this.moduleId);
        this.smartHouseAccountTypeDao = new SmartHouseAccountTypeDao(this.getConnection(), this.moduleId);
    }

    public List<SmartHouseAccountType> smarthouseAccountTypes() throws BGException {
        return (List)this.tryReturn(() -> this.smartHouseAccountTypeDao.list());
    }

    public SmartHouseAccountType smarthouseAccountTypeGet(int id) throws BGException {
        return (SmartHouseAccountType)this.tryReturn(() -> id == 0 ? new SmartHouseAccountType() : (SmartHouseAccountType)this.smartHouseAccountTypeDao.get(id));
    }

    public int smarthouseAccountTypeUpdate(SmartHouseAccountType accountType) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.smartHouseAccountTypeDao.update(accountType);
            return accountType.getId();
        });
    }

    public SmartHouseOption smarthouseOptionGet(int id) throws BGException {
        if (id == 0) {
            return new SmartHouseOption();
        }
        return (SmartHouseOption)this.tryReturn(() -> (SmartHouseOption)this.smartHouseOptionDao.get(id));
    }

    public int smarthouseOptionUpdate(SmartHouseOption option) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.smartHouseOptionDao.update(option);
            return option.getId();
        });
    }

    public List<IdTitle> smarthouseServices() throws BGException {
        return ModuleCache.getInstance().getModuleServicesList(this.moduleId).stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    public List<IdTitle> npayModules() throws BGException {
        return ModuleCache.getInstance().getModulesList("npay").stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    public List<IdTitle> npayServices(int moduleId) throws BGException {
        return ModuleCache.getInstance().getModuleServicesList(moduleId).stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    public SearchResult<SmartHouseAccount> smarthouseAccountSearch(int contractId, int contractObjectId) throws BGException {
        return (SearchResult)this.tryReturn(() -> {
            SearchResult searchResult = new SearchResult();
            searchResult.setList(this.smartHouseAccountDao.list(contractId, contractObjectId));
            return searchResult;
        });
    }

    public SmartHouseAccount smarthouseAccountGet(int id) throws BGException {
        return (SmartHouseAccount)this.tryReturn(() -> (SmartHouseAccount)this.smartHouseAccountDao.get(id));
    }

    public int smarthouseAccountUpdate(SmartHouseAccount smartHouseAccount) throws BGException {
        Objects.requireNonNull(smartHouseAccount, "smartHouseAccount must be not null");
        return (Integer)this.tryReturn(() -> {
            SmartHouseAccountTypeDao accountTypeDao = new SmartHouseAccountTypeDao(this.getConnection(), this.moduleId);
            SmartHouseAccountType accountType = (SmartHouseAccountType)accountTypeDao.get(smartHouseAccount.getType());
            if (Utils.notBlankString((String)accountType.getHandlerClass())) {
                SmartHouseFlussonicWatcherHandler handler = (SmartHouseFlussonicWatcherHandler)DynamicClassManager.getInstance().newInstance(SmartHouseFlussonicWatcherHandler.class, accountType.getHandlerClass());
                handler.onContractAccountUpdate(smartHouseAccount, this.moduleId);
            }
            this.smartHouseAccountDao.update(smartHouseAccount);
            return smartHouseAccount.getId();
        });
    }

    public boolean smarthouseAccountDelete(int id) throws BGException {
        return (Boolean)this.tryReturn(() -> this.smartHouseAccountDao.delete(id) > 0);
    }
}

