/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.bean.ClosedSormContract;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;

public class ContractsWithClosedSormResourcesDialog
extends BGDialog {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private final SormService sormService;
    private final SormProject selectedSormProject;

    protected ContractsWithClosedSormResourcesDialog(SormService sormService, SormProject sormProject) throws Exception {
        if (sormProject == null) {
            throw new BGException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u043f\u0440\u043e\u0435\u043a\u0442 \u0421\u041e\u0420\u041c!");
        }
        this.sormService = sormService;
        this.selectedSormProject = sormProject;
        Dimension dimension = new Dimension(1000, 800);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.setLocationRelativeTo(null);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(mainPanel);
        this.init();
        this.show();
    }

    private void init() throws Exception {
        this.tabbedPane.addTab("\u0417\u0430\u043a\u0440\u044b\u0442\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0432\u044b\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u044b\u043c\u0438 \u043c\u043e\u0434\u0443\u043b\u044f\u043c\u0438", this.initPaneWithClosedContracts());
        this.tabbedPane.addTab("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0437\u0430\u043a\u0440\u044b\u043c\u0438 \u0441\u0435\u0440\u0432\u0438\u0441\u0430\u043c\u0438/\u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430\u043c\u0438", this.initPaneWithClosedResource());
    }

    private JPanel initPaneWithClosedContracts() throws Exception {
        return this.initCommonPane(this.sormService.checkClosedContract());
    }

    private JPanel initPaneWithClosedResource() throws Exception {
        return this.initCommonPane(this.sormService.searchOpenedContractsWithClosedServices(this.selectedSormProject));
    }

    private JPanel initCommonPane(List<ClosedSormContract> closedSormContracts) {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel countContractsLabel = new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432\u0441\u0435\u0433\u043e: " + closedSormContracts.size());
        final ClosedContractTableModel tableModel = new ClosedContractTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)tableModel));
        Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
            if (event.getID() == 500 && table.rowAtPoint(((MouseEvent)event).getPoint()) == -1) {
                table.clearSelection();
            }
        }, 16L);
        table.addMouseListener((MouseListener)new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                List selectedContracts = tableModel.getSelectedRows();
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && Utils.notEmptyCollection((Collection)selectedContracts)) {
                    for (ClosedSormContract selectedContract : selectedContracts) {
                        BGClientBase.getFrame().getTabbedPane().addContractEditorTab(selectedContract.getId());
                    }
                }
            }
        });
        tableModel.setData(closedSormContracts);
        JButton button = new JButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u044c \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        button.addActionListener(e -> {
            try {
                List selectedContracts = tableModel.getSelectedRows();
                List allRows = tableModel.getRows();
                if (Utils.isEmptyCollection((Collection)selectedContracts) && Utils.notEmptyCollection((Collection)allRows)) {
                    if (ClientUtils.confirm((String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u043e \u0432\u0441\u0435\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u043c\u043e\u0434\u0443\u043b\u044c \u0421\u041e\u0420\u041c?", (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432")) {
                        this.sormService.removeModuleOfContracts(allRows.stream().mapToInt(Id::getId).boxed().collect(Collectors.toSet()));
                    }
                } else if (ClientUtils.confirm((String)("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043c\u043e\u0434\u0443\u043b\u044c \u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432? \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432\u044b\u0431\u0440\u0430\u043d\u043e = " + selectedContracts.size()), (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043c\u043e\u0434\u0443\u043b\u044f \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432")) {
                    this.sormService.removeModuleOfContracts(selectedContracts.stream().mapToInt(Id::getId).boxed().collect(Collectors.toSet()));
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        panel.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)countContractsLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 3, 0, 3), 0, 0));
        return panel;
    }

    private static final class ClosedContractTableModel
    extends BGTableModel<ClosedSormContract> {
        public ClosedContractTableModel() {
            super("closedContractTableModel");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", String.class, -1, -1, -1, "title", true);
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", String.class, -1, -1, -1, "moduleTitle", true);
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", String.class, -1, -1, -1, "description", false);
        }
    }
}

