/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.ClosedSormContract;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ContractWithClosedServices {
    private final int sormModuleId;
    private final Connection connection;
    private final Date maxDateRange = Date.from(ZonedDateTime.ofInstant(Instant.now(), ZoneId.of("UTC")).minus(3L, ChronoUnit.YEARS).toInstant());

    public ContractWithClosedServices(Connection connection, int sormModuleId) {
        this.sormModuleId = sormModuleId;
        this.connection = connection;
    }

    public List<ClosedSormContract> search(UploadModulesTitle moduleTitle, InstalledInstanceModule moduleInstance) throws BGException {
        if (moduleTitle == null) {
            return Collections.emptyList();
        }
        List<ClosedSormContract> result = null;
        try {
            switch (moduleTitle) {
                case INET: {
                    String tableName = ServerUtils.getModuleTableName((String)"inet_serv", (int)moduleInstance.getModuleId());
                    String query = "SELECT serv.contractId FROM contract_module AS cm LEFT JOIN " + tableName + " AS serv ON cm.cid=serv.contractId WHERE cm.mid=? AND serv.contractId>0 AND serv.dateTo<? AND (SELECT COUNT(contractId) FROM " + tableName + " WHERE ((dateTo IS NULL OR dateTo>?) AND cm.cid=contractId))=0 GROUP BY serv.contractId";
                    result = this.search(moduleInstance, query, "contractId", "\u0417\u0430\u043a\u0440\u044b\u0442 \u0441\u0435\u0440\u0432\u0438\u0441 \u043c\u043e\u0434\u0443\u043b\u044f Inet.");
                    break;
                }
                case VOICE: {
                    String tableNameBase = ServerUtils.getModuleTableName((String)"voice_account_base", (int)moduleInstance.getModuleId());
                    String query = "SELECT base.contractId FROM contract_module AS cm LEFT JOIN " + tableNameBase + " AS base ON cm.cid=base.contractId WHERE cm.mid=? AND base.contractId>0 AND base.dateTo<? AND (SELECT COUNT(contractId) FROM " + tableNameBase + " WHERE ((dateTo IS NULL OR dateTo>?) AND cm.cid=contractId))=0 GROUP BY base.contractId";
                    result = this.search(moduleInstance, query, "base.contractId", "\u0417\u0430\u043a\u0440\u044b\u0442 \u043f\u0435\u0440\u0438\u043e\u0434 \u0431\u043e\u043b\u0435\u0435 3-\u0445 \u043b\u0435\u0442 \u0443 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430");
                    break;
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException("ModuleId=" + moduleInstance.getModuleId() + ", moduleTitle=" + moduleTitle.getTitleModule() + ", Ex: " + String.valueOf(ex));
        }
        return result == null ? Collections.emptyList() : result;
    }

    private List<ClosedSormContract> search(InstalledInstanceModule module, String query, String cidParameterName, String description) throws SQLException {
        ArrayList<ClosedSormContract> contracts = new ArrayList<ClosedSormContract>();
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setInt(1, this.sormModuleId);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)this.maxDateRange));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)new Date()));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ClosedSormContract sormContract = new ClosedSormContract(rs.getInt(cidParameterName));
                sormContract.setModuleTitle(module.getTitle());
                sormContract.setModuleId(module.getModuleId());
                sormContract.setDescription(description);
                contracts.add(sormContract);
            }
            rs.close();
        }
        return contracts;
    }

    public boolean hasOpenResources(int cid, UploadModulesTitle module, InstalledInstanceModule moduleInstance) throws BGException {
        String query = null;
        switch (module) {
            case INET: {
                String tableName = ServerUtils.getModuleTableName((String)"inet_serv", (int)moduleInstance.getModuleId());
                query = "SELECT COUNT(contractId) AS count FROM " + tableName + " WHERE contractId=? AND (dateTo IS NULL OR dateTo>?)";
                break;
            }
            case VOICE: {
                String tableName = ServerUtils.getModuleTableName((String)"voice_account_base", (int)moduleInstance.getModuleId());
                query = "SELECT COUNT(contractId) AS count FROM " + tableName + " WHERE contractId=? AND (dateTo IS NULL OR dateTo>?)";
                break;
            }
        }
        return this.hasOpenResources(cid, query);
    }

    private boolean hasOpenResources(int cid, String query) throws BGException {
        if (cid <= 0 || Utils.isBlankString((String)query)) {
            return false;
        }
        boolean result = false;
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setInt(1, cid);
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)this.maxDateRange));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt("count") > 0;
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }
}

