/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.server.upload.SormTransferFiles;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadFiles;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class SormFTPTransferFiles
extends SormTransferFiles {
    public SormFTPTransferFiles(UploadFiles uploadFiles, Preferences config, Upload versionUpload) throws BGException {
        super(config);
        this.startUpload(this.getFTPConnect(config), uploadFiles, versionUpload, config);
    }

    private FTPClient getFTPConnect(Preferences config) throws BGException {
        FTPClient ftpClient = new FTPClient();
        try {
            int timeout = 7000;
            ftpClient.setConnectTimeout(timeout);
            ftpClient.setDataTimeout(timeout);
            ftpClient.setDefaultTimeout(timeout);
            ftpClient.connect(this.host, this.port);
            ftpClient.setSoTimeout(timeout);
            int mode = Utils.parseInt((String)config.get("sorm.ftp.mode"), (int)0);
            if (mode == 1) {
                ftpClient.enterLocalActiveMode();
            } else {
                ftpClient.enterLocalPassiveMode();
            }
            ftpClient.login(this.login, this.password);
            ftpClient.setFileType(2);
        }
        catch (IOException ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 FTP \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c \u0421\u041e\u0420\u041c: " + ex.getMessage() + "\n \u041b\u043e\u0433\u0438\u043d: " + this.login + " \u0425\u043e\u0441\u0442: " + this.host + " \u041f\u043e\u0440\u0442: " + this.port;
            this.getLogger().error(text);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text);
            throw new BGException(text);
        }
        return ftpClient;
    }

    private void startUpload(FTPClient ftpConnect, UploadFiles uploadFiles, Upload versionUpload, Preferences config) throws BGException {
        try {
            List<Path> files = uploadFiles.getFiles();
            for (Path file : files) {
                this.getLogger().info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0430 FTP \u0444\u0430\u0439\u043b\u0430: {}", (Object)file.getFileName());
                ServerUtils.createDirectoriesOnFTP((FTPClient)ftpConnect, (String)this.getRemoteFilePath(uploadFiles, file, versionUpload, config));
                InputStream is = Files.newInputStream(file, new OpenOption[0]);
                try {
                    boolean result = ftpConnect.storeFile(file.getFileName().toString(), is);
                    this.getLogger().debug("\u0424\u0430\u0439\u043b={}, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438 \u043d\u0430 FTP={}", (Object)file, (Object)result);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            ftpConnect.logout();
        }
        catch (IOException ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0444\u0430\u0439\u043b\u043e\u0432 \u043d\u0430 FTP \u0441\u0435\u0440\u0432\u0435\u0440 \u0421\u041e\u0420\u041c";
            this.getLogger().error(text, (Throwable)ex);
            throw new BGException(text);
        }
        finally {
            try {
                if (ftpConnect != null && ftpConnect.isConnected()) {
                    ftpConnect.disconnect();
                }
            }
            catch (IOException ex) {
                this.logError(ex);
            }
        }
    }
}

