/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ClosableTabbedPaneUI;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.common.table.BGTableColumn;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TabbedPaneUI;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.sqleditor.client.QueryInfo;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLHintPopup;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLHistoryList;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLHistoryPanel;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLList;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLListCellRenderer;
import ru.bitel.bgbilling.plugins.sqleditor.client.SQLTextPane;
import ru.bitel.bgbilling.plugins.sqleditor.client.SaveInFileDialog;
import ru.bitel.bgbilling.plugins.sqleditor.client.SaveTemplateDialog;
import ru.bitel.bgbilling.plugins.sqleditor.common.service.SqlEditorService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGTextDialog;
import ru.bitel.common.client.TextHintPopup;
import ru.bitel.common.model.Page;

public class SQLEditor
extends BGTabPanel
implements ActionListener {
    public static final String TAB_ID = "sqlEditor";
    private static final String COMMAND_RUN = "run";
    private static final String COMMAND_MAIL = "mail";
    private static final String COMMAND_SAVE = "save";
    private static final String COMMAND_EDIT = "edit";
    private static final String COMMAND_QUERY = "query";
    private static final String COMMAND_EXECUTE = "execute";
    private static final String COMMAND_EXECUTE_IN_NEW = "executeInNew";
    private static final String COMMAND_SAVE_SQL_TEMPLATE = "saveSQLTemplate";
    private static final String OPTION_PANE_INPUT_DIALOG_TITLE = "OptionPane.inputDialogTitle";
    private ActionListener actionListener;
    private final SQLTextPane textPane = new SQLTextPane();
    private final JTabbedPane resultSetTabbedPane = new JTabbedPane();
    private final JTabbedPane queryTabbedPane = new JTabbedPane();
    private final BGComboBox<ComboBoxItem> databaseList = new BGComboBox();
    private final SQLList inbuidList = new SQLList(this, new ArrayList<String>());
    private final SQLList savedList = new SQLList(this, Arrays.asList("saveButton", "deleteButton"));
    private SQLHistoryPanel sqlHistoryPanel;
    private SQLHistoryList historyList;
    private SQLButton saveButton = null;
    private SqlEditorService sqlEditorService = null;
    private TextHintPopup hintPopup;

    public SQLEditor() {
        super(TAB_ID, "SQL \u043a\u043b\u0438\u0435\u043d\u0442");
        this.module = "sqleditor";
        this.resultSetTabbedPane.setUI((TabbedPaneUI)new ClosableTabbedPaneUI());
        this.savedList.setCellRenderer(new SQLListCellRenderer(){

            @Override
            public String getTitle(QueryInfo value) {
                return value.getTitle() + (value.isAllSee() ? " [\u043e\u0431\u0449\u0438\u0439]" : "");
            }
        });
        try {
            this.initialize();
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void initialize() throws BGException {
        this.textPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.getKeyCode() == 10) {
                    SQLEditor.this.selectResultSetPanel(true);
                } else if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 10) {
                    SQLEditor.this.selectResultSetPanel(false);
                }
            }
        });
        this.actionListener = actionEvent -> {
            String actionCommand = actionEvent.getActionCommand();
            if (COMMAND_SAVE_SQL_TEMPLATE.equals(actionCommand)) {
                this.saveTemplate("", false);
            } else if (COMMAND_EXECUTE.equals(actionCommand)) {
                this.selectResultSetPanel(false);
            } else if (COMMAND_EXECUTE_IN_NEW.equals(actionCommand)) {
                this.selectResultSetPanel(true);
            } else if (COMMAND_MAIL.equals(actionCommand)) {
                String oldTitle = UIManager.getString(OPTION_PANE_INPUT_DIALOG_TITLE);
                UIManager.put(OPTION_PANE_INPUT_DIALOG_TITLE, "\u0412\u0432\u043e\u0434 e-mail \u0430\u0434\u0440\u0435\u0441\u0430");
                String sendEmail = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "E-mail", null);
                UIManager.put(OPTION_PANE_INPUT_DIALOG_TITLE, oldTitle);
                if (sendEmail != null && !sendEmail.isEmpty()) {
                    this.mail(sendEmail);
                }
            } else if (COMMAND_SAVE.equals(actionCommand)) {
                new SaveInFileDialog(this).setVisible(true);
            } else if (COMMAND_QUERY.equals(actionCommand)) {
                ResultSetPanel resultSetPanel = (ResultSetPanel)this.resultSetTabbedPane.getSelectedComponent();
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), resultSetPanel.currentSql);
            } else if (COMMAND_EDIT.equals(actionCommand)) {
                ResultSetPanel resultSetPanel = (ResultSetPanel)this.resultSetTabbedPane.getSelectedComponent();
                this.addQueryToEditor(resultSetPanel.currentSql);
                this.selectectQueryTab();
            } else if (COMMAND_RUN.equals(actionCommand)) {
                this.execute(false);
            }
        };
        this.historyList = new SQLHistoryList(this, Arrays.asList("deleteHistoryButton"));
        this.sqlHistoryPanel = new SQLHistoryPanel(this.getContext(), this.historyList);
        this.queryTabbedPane.add("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430", this.getQueryPanel());
        this.queryTabbedPane.add("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432", this.sqlHistoryPanel);
        this.queryTabbedPane.add("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u044b", this.getListPanel(this.savedList));
        this.queryTabbedPane.add("\u0412\u0441\u0442\u0440\u043e\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u044b", this.getListPanel(this.inbuidList));
        this.queryTabbedPane.addChangeListener(e -> {
            int index = this.queryTabbedPane.getSelectedIndex();
            this.saveButton.setEnabled(index == 0);
        });
        SQLButton runButton = new SQLButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c", COMMAND_EXECUTE, this.actionListener);
        SQLButton runInNewButton = new SQLButton("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0432 \u043d\u043e\u0432\u043e\u0439 \u0432\u043a\u043b\u0430\u0434\u043a\u0435", COMMAND_EXECUTE_IN_NEW, this.actionListener);
        this.saveButton = new SQLButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", COMMAND_SAVE_SQL_TEMPLATE, this.actionListener);
        int gridx = 0;
        JPanel sqlTopPanel = new JPanel(new GridBagLayout());
        sqlTopPanel.add((Component)((Object)runButton), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        sqlTopPanel.add((Component)((Object)runInNewButton), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        sqlTopPanel.add((Component)((Object)this.saveButton), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        sqlTopPanel.add((Component)new JLabel("\u0411\u0430\u0437\u0430:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 15, 0, 5), 0, 0));
        sqlTopPanel.add((Component)this.databaseList, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        JPanel sqlPanel = new JPanel(new GridBagLayout());
        sqlPanel.setBorder((Border)new BGTitleBorder(" SQL "));
        sqlPanel.setMinimumSize(new Dimension(0, 200));
        sqlPanel.setPreferredSize(new Dimension(0, 250));
        sqlPanel.add((Component)sqlTopPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        sqlPanel.add((Component)this.queryTabbedPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(0, (Component)sqlPanel, (Component)this.resultSetTabbedPane, 200L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.listSQLTemplate();
        this.loadBaselist();
        this.listInBuild();
        this.hintPopup = new SQLHintPopup(this.textPane, this.getSqlEditorService());
        this.textPane.getDocument().addDocumentListener((DocumentListener)this.hintPopup);
    }

    protected SqlEditorService getSqlEditorService() {
        if (this.sqlEditorService == null) {
            this.sqlEditorService = (SqlEditorService)this.getContext().getPort(SqlEditorService.class);
        }
        return this.sqlEditorService;
    }

    public void setData() {
        this.sqlHistoryPanel.reloadList();
    }

    void saveTemplate(String title, boolean allSee) {
        SaveTemplateDialog dialog = new SaveTemplateDialog(this);
        dialog.setTemplateTitle(title);
        dialog.setAllSee(allSee);
        dialog.setVisible(true);
    }

    private void listInBuild() {
        DefaultListModel<QueryInfo> listModel = this.inbuidList.getListModel();
        listModel.addElement(new QueryInfo("\u0421\u043f\u0438\u0441\u043e\u043a \u0442\u0430\u0431\u043b\u0438\u0446", "SHOW TABLES"));
        listModel.addElement(new QueryInfo("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0432\u0441\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u044b", "SHOW PROCESSLIST"));
        listModel.addElement(new QueryInfo("\u0420\u0430\u0437\u043c\u0435\u0440 \u0442\u0430\u0431\u043b\u0438\u0446 \u0432 \u041c\u0431", "SELECT table_name AS `Table`, ROUND((data_length + index_length) / 1024 / 1024, 2) `Size in MB` FROM information_schema.TABLES WHERE table_schema = \"bgbilling\" ORDER BY `Size in MB` DESC, table_name ASC"));
    }

    private JPanel getQueryPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.textPane), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel("* Ctrl+Enter - \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441, Ctrl+Shift+Enter - \u0432\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u043d\u043e\u0432\u043e\u0439 \u0432\u043a\u043b\u0430\u0434\u043a\u0435, \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0435\u043a\u0441\u0442\u0430 \u043a\u0430\u043a \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getListPanel(JList<QueryInfo> list) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel(""), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 5, 5, 5), 0, 0));
        return panel;
    }

    protected void selectResultSetPanel(boolean inNew) {
        List<SQLList> list;
        QueryInfo queryInfo;
        String query = "";
        int index = this.queryTabbedPane.getSelectedIndex();
        if (index == 0) {
            query = this.textPane.getSelectedText();
            query = query == null || query.isEmpty() ? this.textPane.getText() : query;
        } else if (index > 0 && (queryInfo = (QueryInfo)(list = Arrays.asList(this.historyList, this.savedList, this.inbuidList)).get(index - 1).getSelectedValue()) != null) {
            query = queryInfo.getQuery();
        }
        if (!query.isEmpty()) {
            this.selectResultSetPanel(inNew, query);
        }
    }

    void selectResultSetPanel(boolean inNew, String query) {
        ResultSetPanel resultSetPanel = (ResultSetPanel)this.resultSetTabbedPane.getSelectedComponent();
        if (resultSetPanel == null || inNew) {
            resultSetPanel = new ResultSetPanel();
            resultSetPanel.title = "ResultSet " + (this.resultSetTabbedPane.getTabCount() + 1);
            this.resultSetTabbedPane.add(resultSetPanel.title, resultSetPanel);
            this.resultSetTabbedPane.setSelectedIndex(this.resultSetTabbedPane.getTabCount() - 1);
        }
        resultSetPanel.currentSql = query;
        resultSetPanel.pagePanel.init();
        this.execute(true);
    }

    public void execute(boolean isNewExecute) {
        this.hintPopup.hidePopup();
        ResultSetPanel resultSetPanel = (ResultSetPanel)this.resultSetTabbedPane.getSelectedComponent();
        try {
            JSONObject table = new JSONObject(this.getSqlEditorService().doQuery(ClientUtils.getIdFromComboBox(this.databaseList), resultSetPanel.currentSql, resultSetPanel.pagePanel.getPage(), null));
            if (table.optString("Error", null) == null) {
                resultSetPanel.table.updateData(table);
                JSONObject page = table.optJSONObject("page");
                if (page != null) {
                    resultSetPanel.pagePanel.setPageInfo(page);
                    resultSetPanel.records.setText(String.valueOf(page.optInt("recordCount", 0)));
                }
                if (isNewExecute) {
                    this.historyList.addHistoryEntry(new QueryInfo(QueryInfo.DATE_FORMAT.format(new Date()), resultSetPanel.currentSql));
                }
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    private void mail(String email) {
        ResultSetPanel resultSetPanel = (ResultSetPanel)this.resultSetTabbedPane.getSelectedComponent();
        if (resultSetPanel.currentSql != null && Utils.notBlankString((String)email)) {
            String sql = resultSetPanel.currentSql.toLowerCase().trim();
            if (sql.startsWith("select") || sql.startsWith("show")) {
                try {
                    this.getSqlEditorService().doQuery(ClientUtils.getIdFromComboBox(this.databaseList), resultSetPanel.currentSql, new Page(0, 0), email);
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0438\u0441\u044c\u043c\u043e \u0431\u044b\u043b\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            } else {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041c\u043e\u0436\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b select \u0438 show* \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 2);
            }
        } else {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u0447\u0435\u0433\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0442\u044c \u0438\u043b\u0438 \u043d\u0435 \u0432\u0432\u0435\u0434\u0451\u043d \u0430\u0434\u0440\u0435\u0441!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 2);
        }
    }

    protected void listSQLTemplate() {
        try {
            JSONArray list = new JSONArray(this.getSqlEditorService().templateList());
            DefaultListModel<QueryInfo> listModel = this.savedList.getListModel();
            listModel.clear();
            for (int index = 0; index < list.length(); ++index) {
                JSONObject queryInfo = list.getJSONObject(index);
                listModel.addElement(new QueryInfo(queryInfo.optString("id"), queryInfo.optString("title"), queryInfo.optString(COMMAND_QUERY), queryInfo.optBoolean("allSee")));
            }
        }
        catch (JSONException | BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    void deleteSQLTemplate(String id) {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0448\u0430\u0431\u043b\u043e\u043d?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            try {
                this.getSqlEditorService().templateDelete(Utils.parseInt((String)id));
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0428\u0430\u0431\u043b\u043e\u043d \u0443\u0434\u0430\u043b\u0435\u043d!", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                this.listSQLTemplate();
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    private void loadBaselist() {
        try {
            JSONArray list = new JSONArray(this.getSqlEditorService().databaseList());
            DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
            for (int index = 0; index < list.length(); ++index) {
                JSONObject databaseInfo = list.getJSONObject(index);
                model.addElement(new ComboBoxItem((Object)databaseInfo.optString("id"), databaseInfo.optString("title")));
            }
            this.databaseList.setModel(model);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    void selectectQueryTab() {
        this.queryTabbedPane.setSelectedIndex(0);
    }

    void addQueryToEditor(String queryText) {
        String queries;
        this.textPane.setText(queries + ((queries = this.textPane.getText()).isEmpty() ? "" : "\n") + queryText);
    }

    BGComboBox<ComboBoxItem> getDatabaseList() {
        return this.databaseList;
    }

    JTabbedPane getResultSetTabbedPane() {
        return this.resultSetTabbedPane;
    }

    SQLTextPane getQuery() {
        return this.textPane;
    }

    protected SQLHistoryPanel getSQLHistoryPanel() {
        return this.sqlHistoryPanel;
    }

    class SQLButton
    extends BGButton {
        public SQLButton(String text, String actionCommand, ActionListener actionListener) {
            super(text, actionCommand);
            this.addActionListener(actionListener);
        }
    }

    class ResultSetPanel
    extends JPanel {
        private String currentSql = null;
        private String title = "-";
        private BGSQLTable table = new BGSQLTable();
        private JLabel records = new JLabel("0");
        private BGControlPanelPages pagePanel = new BGControlPanelPages();

        public ResultSetPanel() {
            this.pagePanel.init();
            this.pagePanel.addToHandler(a -> SQLEditor.this.execute(false));
            ClientUtils.addOpenAction((Component)((Object)this.table), e -> this.showResultsetCell());
            int gridy = 0;
            this.setLayout(new GridBagLayout());
            this.add((Component)this.getResultSetTopPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)new JScrollPane((Component)((Object)this.table)), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }

        private JPanel getResultSetTopPanel() {
            int gridx = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)((Object)new SQLButton("Run", SQLEditor.COMMAND_RUN, SQLEditor.this.actionListener)), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)((Object)new SQLButton("SQL", SQLEditor.COMMAND_QUERY, SQLEditor.this.actionListener)), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)((Object)new SQLButton("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", SQLEditor.COMMAND_EDIT, SQLEditor.this.actionListener)), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
            panel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)((Object)new SQLButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432 \u0444\u0430\u0439\u043b", SQLEditor.COMMAND_SAVE, SQLEditor.this.actionListener)), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 15), 0, 0));
            panel.add((Component)((Object)new SQLButton("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043d\u0430 e-mail", SQLEditor.COMMAND_MAIL, SQLEditor.this.actionListener)), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 15), 0, 0));
            panel.add((Component)new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.records, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 10), 0, 0));
            panel.add((Component)this.pagePanel, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            return panel;
        }

        private void showResultsetCell() {
            int col = this.table.getSelectedColumn();
            int row = this.table.getSelectedRow();
            String colName = ((BGTableColumn)this.table.getColumns().get(col)).getTitle();
            Object cellVal = this.table.getModel().getValueAt(row, col);
            if (colName.equals("cid") || colName.equals("contractId") || colName.equals("contract_id")) {
                ClientUtils.openContract((int)Utils.parseInt((String)cellVal.toString()));
            } else {
                BGTextDialog dialog = new BGTextDialog();
                dialog.getTextArea().setText(cellVal.toString());
                dialog.setModal(true);
                dialog.setVisible(true);
            }
        }

        protected String getCurrentSql() {
            return this.currentSql;
        }
    }

    public class BGSQLTable
    extends BGTable {
        public BGSQLTable() {
            this.setNewTableModel();
        }

        public void updateData(JSONObject table) {
            this.parseColumns(table.optJSONArray("columns"));
            this.removeRows();
            JSONArray rows = table.optJSONArray("rows");
            if (this.tableModel == null || rows == null || rows.isEmpty()) {
                return;
            }
            for (int i = 0; i < rows.length(); ++i) {
                JSONObject row = rows.optJSONObject(i);
                int columnCount = this.columns.size();
                Vector<Object> rowData = new Vector<Object>();
                for (int k = 0; k < columnCount; ++k) {
                    BGTableColumn column = (BGTableColumn)this.columns.get(k);
                    String id = String.valueOf(column.getId());
                    String value = row.optString(id);
                    rowData.addElement(column.getValue(value));
                }
                this.tableModel.addRow(rowData);
                if (this.spannedRowModel != this.tableModel || "".equals(row.optString("colspan"))) continue;
                this.spannedRowModel.setSpannedRow(this.tableModel.getRowCount() - 1);
            }
            this.columnWidthsByTableWidth();
        }

        private void parseColumns(JSONArray array) {
            int i;
            this.columns.clear();
            if (array == null) {
                return;
            }
            for (i = 0; i < array.length(); ++i) {
                String title = array.optString(i);
                String name = "c" + i;
                int[] widths = new int[]{-1, -1, -1};
                this.columns.add(BGTableColumn.getInstance((String)name, (String)title, (int[])widths, (boolean)false, null));
            }
            this.tableModel.setColumnCount(this.columns.size());
            for (i = 0; i < this.columns.size(); ++i) {
                BGTableColumn tc = (BGTableColumn)this.columns.get(i);
                this.setColumnProperties(i, tc.getTitle(), tc.getColumnWidth(0), tc.getColumnWidth(1), tc.getColumnWidth(2));
            }
            this.resizeAndRepaint();
        }
    }
}

