/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.ReferenceValueDirectory;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ServiceSpecRuntimeMap;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecServiceLink;
import ru.bitel.oss.systems.inventory.product.common.event.ServiceLinkModifiedEvent;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecServiceLinkDao;

public class ProductSpecRuntimeMap
extends ReferenceValueDirectory<ProductSpec, ProductSpecRuntime>
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private static ProductSpecRuntimeMap instance;
    private volatile Map<Integer, ProductSpecRuntime.ServiceLinkRuntimeList> linkMap;

    private ProductSpecRuntimeMap(boolean realtime, Connection con) throws Exception {
        super(realtime, con, 0, ProductSpec.class);
        ServiceSpecRuntimeMap.getInstance(con);
        this.init(con, 0, ProductSpec.class);
        if (realtime) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        EventProcessor.getInstance().addListener((EventListener)ProductSpecRuntimeMap.this, ServiceLinkModifiedEvent.class);
                    }
                    catch (BGException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }.start();
        }
    }

    public static ProductSpecRuntimeMap getInstance(ConnectionSet connectionSet) throws Exception {
        if (instance == null) {
            instance = new ProductSpecRuntimeMap(true, connectionSet.getConnection());
        }
        return instance;
    }

    protected ProductSpecRuntime newValue(ProductSpec value) {
        ProductSpecRuntime.ServiceLinkRuntimeList list = this.linkMap.get(value.getId());
        return new ProductSpecRuntime(value, list);
    }

    protected void onUpdate(Connection con, int moduleId, List<ProductSpec> list) throws Exception {
        HashMap<Integer, ProductSpecRuntime.ServiceLinkRuntimeList> linkMap = new HashMap<Integer, ProductSpecRuntime.ServiceLinkRuntimeList>();
        ProductSpecServiceLinkDao serviceLinkDao = new ProductSpecServiceLinkDao(con, 0);
        GregorianCalendar utilCalendar = new GregorianCalendar();
        for (ProductSpec productSpec : list) {
            List serviceLinkList = serviceLinkDao.list(productSpec.getId(), null);
            ArrayList<ProductSpecRuntime.ServiceLinkRuntime> linkList = new ArrayList<ProductSpecRuntime.ServiceLinkRuntime>();
            if (serviceLinkList != null) {
                ServiceSpecRuntimeMap serviceSpecRuntimeMap = ServiceSpecRuntimeMap.getInstance(con);
                for (ProductSpecServiceLink serviceLink : serviceLinkList) {
                    ServiceSpecRuntime serviceSpecRuntime = (ServiceSpecRuntime)serviceSpecRuntimeMap.get(serviceLink.getServiceSpecId());
                    if (serviceSpecRuntime == null) continue;
                    ProductSpecRuntime.ServiceLinkRuntime link = new ProductSpecRuntime.ServiceLinkRuntime(serviceSpecRuntime, serviceLink.getServiceSpecId(), TvUtils.dateFrom(serviceLink.getDateFrom(), utilCalendar), TvUtils.dateFrom(serviceLink.getDateTo(), utilCalendar));
                    linkList.add(link);
                }
            }
            ProductSpecRuntime.ServiceLinkRuntimeList runtimeList = new ProductSpecRuntime.ServiceLinkRuntimeList(linkList);
            linkMap.put(productSpec.getId(), runtimeList);
        }
        this.linkMap = linkMap;
    }

    public void notify(Event e, EventListenerContext ctx) throws Exception {
        this.init(ctx.getConnection(), 0, ProductSpec.class);
    }
}

