/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.util.Set;
import java.util.function.Predicate;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.ProductManager;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;

public class ProductSpecFilterTariffTreeNode
extends ru.bitel.oss.systems.inventory.product.server.tariff.ProductSpecFilterTariffTreeNode {
    public ProductSpecFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
    }

    protected Set<Integer> getActiveProductSpecIds(AbstractTariffRequest<?> req) {
        long time = req.getTime().getTimeInMillis();
        return req.getActiveProductSpecIds(time, this.getPredicate((TvTariffRequest)req));
    }

    private Predicate<ProductPeriodRuntimeList.ProductPeriodItem> getPredicate(TvTariffRequest req) {
        if (req.serviceCost == null) {
            return null;
        }
        ProductManager.Entry productItem = ((TvServiceCost)req.serviceCost).getProductItem();
        if (productItem == null) {
            return null;
        }
        return p -> {
            if (p.productId == productItem.productId) {
                return false;
            }
            if (p.productSpecId != productItem.productSpecId) {
                return true;
            }
            if (p.timeFrom < productItem.productPeriodTimeFrom.getTime()) {
                return true;
            }
            return p.productId < productItem.productId;
        };
    }
}

