/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.ProcessLogTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.voice.common.bean.DataProcessRecord;
import ru.bitel.bgbilling.modules.voice.server.bean.DataProccessRecordDao;
import ru.bitel.bgbilling.modules.voice.server.event.RequestLogInfoEvent;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperatorRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntimeMap;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.jmx.MBeanOperation;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.PeriodicalTaskRunner;
import ru.bitel.common.worker.ThreadContext;

public class LogRecordProcessor
extends PeriodicalTaskRunner<ProcessLogTask>
implements EventListener<RequestLogInfoEvent>,
Lifecycle {
    protected final int moduleId;
    private VoiceAccountRuntimeMap accountRuntimeMap = null;
    private VoiceOperAccountRuntimeMap operAccountRuntimeMap = null;
    private final VoiceApplication application;

    @ConstructorProperties(value={"app", "initialDelay", "delay"})
    public LogRecordProcessor(VoiceApplication application, long initialDelay, long delay) {
        super(application.getSetup(), 1, initialDelay, delay, application.getModuleId(), "recordProcessor");
        this.moduleId = application.getModuleId();
        this.application = application;
        try {
            EventProcessor.getInstance().addListener((EventListener)this, RequestLogInfoEvent.class, this.moduleId, null);
        }
        catch (BGException ex) {
            this.logError(ex);
        }
    }

    protected List<ProcessLogTask> readTasks() throws BGException {
        ArrayList<ProcessLogTask> result = new ArrayList<ProcessLogTask>();
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
             DataProccessRecordDao dataProccessRecordDao = new DataProccessRecordDao(connectionSet.getConnection(), this.moduleId);){
            for (DataProcessRecord record : dataProccessRecordDao.list(false)) {
                result.add(new ProcessLogTask(this, record, this.setup, this.moduleId));
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ServerContext context = null;
        try {
            Setup setup = new Setup("data", "data");
            int moduleId = 217;
            context = new ServerContext(setup, moduleId, 0);
            ServerContext.set((ThreadContext)context);
            VoiceApplication application = new VoiceApplication(setup, false);
            new LogRecordProcessor(application, 10L, 20L).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            context.recycle();
        }
    }

    @MBeanOperation
    public void start() {
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
            this.accountRuntimeMap = VoiceAccountRuntimeMap.getInstance(connectionSet, this.application);
            this.operAccountRuntimeMap = VoiceOperAccountRuntimeMap.getInstance(connectionSet, this.application);
            super.start();
        }
        catch (Exception ex) {
            this.logError("error while starting ", ex);
        }
    }

    public void notify(RequestLogInfoEvent event, EventListenerContext ctx) throws BGException {
        try {
            VoiceDeviceRuntime deviceRuntime = this.application.getDeviceRuntimeMap().get(event.getDeviceId());
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("deviceRuntime = " + String.valueOf((Object)deviceRuntime));
            }
            if (deviceRuntime != null && deviceRuntime.getMediatorInstance() != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("deviceRuntime.getMediatorInstance() = " + String.valueOf(deviceRuntime.getMediatorInstance()));
                }
                int[] exists = new int[31];
                deviceRuntime.getMediatorInstance().getLogExists(event.getMonth(), exists);
                event.addLogs(exists);
            }
        }
        catch (Exception ex) {
            this.logError("error while recieving message", ex);
        }
    }

    public synchronized VoiceAccountRuntimeMap getAccountRuntimeMap(Date day) {
        block8: {
            try {
                if (!TimeUtils.dateBefore((Date)day, (Date)this.accountRuntimeMap.getDateFrom())) break block8;
                try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
                    this.accountRuntimeMap.load(connectionSet.getConnection(), day);
                }
            }
            catch (Exception ex) {
                this.logError("error while getting accountRuntimeMap", ex);
            }
        }
        return this.accountRuntimeMap;
    }

    public synchronized VoiceOperAccountRuntimeMap getOperAccountRuntimeMap(Date day) {
        block8: {
            try {
                if (!TimeUtils.dateBefore((Date)day, (Date)this.operAccountRuntimeMap.getDateFrom())) break block8;
                try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);){
                    this.setup.set("moduleId", String.valueOf(this.moduleId));
                    this.operAccountRuntimeMap.load(connectionSet.getConnection(), day);
                }
            }
            catch (Exception ex) {
                this.logError("error while getting accountRuntimeMap", ex);
            }
        }
        return this.operAccountRuntimeMap;
    }

    @MBeanOperation
    public void stop() throws Exception {
    }

    public VoiceDeviceRuntimeMap getDeviceRuntimeMap() {
        return this.application.getDeviceRuntimeMap();
    }

    public VoiceOperatorRuntimeMap getOperatorRuntimeMap() {
        return this.application.getOperatorRuntimeMap();
    }
}

