/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.event.worker;

import java.util.Optional;
import org.slf4j.MDC;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.yoomoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.yoomoney.server.event.YoomoneyCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class YoomoneyCheckEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;

    public YoomoneyCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), YoomoneyCheckEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        this.getLogger().info("Starting YoomoneyCheckEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "yoomoney-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        return this.doTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTask(Object task) throws BGException {
        YoomoneyCheckEvent event = (YoomoneyCheckEvent)((Object)task);
        MDC.put((String)"module", (String)"yoomoney");
        MDC.put((String)"moduleId", (String)String.valueOf(this.moduleId));
        MDC.put((String)"contractId", (String)String.valueOf(event.getContractId()));
        Optional.ofNullable(event.getObjectId()).ifPresent(a -> MDC.put((String)"objectId", (String)a));
        try {
            this.transactionManager.doCheckRequest(event.getObjectId());
            Object var3_3 = null;
            return var3_3;
        }
        finally {
            MDC.remove((String)"module");
            MDC.remove((String)"moduleId");
            MDC.remove((String)"contractId");
            MDC.remove((String)"objectId");
        }
    }
}

