/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server;

import bitel.billing.server.MaxTrafficCalculator;
import bitel.billing.server.ModuleBase;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ModuleEntity;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.CommonEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ObjectMoveEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountState;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountStatus;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountTypeDao;
import ru.bitel.bgbilling.modules.voice.server.event.om.OmVoiceAccountStateModifyEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.XMLDatabaseSerializer;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Period;

public class Module
extends ModuleBase
implements EventListener<Event> {
    private boolean contractStatusChangedEventInit = false;
    private static final String[] PACKAGES = new String[]{Module.class.getPackage().getName()};

    public void start(Connection con, BGModule module) throws BGException {
        try {
            EventProcessor eventProcessor = EventProcessor.getInstance();
            if (!this.contractStatusChangedEventInit) {
                eventProcessor.addListener((EventListener)this, ContractStatusChangedEvent.class);
                this.contractStatusChangedEventInit = true;
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void notify(Event event, EventListenerContext eventListenerContext) throws BGException {
        if (event instanceof ContractStatusChangedEvent) {
            ContractStatusChangedEvent changedEvent = (ContractStatusChangedEvent)event;
            LocalDate now = LocalDate.now();
            LocalDate statusFrom = TimeUtils.convertDateToLocalDate((Date)changedEvent.getStatus().getDateFrom());
            if (statusFrom.compareTo(now) != 0) {
                return;
            }
            int contractId = changedEvent.getContractId();
            if (contractId > 0) {
                ModuleCache moduleCache = ModuleCache.getInstance();
                Connection con = eventListenerContext.getConnection();
                try {
                    for (BGModule bgModule : moduleCache.getModulesList("voice")) {
                        int moduleId = bgModule.getId();
                        HashMap<Integer, VoiceAccountType> typeMap = new HashMap<Integer, VoiceAccountType>();
                        try (VoiceAccountDao voiceAccountDao = new VoiceAccountDao(con, moduleId);
                             VoiceAccountTypeDao voiceAccountTypeDao = new VoiceAccountTypeDao(con, moduleId);){
                            EventProcessor eventProcessor = EventProcessor.getInstance();
                            ContractStatusService contractStatusService = (ContractStatusService)eventListenerContext.getService(ContractStatusService.class, 0);
                            VoiceAccountService voiceAccountService = (VoiceAccountService)eventListenerContext.getService(VoiceAccountService.class, moduleId);
                            block13: for (VoiceAccount voiceAccount : voiceAccountDao.list(contractId)) {
                                JSONArray rules;
                                JSONObject config;
                                String statusConfig;
                                if (!TimeUtils.dateInPeriod((LocalDate)now, (Period)new Period(voiceAccount.getDateFrom(), voiceAccount.getDateTo()))) continue;
                                int typeId = voiceAccount.getTypeId();
                                VoiceAccountType voiceAccountType = (VoiceAccountType)typeMap.get(typeId);
                                if (voiceAccountType == null) {
                                    voiceAccountType = (VoiceAccountType)voiceAccountTypeDao.get(typeId);
                                    typeMap.put(typeId, voiceAccountType);
                                }
                                if (voiceAccountType == null || (statusConfig = voiceAccountType.getStatusConfig()) == null || !(config = new JSONObject(statusConfig)).optBoolean("mode") || (rules = config.optJSONArray("rules")) == null) continue;
                                ContractStatus contractStatusNew = changedEvent.getStatus();
                                ContractStatus contractStatusOld = contractStatusService.contractStatusOnDate(contractId, TimeUtils.getPrevDay((Date)contractStatusNew.getDateFrom()));
                                int len = rules.length();
                                for (int i = 0; i < len; ++i) {
                                    int accountStatus;
                                    int to;
                                    JSONObject rule = rules.getJSONObject(i);
                                    int from = rule.optInt("from", -1);
                                    if (contractStatusOld != null && from > -1 && contractStatusOld.getStatus() != from || (to = rule.optInt("to", -1)) > -1 && contractStatusNew.getStatus() != to || (accountStatus = rule.optInt("if", -1)) > -1 && voiceAccount.getStatus().getCode() != accountStatus) continue;
                                    int accountStatusNew = rule.optInt("set");
                                    voiceAccount.setStatus(VoiceAccountStatus.getVoiceAccountStatus((int)accountStatusNew));
                                    voiceAccountService.voiceAccountUpdate(voiceAccount);
                                    if (accountStatusNew > 0 && accountStatusNew < 3) {
                                        if (voiceAccount.getDeviceState() != VoiceAccountState.STATE_ENABLE) continue block13;
                                        eventProcessor.publish((Event)new OmVoiceAccountStateModifyEvent(moduleId, voiceAccount, VoiceAccountState.STATE_DISABLE.getCode()));
                                        continue block13;
                                    }
                                    if (accountStatusNew != 0 || voiceAccount.getDeviceState() != VoiceAccountState.STATE_DISABLE) continue block13;
                                    eventProcessor.publish((Event)new OmVoiceAccountStateModifyEvent(moduleId, voiceAccount, VoiceAccountState.STATE_ENABLE.getCode()));
                                    continue block13;
                                }
                            }
                        }
                    }
                    con.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        if (!(event instanceof ContractCreateEvent)) {
            if (event instanceof ContractDeleteEvent) {
                this.contractDelete(serverContext, moduleId, (ContractDeleteEvent)event);
            } else if (event instanceof ContractCloseEvent) {
                this.contractClose(serverContext, moduleId, (ContractCloseEvent)event);
            } else if (event instanceof ContractWrapEvent) {
                this.notifyContractWrapEvent(serverContext, moduleId, (ContractWrapEvent)event);
            } else if (event instanceof ObjectMoveEvent) {
                // empty if block
            }
        }
    }

    private void contractDelete(ServerContext serverContext, int moduleId, ContractDeleteEvent contractDeleteEvent) throws Exception {
        VoiceAccountService accountService = (VoiceAccountService)serverContext.getService(VoiceAccountService.class, moduleId);
        if (contractDeleteEvent.isCheck()) {
            try {
                List accounts = accountService.voiceAccountList(contractDeleteEvent.getContractId(), 0, null);
                for (VoiceAccount account : accounts) {
                    accountService.checkVoiceAccountIsActive(account);
                }
            }
            catch (Exception ex) {
                contractDeleteEvent.setError(ModuleCache.getInstance().getModule(moduleId).getTitle() + ": " + ex.getMessage());
            }
        } else {
            List accounts = accountService.voiceAccountList(contractDeleteEvent.getContractId(), 0, null);
            for (VoiceAccount account : accounts) {
                accountService.voiceAccountDelete(account.getId());
            }
        }
    }

    private void contractClose(ServerContext serverContext, int moduleId, ContractCloseEvent contractCloseEvent) throws Exception {
        VoiceAccountService accountService = (VoiceAccountService)serverContext.getService(VoiceAccountService.class, moduleId);
        List accounts = accountService.voiceAccountList(contractCloseEvent.getContractId(), 0, null);
        if (contractCloseEvent.isCheck()) {
            for (VoiceAccount ac : accounts) {
                if (ac.getDateTo() == null || TimeUtils.dateBeforeOrEq((Date)ac.getDateTo(), (Date)contractCloseEvent.getDate())) continue;
                contractCloseEvent.setError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430, \u0441\u0435\u0440\u0432\u0438\u0441 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u0443 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043f\u043e\u0437\u0436\u0435 \u0434\u0430\u0442\u044b \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.");
                break;
            }
        } else {
            Date now = new Date();
            for (VoiceAccount ac : accounts) {
                if (ac.getDateTo() != null && !TimeUtils.dateBefore((Date)now, (Date)ac.getDateTo())) continue;
                ac.setDateTo(contractCloseEvent.getDate());
                accountService.voiceAccountUpdate(ac);
            }
        }
    }

    public void lockServiceNow(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.lockService(con, moduleId, contractRuntime, balance, limit, lightweight);
    }

    public void lockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
    }

    public void unlockServiceNow(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
        this.unlockService(con, moduleId, contractRuntime, balance, limit, lightweight);
    }

    public void unlockService(Connection con, int moduleId, ContractRuntime contractRuntime, BigDecimal balance, BigDecimal limit, boolean lightweight) throws BGException {
    }

    public void serializeContract(Connection con, int contractId, int moduleId, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        ArrayList<Integer> accountIds = new ArrayList<Integer>();
        String voiceAccountBaseTable = ServerUtils.getModuleTableName((String)"voice_account_base", (int)moduleId);
        try (PreparedStatement ps = con.prepareStatement("SELECT id, contractId, dateFrom, dateTo, typeId, deviceId, title FROM " + voiceAccountBaseTable + " WHERE contractId=?", 1004, 1007);){
            ps.setInt(1, contractId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                accountIds.add(rs.getInt("id"));
            }
            rs.beforeFirst();
            new XMLDatabaseSerializer(tables).addItemsFromRS(voiceAccountBaseTable, null, null, rs);
        }
        String voiceAccountTable = ServerUtils.getModuleTableName((String)"voice_account", (int)moduleId);
        try (PreparedStatement ps = con.prepareStatement("SELECT id, number, comment, status, login, password, contractObjectId FROM " + voiceAccountTable + " WHERE id IN (?)");){
            ps.setString(1, Utils.toString(accountIds));
            new XMLDatabaseSerializer(tables).addItemsFromRS(voiceAccountTable, null, null, ps.executeQuery());
        }
    }

    public List<ModuleEntity> getObjectEntities(Connection con, int moduleId, int objectId) throws BGException {
        ArrayList<ModuleEntity> result = new ArrayList<ModuleEntity>();
        try (ContractObjectDao objectDao = new ContractObjectDao(con, 0);
             VoiceAccountDao accountDao = new VoiceAccountDao(con, moduleId);){
            ContractObject object = (ContractObject)objectDao.get(objectId);
            for (VoiceAccount voiceAccount : accountDao.list(object.getContractId())) {
                if (voiceAccount.getContractObjectId() != objectId) continue;
                ModuleEntity entity = new ModuleEntity();
                entity.setName("\u0410\u043a\u043a\u0430\u0443\u043d\u0442");
                entity.setData(voiceAccount.getTitle());
                entity.setComment(voiceAccount.getComment());
                entity.setPeriod(TimeUtils.formatPeriod((Date)voiceAccount.getDateFrom(), (Date)voiceAccount.getDateTo()));
                result.add(entity);
            }
        }
        return result;
    }

    private void notifyContractWrapEvent(ServerContext serverContext, int moduleId, ContractWrapEvent contractWrapEvent) throws Exception {
        Connection con = serverContext.getConnection();
        ContractModuleManager contractModuleManager = new ContractModuleManager(con);
        VoiceAccountService voiceAccountService = (VoiceAccountService)serverContext.getService(VoiceAccountService.class, moduleId);
        List voiceAccountList = voiceAccountService.voiceAccountList(contractWrapEvent.getContractId(), 0, null);
        if (contractWrapEvent.isCheck()) {
            voiceAccountList.stream().filter(account -> account.getDateFrom() == null).findFirst().ifPresent(account -> contractWrapEvent.setError("\u041f\u0435\u0440\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e. \u0410\u043a\u043a\u0430\u0443\u043d\u0442 " + String.valueOf(account) + " \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u0434\u0430\u0442\u044b \u043e\u0442\u043a\u0440\u044b\u0442\u0438\u044f."));
        } else {
            String sessionTable;
            TreeSet<GregorianCalendar> monthForBalanceSet = new TreeSet<GregorianCalendar>();
            for (VoiceAccount voiceAccount : voiceAccountList) {
                Date dateTo;
                Integer objectId = contractWrapEvent.getObjectMap().getOrDefault(voiceAccount.getContractObjectId(), 0);
                Date dateFrom = voiceAccount.getDateFrom();
                Date date = dateTo = voiceAccount.getDateTo() == null ? new Date() : voiceAccount.getDateTo();
                if (TimeUtils.dateBefore((Date)contractWrapEvent.getDateClose(), (Date)dateFrom)) {
                    voiceAccount.setContractId(contractWrapEvent.getToContractId());
                    voiceAccount.setContractObjectId(objectId.intValue());
                    voiceAccountService.voiceAccountUpdate(voiceAccount);
                    this.wrapNPayService(serverContext, contractModuleManager, moduleId, contractWrapEvent, voiceAccount.getId(), voiceAccount.getId());
                    Calendar calendar = TimeUtils.convertDateToCalendar((Date)dateTo);
                    while (TimeUtils.monthsDelta((Date)calendar.getTime(), (Date)dateTo) >= 0) {
                        sessionTable = ServerUtils.getModuleMonthTableName((String)"voice_session_log", (Date)calendar.getTime(), (int)moduleId);
                        if (ServerUtils.tableExists((Connection)con, (String)sessionTable)) {
                            String query = "UPDATE " + sessionTable + " SET contractId=? WHERE accountId=?";
                            try (PreparedStatement psUpdate = con.prepareStatement(query);){
                                psUpdate.setInt(1, contractWrapEvent.getToContractId());
                                psUpdate.setInt(2, voiceAccount.getId());
                                psUpdate.executeUpdate();
                            }
                        }
                        calendar.add(2, 1);
                    }
                    continue;
                }
                if (!contractWrapEvent.checkNeedWrap(dateTo)) continue;
                int n = voiceAccount.getId();
                Date oldDateTo = voiceAccount.getDateTo();
                voiceAccount.setDateTo(contractWrapEvent.getDateClose());
                voiceAccountService.voiceAccountUpdate(voiceAccount);
                voiceAccount.setDateFrom(contractWrapEvent.getDateOpen());
                voiceAccount.setDateTo(oldDateTo);
                voiceAccount.setContractId(contractWrapEvent.getToContractId());
                voiceAccount.setContractObjectId(objectId.intValue());
                voiceAccount.setId(-1);
                int newAccountId = voiceAccountService.voiceAccountUpdate(voiceAccount);
                contractWrapEvent.relinkEntry(con, "contract_tariff", moduleId, n, newAccountId);
                contractWrapEvent.relinkEntry(con, "contract_service", moduleId, n, newAccountId);
                this.wrapNPayService(serverContext, contractModuleManager, moduleId, contractWrapEvent, n, newAccountId);
                Calendar dateMonth = TimeUtils.convertDateToCalendar((Date)contractWrapEvent.getDateOpen());
                while (TimeUtils.monthsDelta((Date)dateMonth.getTime(), (Date)dateTo) >= 0) {
                    String sessionTable2 = ServerUtils.getModuleMonthTableName((String)"voice_session_log", (Date)dateMonth.getTime(), (int)moduleId);
                    if (ServerUtils.tableExists((Connection)con, (String)sessionTable2)) {
                        try (PreparedStatement psUpdateSession = con.prepareStatement("UPDATE " + sessionTable2 + " SET contractId=?, accountId=? WHERE accountId=? AND ?<=sessionStart");){
                            psUpdateSession.setInt(1, contractWrapEvent.getToContractId());
                            psUpdateSession.setInt(2, newAccountId);
                            psUpdateSession.setInt(3, n);
                            psUpdateSession.setDate(4, TimeUtils.convertDateToSqlDate((Date)contractWrapEvent.getDateOpen()));
                            psUpdateSession.executeUpdate();
                            monthForBalanceSet.add(new GregorianCalendar(dateMonth.get(1), dateMonth.get(2), 1));
                        }
                    }
                    dateMonth.add(2, 1);
                }
                contractWrapEvent.addToEntityMap(moduleId, n, newAccountId);
            }
            String sids = MaxTrafficCalculator.getModuleServicesWithoutMaxTraf((Connection)con, (int)moduleId, (Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)));
            String query = "DELETE FROM contract_account WHERE cid IN (" + contractWrapEvent.getContractId() + ", " + contractWrapEvent.getToContractId() + ") AND yy=? AND mm=? AND sid IN ( " + sids + ")";
            try (PreparedStatement psDeleteAccount = con.prepareStatement(query);
                 BalanceUtils balanceUtils = new BalanceUtils(con);){
                for (Calendar calendar : monthForBalanceSet) {
                    psDeleteAccount.setInt(1, calendar.get(1));
                    psDeleteAccount.setInt(2, calendar.get(2) + 1);
                    psDeleteAccount.executeUpdate();
                    sessionTable = ServerUtils.getModuleMonthTableName((String)"voice_session_log", (Date)calendar.getTime(), (int)moduleId);
                    if (!ServerUtils.tableExists((Connection)con, (String)sessionTable)) continue;
                    query = "SELECT contractId, serviceId, SUM(sessionCost) AS sessionCost FROM " + sessionTable + " WHERE contractId IN (" + contractWrapEvent.getContractId() + "," + contractWrapEvent.getToContractId() + ") GROUP BY contractId, serviceId";
                    PreparedStatement psSelectAccount = con.prepareStatement(query);
                    try {
                        ResultSet rs = psSelectAccount.executeQuery();
                        try {
                            while (rs.next()) {
                                balanceUtils.setContractAccount(rs.getInt("contractId"), TimeUtils.convertDateToLocalDate((Date)calendar.getTime()), rs.getInt("serviceId"), rs.getBigDecimal("sessionCost"));
                            }
                            balanceUtils.setBalanceFromAccount(contractWrapEvent.getContractId(), calendar);
                            balanceUtils.setBalanceFromAccount(contractWrapEvent.getToContractId(), calendar);
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (psSelectAccount == null) continue;
                        psSelectAccount.close();
                    }
                }
            }
        }
    }

    private void wrapNPayService(ServerContext serverContext, ContractModuleManager contractModuleManager, int moduleId, ContractWrapEvent event, int accountId, int newAccountId) throws Exception {
        Set<Integer> nPayModuleIds = this.getNPayModuleIds(serverContext, contractModuleManager.getContractModuleSet(event.getContractId()), event.getContractId());
        for (Integer nPayModuleId : nPayModuleIds) {
            CommonEvent commonEvent = new CommonEvent(event.getContractId(), nPayModuleId.intValue());
            commonEvent.setParameter("phone_abon", (Object)"true");
            commonEvent.setParameter("cidNew", (Object)event.getToContractId());
            commonEvent.setParameter("entityMid", (Object)moduleId);
            commonEvent.setParameter("entityIdOld", (Object)accountId);
            commonEvent.setParameter("entityIdNew", (Object)newAccountId);
            commonEvent.setParameter("dateOpen", (Object)event.getDateOpen());
            commonEvent.setParameter("dateClose", (Object)event.getDateClose());
            EventProcessor.getInstance().request((QueueEvent)commonEvent);
        }
    }

    private Set<Integer> getNPayModuleIds(ServerContext serverContext, Set<Integer> contractModuleSet, int contractId) throws Exception {
        return ((ModuleService)serverContext.getService(ModuleService.class, 0)).moduleList().stream().filter(bgModule -> bgModule.getInstalledModule().getName().equals("npay") && contractModuleSet.contains(bgModule.getId())).map(Id::getId).collect(Collectors.toSet());
    }
}

