/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.BotConfigurePanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.DialogComboBoxFilter;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.DialogElementConfigurePanel;
import ru.bitel.bgbilling.modules.botmanager.client.botconfigure.ElementEditorPanel;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElement;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialogElementType;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.model.GuiTitlable;

public class DialogElementEditor
extends JPanel
implements ItemListener {
    private ElementEditorPanel elementEditor;
    private DialogComboBoxFilter<GuiTitlable> typeElementFilter;
    private BotConfigurePanel parentPanel;
    private DialogElementConfigurePanel dialogElementConfigurePanel;

    protected DialogElementEditor(BotConfigurePanel parentPanel, DialogElementConfigurePanel dialogElementConfigurePanel) {
        this.parentPanel = parentPanel;
        this.dialogElementConfigurePanel = dialogElementConfigurePanel;
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
        BGSwingUtilites.wrapBorder((JPanel)this, (String)"\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u0430");
        Dimension dimension = new Dimension(600, 300);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.elementEditor = new ElementEditorPanel.EmptyElementEditor(parentPanel.getBotManagerService());
        this.typeElementFilter = new DialogComboBoxFilter.DialogElementComboBoxFilter(this);
        this.add((Component)((Object)this.typeElementFilter), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0));
        this.add((Component)this.elementEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 0, 0), 0, 0));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        BotDialogElementType selectedElementType = BotDialogElementType.getElementType((String)this.typeElementFilter.getSelectedItem().getGuiTitle());
        if (e.getStateChange() == 1) {
            this.showElementEditor(selectedElementType);
        }
    }

    void openEditor(BotDialogElement element) {
        BotDialogElement currentElement = element;
        if (element != null) {
            this.typeElementFilter.setSelectedItem(element.getElementType());
            this.showElementEditor(element.getElementType());
            this.elementEditor.setElementToPanel(element);
        } else {
            this.typeElementFilter.setSelectedIndex(0);
            this.showElementEditor(null);
        }
        this.setVisible(true);
        int optionId = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), this, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", 2);
        if (optionId == 0) {
            BotDialogElementType selectedElementType;
            if (currentElement == null) {
                currentElement = new BotDialogElement();
            }
            if ((selectedElementType = BotDialogElementType.getElementType((String)this.typeElementFilter.getSelectedItem().getGuiTitle())) == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430");
                return;
            }
            currentElement.setElementType(selectedElementType);
            try {
                if (selectedElementType.equals((Object)BotDialogElementType.ATTACHMENT)) {
                    int id = this.parentPanel.getBotManagerService().updateDialogElement(currentElement);
                    currentElement.setId(id);
                }
                this.elementEditor.insertDataOfPanelToElement(currentElement);
                this.parentPanel.getBotManagerService().updateDialogElement(currentElement);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.dialogElementConfigurePanel.performAction("refresh");
            this.setVisible(false);
        }
    }

    void showElementEditor(BotDialogElementType elementType) {
        if (elementType == null) {
            this.elementEditor = new ElementEditorPanel.EmptyElementEditor(this.parentPanel.getBotManagerService());
        } else {
            switch (elementType) {
                case TEXT: {
                    this.elementEditor = new ElementEditorPanel.TextElementEditor(this.parentPanel.getBotManagerService());
                    break;
                }
                case BUTTON: {
                    this.elementEditor = new ElementEditorPanel.ButtonElementEditor(this.parentPanel.getBotManagerService());
                    break;
                }
                case LINK: {
                    this.elementEditor = new ElementEditorPanel.LinkElementEditor(this.parentPanel.getBotManagerService());
                    break;
                }
                case ATTACHMENT: {
                    this.elementEditor = new ElementEditorPanel.AttachmentElementEditor(this.parentPanel.getBotManagerService());
                }
            }
        }
        this.remove(1);
        this.add((Component)this.elementEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 0, 0), 0, 0));
        this.revalidate();
        this.repaint();
    }
}

