/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.Utils;

public class ActionDeleteInvoice
extends ActionBase {
    public void doAction() throws Exception {
        final int id = this.getIntParameter("id", -1);
        String ids = this.getParameter("ids", "");
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        List<Integer> idsdoc = null;
        if (!Utils.isEmptyString((String)ids)) {
            ids = ids.substring(0, ids.length() - 1).replaceAll(";", ",");
            idsdoc = Utils.toIntegerList((String)ids);
        } else {
            idsdoc = new ArrayList<Integer>(){
                {
                    this.add(id);
                }
            };
        }
        InvoiceManager invoiceManager = new InvoiceManager(this.con, this.mid);
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeleteInvoice", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            for (Integer iddoc : idsdoc) {
                BillDoc doc = invoiceManager.getBillDocInfo(iddoc);
                if (doc == null) continue;
                LocalDate month = LocalDate.of(doc.getYy(), doc.getMm() + 1, 1);
                ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (LocalDate)month);
            }
        }
        invoiceManager.delete(idsdoc);
    }
}

