/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.service;

import bitel.billing.server.contract.bean.ContractManager;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.net.URI;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.jasperreports.engine.JasperReport;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dto.FileDto;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.server.bean.ConfigDAO;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.bill.common.bean.Attribute;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.DocTypes;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentPosition;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentSendParameters;
import ru.bitel.bgbilling.modules.bill.common.bean.InvoiceDocument;
import ru.bitel.bgbilling.modules.bill.common.bean.NumerationPool;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.BillPositionType;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractManager;
import ru.bitel.bgbilling.modules.bill.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeDao;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeTypeDao;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDocumentDao;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceDocumentDao;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.modules.bill.server.bean.NumerationPoolManager;
import ru.bitel.bgbilling.modules.bill.server.bean.OrganizationDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBill;
import ru.bitel.bgbilling.modules.bill.server.bean.TemplateBillManager;
import ru.bitel.bgbilling.modules.bill.server.event.BillCreatedEvent;
import ru.bitel.bgbilling.modules.bill.server.task.BillDocsSender;
import ru.bitel.bgbilling.modules.bill.server.task.BillDocsSenderForAll;
import ru.bitel.bgbilling.modules.reports.server.bean.BGReportTemplate;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.FOUtils;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.LogEntry;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.bill.common.service.BillService")
public class BillServiceImpl
extends AbstractService
implements BillService {
    public Result<BillDocument> billDocumentListForContract(int contractId, Page page) throws Exception {
        return new Result(new BillDocumentDao(this.getSetup(), (ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId).list(contractId, page), page);
    }

    public void billDocumentDelete(int contractId, int id, boolean customer) throws Exception {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException("contractId");
        }
        BillManager billManager = new BillManager(this.getConnection(), this.moduleId);
        Bill bill = billManager.getBill(id);
        Calendar closedDate = null;
        if (bill != null && (closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"BillService.billDocumentDelete", (int)this.moduleId, (int)this.userId)) != null) {
            LocalDate month = LocalDate.of(bill.getYy(), bill.getMm() + 1, 1);
            ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (LocalDate)month);
        }
        if (customer) {
            int result = billManager.deleteBill(contractId, id, !customer);
            switch (result) {
                case 1: {
                    throw new BGMessageException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u0441\u0447\u0435\u0442", "bill.deleteError.userId");
                }
                case 2: {
                    throw new BGMessageException("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0439 \u0441\u0447\u0435\u0442", "bill.deleteError.status");
                }
                case 4: {
                    throw new BGMessageException("\u0421\u0447\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "bill.deleteError.notFound");
                }
            }
        } else {
            if (bill == null || bill.getContractId() != contractId) {
                throw new BGIllegalArgumentException("contractId");
            }
            billManager.delete(id);
        }
    }

    public List<DocType> documentSpecListForCustomer(int contractId) throws Exception {
        ArrayList<DocType> billTypeList = new ArrayList<DocType>();
        Set allowedWebBillTypes = Utils.toIntegerSet((String)this.getModuleSetup().get("allowed.web.bill.types", null));
        for (DocType type : new ContractDocTypeManager(this.getConnection(), this.moduleId).getContractDocTypeList(contractId, DocumentType.BILL)) {
            if (!allowedWebBillTypes.contains(type.getId())) continue;
            billTypeList.add(type);
        }
        return billTypeList;
    }

    public List<BankAccount> bankAccountList() throws Exception {
        return new AccountManager(this.getConnection(), this.moduleId).getAccountList().stream().map(a -> a.toBankAccount()).collect(Collectors.toList());
    }

    public List<DocumentPosition> templateDocumentPositionList(int contractId, int documentSpecId, int year, int month) throws Exception {
        DocTypeManager docTypeManager = new DocTypeManager(this.getConnection(), this.moduleId);
        DocType docType = docTypeManager.getType(documentSpecId);
        ContractManager contractManager = new ContractManager(this.getConnection());
        TemplateBill templateBill = new TemplateBill();
        PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, docType.getDocumentType());
        TemplateBillManager templateBillManager = new TemplateBillManager(this.getConnection(), this.moduleId, docType.getDocumentType());
        templateBillManager.getTemplatePositions(contractManager, templateBill, new GregorianCalendar(year, month, 1), contractId, String.valueOf(contractId), null, docType, positionDao.getPositionMap());
        return templateBill.getPositionList() == null ? null : templateBill.getPositionList().stream().map(e -> e.toDocumentPosition()).collect(Collectors.toList());
    }

    public int billDocumentCreate(int contractId, int documentSpecId, int bankAccountId, int year, int month, List<DocumentPosition> documentPositionList) throws Exception {
        if (!this.documentSpecListForCustomer(contractId).stream().anyMatch(s -> s.getId() == documentSpecId)) {
            new BGIllegalArgumentException("documentSpecId");
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"BillService.billDocumentCreate", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            LocalDate datemonth = LocalDate.of(year, month + 1, 1);
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)datemonth, (LocalDate)datemonth);
        }
        List<DocumentPosition> templateDocumentPositionList = this.templateDocumentPositionList(contractId, documentSpecId, year, month);
        ArrayList<PositionValue> posList = new ArrayList<PositionValue>();
        BigDecimal total = BigDecimal.ZERO;
        for (DocumentPosition pos : documentPositionList) {
            if (!templateDocumentPositionList.stream().anyMatch(s -> s.getPositionId() == pos.getPositionId())) {
                new BGIllegalArgumentException("positionId=" + pos.getPositionId());
            }
            PositionValue val = new PositionValue();
            val.setPositionId(pos.getPositionId());
            val.setName(pos.getName());
            val.setSum(pos.getAmount());
            val.setUnit(Utils.maskNull((String)pos.getUnit()));
            pos.setInTotal(true);
            val.setInSumm(true);
            val.setQuantity(Utils.parseBigDecimal((String)this.getModuleSetup().get("web.bill.generate.position.quantity", "0"), (BigDecimal)BigDecimal.ZERO));
            posList.add(val);
            total = total.add(val.getSum());
        }
        Bill bill = new Bill();
        bill.setContractId(contractId);
        bill.setTypeId(documentSpecId);
        bill.setAccountId(bankAccountId);
        bill.setBankAccount(new AccountManager(this.getConnection(), this.moduleId).getBankAccount(bankAccountId));
        bill.setYy(year);
        bill.setMm(month);
        bill.setSumm(total);
        bill.setCreateDate(new Date());
        bill.setUserId(-1);
        bill.setNpid(new DocTypeManager(this.getConnection(), this.moduleId).getType(documentSpecId).getNpid());
        int billId = new BillManager(this.getConnection(), this.moduleId).addBillDoc(this.userId, bill, posList, Collections.emptyList());
        this.context.publishAfterCommit((Event)new BillCreatedEvent(this.userId, this.moduleId, contractId, billId));
        return billId;
    }

    public FileDto billDocumentDownload(int contractId, int id) throws Exception {
        return this.documentDownload(contractId, id, false);
    }

    private FileDto documentDownload(int contractId, int id, boolean invoice) throws Exception {
        if (this.moduleId <= 0 || contractId <= 0 || id <= 0) {
            throw new BGIllegalArgumentException();
        }
        Connection con = this.getConnection();
        AbstractManager manager = invoice ? new InvoiceManager(con, this.moduleId) : new BillManager(con, this.moduleId);
        String patternName = BillUtil.getPatternName(invoice ? DocumentSendParameters.SendingDataType.INVOICE : DocumentSendParameters.SendingDataType.BILL, con, this.moduleId, id);
        byte[] xmlData = manager.getXMLData(contractId, id);
        if (xmlData == null) {
            throw new BGIllegalArgumentException("documentNotFoundForContract");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2000);
        FileDto fileDto = new FileDto();
        fileDto.setContentType("application/pdf");
        fileDto.setFileName(this.docl2PDF(con, xmlData, patternName, invoice, baos));
        fileDto.setData(Base64.getEncoder().encodeToString(baos.toByteArray()));
        return fileDto;
    }

    private String docl2PDF(Connection con, byte[] data, String patternName, boolean invoice, OutputStream out) throws Exception {
        Date date;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Document doc = XMLUtils.parseDocument((InputSource)new InputSource(bis));
        Element bill = (Element)doc.getDocumentElement().getElementsByTagName("bill").item(0);
        StringBuilder fileName = new StringBuilder(50);
        if (invoice) {
            fileName.append("Invoice_");
        } else {
            fileName.append("Bill_");
        }
        String contract = bill.getAttribute("contract");
        if (Utils.notBlankString((String)contract)) {
            fileName.append(contract).append("_");
        }
        if ((date = TimeUtils.parseDate((String)bill.getAttribute("date"), (String)"dd.MM.yyyy")) != null) {
            fileName.append(TimeUtils.format((Date)date, (String)"yyyyMMdd"));
        }
        fileName.append(".pdf");
        bill.setAttribute("with_stamp", "1");
        if (patternName.endsWith(".jrxml")) {
            JasperReport report = BGReportTemplate.getJasperReport((ParameterMap)this.getSetup(), (URI)new File(XSLManager.getInstance().getXslRootPath() + patternName).toURI());
            BGReportFilter reportFilter = new BGReportFilter(Collections.emptyMap(), (Preferences)this.getSetup(), this.userId);
            BGReportTemplate.fillReportToPdfStream((JasperReport)report, (BGReportFilter)reportFilter, (Connection)con, (Document)doc, (OutputStream)out);
        } else {
            XSLManager.getInstance().transform((Source)new DOMSource(doc), patternName, (javax.xml.transform.Result)FOUtils.renderSAXResult((OutputStream)out, (String)"application/pdf"));
        }
        return fileName.toString();
    }

    public Result<InvoiceDocument> invoiceDocumentListForContract(int contractId, boolean onlyReady, Page page) throws Exception {
        return new Result(new InvoiceDocumentDao(this.getSetup(), (ParameterMap)this.getModuleSetup(), this.getConnection(), this.moduleId).list(contractId, onlyReady, page), page);
    }

    public FileDto invoiceDocumentDownload(int contractId, int id) throws Exception {
        return this.documentDownload(contractId, id, true);
    }

    public List<IdTitle> getBankAccountTitleList(int contractId, int organizationId, Boolean inUse, Holder<Integer> selectedItemId) throws Exception {
        try (ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);){
            selectedItemId.value = Utils.parseInteger((String)configDao.get(contractId, "bank.account.id"), (Integer)0);
        }
        return new AccountManager(this.getConnection(), this.moduleId).getAccountTitleList(organizationId, inUse);
    }

    public void setBankAccount(int contractId, int selectedBabkAccountId) throws Exception {
        try (ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);){
            if (selectedBabkAccountId == 0) {
                configDao.delete(contractId, "bank.account.id");
            } else {
                configDao.update(contractId, "bank.account.id", String.valueOf(selectedBabkAccountId));
            }
        }
    }

    public List<BankAccount> getBankAccountList(int organizationId, Boolean inUse) throws Exception {
        return new AccountManager(this.getConnection(), this.moduleId).getBankAccountList(organizationId, inUse);
    }

    public void setDefaultBankAccount(BankAccount bankAccount) throws Exception {
        new AccountManager(this.getConnection(), this.moduleId).setDefaultBankAccount(bankAccount.getId(), bankAccount.getOrganizationId());
    }

    public BankAccount getDefaultBankAccount(int organizationId) throws Exception {
        return new AccountManager(this.getConnection(), this.moduleId).getDefaultBankAccount(organizationId);
    }

    public void updateBankAccount(BankAccount bankAccount) throws Exception {
        new AccountManager(this.getConnection(), this.moduleId).updateBankAccount(bankAccount);
    }

    public void deleteBankAccount(int bankAccountId) throws Exception {
        new AccountManager(this.getConnection(), this.moduleId).deleteBankAccount(bankAccountId);
    }

    public BankAccount getBankAccount(int bankAccountId) throws Exception {
        return new AccountManager(this.getConnection(), this.moduleId).getBankAccount(bankAccountId);
    }

    public List<Organization> getOrganizationList() throws Exception {
        ArrayList<Organization> list = new ArrayList<Organization>();
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            list.addAll(organizationDao.getOrganizationList());
        }
        return list;
    }

    public void updateOrganization(Organization organization) throws Exception {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            organizationDao.update(organization);
        }
    }

    public void deleteOrganization(int organizationId) throws Exception {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            organizationDao.deleteOrganization(organizationId);
        }
    }

    public void setDefaultOrganization(int organizationId) throws Exception {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            organizationDao.setDefaultOrganization(organizationId);
        }
    }

    public void setOrganization(int contractId, int selectedOrganizationId) throws Exception {
        try (ContractModuleConfigDao configDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);){
            if (selectedOrganizationId == 0) {
                configDao.delete(contractId, "organization.id");
            } else {
                configDao.update(contractId, "organization.id", String.valueOf(selectedOrganizationId));
            }
        }
    }

    public List<IdTitle> getOrganizationTitleList(int contractId, Boolean inUse, Holder<Integer> selectedItemId) throws Exception {
        try (ContractModuleConfigDao contractModuleConfigDao = new ContractModuleConfigDao(this.getConnection(), this.moduleId);){
            List<IdTitle> list;
            try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
                selectedItemId.value = Utils.parseInteger((String)contractModuleConfigDao.get(contractId, "organization.id"), (Integer)0);
                list = organizationDao.getOrganizationTitleList(inUse);
            }
            return list;
        }
    }

    public Organization getOrganization(int organizationId) throws Exception {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            Organization organization = organizationDao.getOrganization(organizationId);
            return organization;
        }
    }

    public Organization getDefaultOrganization() throws Exception {
        try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
            Organization organization = organizationDao.getDefaultOrganization();
            return organization;
        }
    }

    public DocType docTypeGet(int id) throws Exception {
        return new DocTypeManager(this.getConnection(), this.moduleId).getType(id);
    }

    public void docTypeUpdate(DocType dt) throws Exception {
        new DocTypeManager(this.getConnection(), this.moduleId).updateType(dt);
    }

    public void docTypeDelete(int id) throws Exception {
        new DocTypeManager(this.getConnection(), this.moduleId).deleteType(id);
    }

    public List<DocType> docTypeList(DocumentType documentType) throws Exception {
        return new DocTypeManager(this.getConnection(), this.moduleId).getTypeList(documentType);
    }

    public List<DocType> docTypeListForContract(int contractId, DocumentType documentType) throws Exception {
        ArrayList<DocType> list = new ArrayList<DocType>();
        ContractDocTypeManager cdtm = new ContractDocTypeManager(this.getConnection(), this.moduleId);
        List<ContractDocType> selected = cdtm.getContractTypeList(contractId, documentType, null);
        block0: for (DocType docType : new DocTypeManager(this.getConnection(), this.moduleId).getTypeList(documentType)) {
            for (ContractDocType contractDocType : selected) {
                if (contractDocType.getDocTypeId() != docType.getId()) continue;
                list.add(docType);
                continue block0;
            }
        }
        return list;
    }

    public List<IdTitle> positionList(DocumentType documentType) throws Exception {
        PositionDao positionDao = new PositionDao(this.getConnection(), this.moduleId, documentType);
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        for (Position p : positionDao.getPositonList()) {
            list.add(new IdTitle(p.getId(), p.getTitle()));
        }
        return list;
    }

    public MapHolder<Integer, List<IdTitle>> xmlComposition() throws Exception {
        MapHolder map = new MapHolder();
        ArrayList<IdTitle> moduleList = new ArrayList<IdTitle>();
        ArrayList<IdTitle> pluginList = new ArrayList<IdTitle>();
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            moduleList.add(new IdTitle(module.getId(), module.getTitle()));
        }
        for (BGPluginServer pluginServer : BGPluginManagerServer.getManager().getPluginsMap().values()) {
            pluginList.add(new IdTitle(pluginServer.getPluginUID(), pluginServer.getName()));
        }
        map.getMap().put(1, moduleList);
        map.getMap().put(2, pluginList);
        return map;
    }

    public SearchResult<Position> searchPositionList(DocumentType documentType, Page page) throws Exception {
        return new PositionDao(this.getConnection(), this.moduleId, documentType).searchPositionList(page);
    }

    public Position positionGet(DocumentType documentType, int positionId) throws Exception {
        return new PositionDao(this.getConnection(), this.moduleId, documentType).getPosition(positionId);
    }

    public Position positionUpdate(DocumentType documentType, Position position) throws Exception {
        return new PositionDao(this.getConnection(), this.moduleId, documentType).updatePosition(position);
    }

    public boolean positionDelete(DocumentType documentType, int positionId) throws Exception {
        return new PositionDao(this.getConnection(), this.moduleId, documentType).deletePosition(positionId);
    }

    public void sendDocsForAll(DocumentSendParameters senderTaskParameters) throws Exception {
        senderTaskParameters.setModuleId(this.context.getModuleId());
        senderTaskParameters.setUserId(this.userId);
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new BillDocsSenderForAll(senderTaskParameters));
    }

    public void sendDocs(DocumentSendParameters senderTaskParameters) throws Exception {
        senderTaskParameters.setModuleId(this.context.getModuleId());
        senderTaskParameters.setUserId(this.userId);
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new BillDocsSender(senderTaskParameters));
    }

    public void attributeTypeUpdate(AttributeType attributeType) throws Exception {
        if (attributeType == null || Utils.isBlankString((String)attributeType.getName()) || Utils.isBlankString((String)attributeType.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        new AttributeTypeDao(this.getConnection(), this.moduleId).update(attributeType);
    }

    public void attributeTypeDelete(int attributeTypeId) throws Exception {
        new AttributeTypeDao(this.getConnection(), this.moduleId).delete(attributeTypeId);
    }

    public List<AttributeType> attributeTypeList() throws Exception {
        return new AttributeTypeDao(this.getConnection(), this.moduleId).getAttributeTypeList();
    }

    public List<Attribute> attributeList(int contractId) throws Exception {
        if (contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return new AttributeDao(this.getConnection(), this.moduleId).getAttributeListByCid(contractId);
    }

    public void attributeUpdate(int contractId, Attribute attribute) throws Exception {
        if (attribute == null || attribute.getContractId() <= 0) {
            throw new BGIllegalArgumentException();
        }
        AttributeDao attributeDao = new AttributeDao(this.getConnection(), this.moduleId);
        if (attribute == null || attribute.getContractId() != contractId) {
            throw new BGMessageException("attribute==null \u0438\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 contractId");
        }
        attributeDao.update(attribute);
    }

    public void attributeDelete(int contractId, int attributeId) throws Exception {
        if (contractId <= 0 || attributeId < 1) {
            throw new BGIllegalArgumentException();
        }
        AttributeDao attributeDao = new AttributeDao(this.getConnection(), this.moduleId);
        Attribute attribute = (Attribute)attributeDao.get(attributeId);
        if (attribute == null || attribute.getContractId() != contractId) {
            throw new BGMessageException("attribute==null \u0438\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 contractId");
        }
        attributeDao.delete(attributeId);
    }

    public List<String> positionSearch(BillPositionType billPositionType, Page page) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        this.resetModuleSetup();
        ModuleSetup moduleSetup = this.getModuleSetup();
        switch (billPositionType) {
            case BILL: {
                list.addAll(this.buildPositionList(moduleSetup.sub("bill.pos.")));
                break;
            }
            case INVOICE: {
                list.addAll(this.buildPositionList(moduleSetup.sub("invoice.pos.")));
                break;
            }
        }
        return list;
    }

    public void positionDataUpdate(BillPositionType billPositionType, String positionData) throws Exception {
        ConfigDAO configDAO = new ConfigDAO(this.getConnection());
        ConfigData configData = configDAO.getActiveConfig(this.moduleId);
        if (configData == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f [moduleId=" + this.moduleId + "]");
        }
        ArrayList<CallSite> config = new ArrayList<CallSite>();
        Stream.of(configData.getConfig().split("\n")).forEach(e -> config.add((CallSite)e));
        JSONObject json = new JSONObject(positionData);
        String prefix = (billPositionType == BillPositionType.BILL ? "bill" : "invoice") + ".pos." + json.optString("key") + ".";
        json.remove("id");
        json.remove("key");
        for (String key : json.keySet()) {
            boolean update = false;
            String value = json.getString(key);
            for (int index = 0; index < config.size(); ++index) {
                String line = (String)config.get(index);
                if (!line.startsWith(prefix + key + "=")) continue;
                if (Utils.isBlankString((String)value)) {
                    config.remove(index);
                } else {
                    config.set(index, (CallSite)((Object)(prefix + key + "=" + value)));
                }
                update = true;
                break;
            }
            if (update || !Utils.notBlankString((String)value)) continue;
            config.add((CallSite)((Object)(prefix + key + "=" + value)));
        }
        StringBuffer stringBuffer = new StringBuffer();
        config.stream().forEach(l -> stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "").append((String)l));
        configData.setConfig(stringBuffer.toString());
        configDAO.update((Object)configData);
        EventProcessor.getInstance().publish((Event)new ModuleConfigModifiedEvent(this.moduleId, this.userId));
    }

    public void positionDataDelete(BillPositionType billPositionType, String key) throws Exception {
        ConfigDAO configDAO = new ConfigDAO(this.getConnection());
        ConfigData configData = configDAO.getActiveConfig(this.moduleId);
        if (configData == null) {
            throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0434\u043b\u044f \u043c\u043e\u0434\u0443\u043b\u044f [moduleId=" + this.moduleId + "]");
        }
        ArrayList config = new ArrayList();
        Stream.of(configData.getConfig().split("\n")).forEach(e -> config.add(e));
        String prefix = (billPositionType == BillPositionType.BILL ? "bill" : "invoice") + ".pos." + key + ".";
        for (int index = config.size() - 1; index >= 0; --index) {
            String line = (String)config.get(index);
            if (!line.startsWith(prefix)) continue;
            config.remove(index);
        }
        StringBuffer stringBuffer = new StringBuffer();
        config.stream().forEach(l -> stringBuffer.append(stringBuffer.length() > 0 ? "\n" : "").append((String)l));
        configData.setConfig(stringBuffer.toString());
        configDAO.update((Object)configData);
        EventProcessor.getInstance().publishAfterCommit((Event)new ModuleConfigModifiedEvent(this.moduleId, this.userId));
    }

    private List<String> buildPositionList(ParameterMap subMap) {
        ArrayList<String> list = new ArrayList<String>();
        HashMap<String, HashMap<String, String>> maps = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry entry : subMap.entrySet()) {
            int pos = ((String)entry.getKey()).indexOf(46);
            if (pos <= 0) continue;
            String key = ((String)entry.getKey()).substring(0, pos);
            HashMap<String, String> map = (HashMap<String, String>)maps.get(key);
            if (map == null) {
                map = new HashMap<String, String>();
                maps.put(key, map);
            }
            map.put(((String)entry.getKey()).substring(pos + 1), (String)entry.getValue());
        }
        int id = 1;
        for (Map.Entry entry : maps.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", id++);
            jsonObject.put("key", entry.getKey());
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                jsonObject.put((String)entry1.getKey(), entry1.getValue());
            }
            list.add(jsonObject.toString());
        }
        return list;
    }

    public void numerationPoolDelete(int id) throws Exception {
        try (NumerationPoolManager numerationPoolManager = new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId);){
            numerationPoolManager.delete(id);
        }
    }

    public NumerationPool numerationPoolGet(int id) throws Exception {
        try (NumerationPoolManager numerationPoolManager = new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId);){
            NumerationPool numerationPool = (NumerationPool)numerationPoolManager.get(id);
            return numerationPool;
        }
    }

    public List<NumerationPool> numerationPoolList() throws Exception {
        try (NumerationPoolManager numerationPoolManager = new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId);){
            List<NumerationPool> list = numerationPoolManager.list();
            return list;
        }
    }

    public void numerationPoolUpdate(NumerationPool numerationPool) throws Exception {
        try (NumerationPoolManager numerationPoolManager = new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId);){
            numerationPoolManager.update((Id)numerationPool);
        }
    }

    public List<LogEntry> logList(String filter, Object ... args) throws Exception {
        try (NumerationPoolManager numerationPoolManager = new NumerationPoolManager(this.getConnection(), this.moduleId, this.userId);){
            if ("oid".equals(filter)) {
                List list = numerationPoolManager.logListByOid((Integer)args[0]);
                return list;
            }
            List list = numerationPoolManager.logListByCid((Integer)args[0]);
            return list;
        }
    }

    public DocTypes documentTypes(int contractId, DocumentType documentType) throws Exception {
        if (documentType == null) {
            throw new BGIllegalArgumentException();
        }
        DocTypes docTypes = new DocTypes();
        DocTypeManager docTypeManager = new DocTypeManager(this.getConnection(), this.moduleId);
        ContractDocTypeManager cdtm = new ContractDocTypeManager(this.getConnection(), this.moduleId);
        List<DocType> avaliable = docTypeManager.getTypeList(documentType);
        List<ContractDocType> selected = cdtm.getContractTypeList(contractId, documentType, null);
        for (DocType dt : avaliable) {
            boolean isIn = false;
            for (ContractDocType contractDocType : selected) {
                if (contractDocType.getDocTypeId() != dt.getId()) continue;
                isIn = true;
            }
            (isIn ? docTypes.getSelectList() : docTypes.getAvaliableList()).add(dt.toIdTitle());
        }
        return docTypes;
    }

    public List<IdTitle> docTypeTitles(int contractId, DocumentType documentType) throws Exception {
        return this.docTypeListForContract(contractId, documentType).stream().map(IdTitle::toIdTitle).toList();
    }

    public List<IdTitle> contractParameters() throws Exception {
        return this.context.getDirectory(ContractParameterGroupAttr.class, 0).list().stream().map(IdTitle::toIdTitle).toList();
    }

    public BigDecimal rateVATGet() throws Exception {
        return Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)).getBigDecimal("bill.nds", BigDecimal.ONE);
    }
}

