/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.math.BigInteger;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpRange;

public class IpField
extends BGTextField {
    private static final String IPADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])/(\\d|\\d\\d)$";

    public IpField() {
        super(25);
        this.setHorizontalAlignment(0);
    }

    public IpAddress getAddress() {
        try {
            String text = this.getText();
            if (Utils.isBlankString(text)) {
                return null;
            }
            return new IpAddress(InetAddress.getByName(this.getText()).getAddress());
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return null;
        }
    }

    public IpRange getAddressRange() {
        try {
            String text = this.getText();
            if (Utils.isBlankString(text)) {
                return null;
            }
            Pattern pattern = Pattern.compile(IPADDRESS_PATTERN);
            Matcher matcher = pattern.matcher(text);
            if (matcher.matches() && matcher.groupCount() >= 5) {
                matcher.groupCount();
                String address = matcher.group(1) + "." + matcher.group(2) + "." + matcher.group(3) + "." + matcher.group(4);
                int mask = Utils.parseInt(matcher.group(5));
                byte[] addressFrom = InetAddress.getByName(address).getAddress();
                long longAddress = addressFrom.length == 4 ? (long)Utils.convertBytesToInt(addressFrom) : Utils.convertBytesToLong(addressFrom);
                long[] r = IPUtils.netMaskToRange(longAddress, mask);
                return new IpRange(IpAddress.convertBigIntToIp4Address(new BigInteger(String.valueOf(r[0]))), IpAddress.convertBigIntToIp4Address(new BigInteger(String.valueOf(r[1]))));
            }
            String[] val = text.split("-");
            if (val.length > 1) {
                return new IpRange(InetAddress.getByName(val[0].trim()).getAddress(), InetAddress.getByName(val[1].trim()).getAddress());
            }
            byte[] address = InetAddress.getByName(this.getText().trim()).getAddress();
            return new IpRange(address, address);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
            return null;
        }
    }
}

