/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.client.admin;

import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseProduct;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseComponentCategory;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBoxRefresh;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.xml.JAXBUtils;

public class LicenseProductPanel
extends BGUPanel {
    private BGTabbedPane tabbedPane = new BGTabbedPane();
    private BGControlPanelListSelect selectList = new BGControlPanelListSelect();
    private BGControlPanelListSelect availableList = new BGControlPanelListSelect();
    private BGTitleBorder selectComponentListBorder = new BGTitleBorder("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b");
    private BGTitleBorder availableComponentListBorder = new BGTitleBorder("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b");
    private BGTitleBorder selectProductListBorder = new BGTitleBorder("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
    private BGTitleBorder availableProductListBorder = new BGTitleBorder("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b");
    private ProductsTableModel productsTableModel = new ProductsTableModel();
    private BGDataSourceTableModel componentsTableModel = new BGDataSourceTableModel("ProductComponents");
    private BGUPanel.WebServiceHolder<LicenseService> licenseService = new BGUPanel.WebServiceHolder((BGUPanel)this, LicenseService.class);

    protected void jbInit() {
        Consumer<MouseEvent> consumer = e -> this.performAction("edit");
        this.tabbedPane.add("\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b", (Component)this.getProductsPanel(consumer));
        this.tabbedPane.add("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", (Component)this.getProductItemsPanel(consumer));
        this.tabbedPane.addChangeListener(event -> {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.selectList.setBorder((Border)this.selectComponentListBorder);
                this.availableList.setBorder((Border)this.availableComponentListBorder);
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                this.selectList.setBorder((Border)this.selectProductListBorder);
                this.availableList.setBorder((Border)this.availableProductListBorder);
            }
            this.performAction("refresh");
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getLinksPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
    }

    private JPanel getProductsPanel(Consumer<MouseEvent> consumer) {
        BGUTable table = new BGUTable((TableModel)((Object)this.productsTableModel));
        BGSwingUtilites.handleLDMouseClicked((Component)table, consumer);
        table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.setLists();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane((Component)table), "Center");
        return panel;
    }

    private JPanel getProductItemsPanel(Consumer<MouseEvent> consumer) {
        BGUTable table = new BGUTable((TableModel)this.componentsTableModel);
        BGSwingUtilites.handleLDMouseClicked((Component)table, consumer);
        table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.setLists();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane((Component)table), "Center");
        return panel;
    }

    private JPanel getLinksPanel() {
        this.selectList.setBorder((Border)this.selectComponentListBorder);
        this.availableList.setBorder((Border)this.availableComponentListBorder);
        BGButton addButton = new BGButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0432 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435");
        addButton.addActionListener(e -> this.setListItemsSelected(true));
        BGButton delButton = new BGButton("\u0423\u0431\u0440\u0430\u0442\u044c \u0438\u0437 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445");
        delButton.addActionListener(e -> this.setListItemsSelected(false));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)addButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((Component)delButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        Dimension dimension = new Dimension(500, 300);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.add((Component)this.selectList, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.availableList, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private void setLists() {
        this.selectList.getListModel().clear();
        this.availableList.getListModel().clear();
        try {
            Id componentId;
            JSONArray links = null;
            if (this.tabbedPane.getSelectedIndex() == 0) {
                LicenseProduct product = (LicenseProduct)this.productsTableModel.getSelectedRow();
                if (product != null) {
                    links = new JSONArray(((LicenseService)this.licenseService.get()).getProductLinks(product.getId()));
                }
            } else if (this.tabbedPane.getSelectedIndex() == 1 && (componentId = (Id)this.componentsTableModel.getSelectRow(Id.class)) != null) {
                links = new JSONArray(((LicenseService)this.licenseService.get()).getProductItemLinks(componentId.getId()));
            }
            if (links != null) {
                ArrayList<IdTitle> selList = new ArrayList<IdTitle>();
                ArrayList avaList = new ArrayList();
                int len = links.length();
                for (int index = 0; index < len; ++index) {
                    JSONObject itemJson = links.getJSONObject(index);
                    IdTitle item = new IdTitle(itemJson.getInt("id"), itemJson.getString("title"));
                    (itemJson.getBoolean("select") ? selList : avaList).add(item);
                }
                ClientUtils.buildList((JList)this.selectList.getList(), selList);
                ClientUtils.buildList((JList)this.availableList.getList(), avaList);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void setListItemsSelected(boolean select) {
        String selectIds;
        Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setModuleId(((ClientContext)this.getContext()).getModuleId());
        if (select) {
            request.setAction("ProductItemLinkToProduct");
            selectIds = this.availableList.getListValues();
        } else {
            request.setAction("ProductItemUnlinkFromProduct");
            selectIds = this.selectList.getListValues();
        }
        request.setAttribute("ids", selectIds);
        try {
            if (Utils.notBlankString((String)selectIds)) {
                Id componentId;
                if (this.tabbedPane.getSelectedIndex() == 0) {
                    LicenseProduct product = (LicenseProduct)this.productsTableModel.getSelectedRow();
                    if (product != null) {
                        request.setAttribute("product_id", product.getId());
                    }
                } else if (this.tabbedPane.getSelectedIndex() == 1 && (componentId = (Id)this.componentsTableModel.getSelectRow(Id.class)) != null) {
                    request.setAttribute("product_item_id", componentId.getId());
                }
                ClientUtils.checkStatus((Document)((ClientContext)this.getContext()).getDocument(request));
                this.setLists();
            }
        }
        catch (Exception e) {
            return;
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                this.productsTableModel.setData(((LicenseService)this.licenseService.get()).productList());
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                this.tryCall(() -> {
                    BGUTableParams tableParams = new BGUTableParams();
                    this.componentsTableModel.loadData((ClientContext)this.getContext(), tableParams);
                });
            }
            this.setLists();
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            if (this.tabbedPane.getSelectedIndex() == 0) {
                new ProductEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442", new LicenseProduct()).open();
            } else if (this.tabbedPane.getSelectedIndex() == 1) {
                new ProductItemEditor("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442", new LicenseComponent()).open();
            }
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            Id id;
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setModuleId(((ClientContext)this.getContext()).getModuleId());
            if (this.tabbedPane.getSelectedIndex() == 0) {
                LicenseProduct product = (LicenseProduct)this.productsTableModel.getSelectedRow();
                if (product != null) {
                    int id2 = product.getId();
                    request.setAction("GetProduct").setAttribute("id", id2);
                    Document doc = ((ClientContext)this.getContext()).getDocument(request);
                    if (ClientUtils.checkStatus((Document)doc)) {
                        this.tryCall(() -> new ProductEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", (LicenseProduct)JAXBUtils.unmarshal((Node)doc, (String)"/data/product", LicenseProduct.class)).open());
                    }
                }
            } else if (this.tabbedPane.getSelectedIndex() == 1 && (id = (Id)this.componentsTableModel.getSelectRow(Id.class)) != null && id.getId() > 0) {
                this.tryCall(() -> {
                    LicenseComponent component = ((LicenseService)this.licenseService.get()).productComponentGet(id.getId());
                    new ProductItemEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430", component).open();
                });
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            Id componentId;
            Request request = new Request().setModule(((ClientContext)this.getContext()).getModule()).setModuleId(((ClientContext)this.getContext()).getModuleId());
            Request delRequest = new Request().setModule(((ClientContext)this.getContext()).getModule()).setModuleId(((ClientContext)this.getContext()).getModuleId());
            if (this.tabbedPane.getSelectedIndex() == 0) {
                LicenseProduct product = (LicenseProduct)this.productsTableModel.getSelectedRow();
                if (product != null) {
                    int id = product.getId();
                    request.setAction("CheckProductUsing").setAttribute("product_id", id);
                    Document doc = ((ClientContext)this.getContext()).getDocument(request);
                    if (ClientUtils.checkStatus((Document)doc)) {
                        try {
                            Element tableRow = XMLUtils.selectElement((Node)doc, (String)"/data/table/data/row");
                            if (tableRow.getAttribute("inUse").equals("true")) {
                                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.");
                            } else if (tableRow.getAttribute("inUse").equals("false") && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0432\u0441\u0435\u0445 \u0432\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u0432 \u043d\u0435\u0433\u043e \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430\u0445?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", 0) == 0) {
                                delRequest.setAction("DeleteProduct").setAttribute("id", id);
                                doc = ((ClientContext)this.getContext()).getDocument(delRequest);
                                if (ClientUtils.checkStatus((Document)doc)) {
                                    this.performAction("refresh");
                                }
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            } else if (this.tabbedPane.getSelectedIndex() == 1 && (componentId = (Id)this.componentsTableModel.getSelectRow(Id.class)) != null) {
                int id = componentId.getId();
                request.setAction("CheckProductItemUsing");
                request.setAttribute("product_item_id", id);
                Document doc = ((ClientContext)this.getContext()).getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    this.tryCall(() -> {
                        Element tableRow = XMLUtils.selectElement((Node)doc, (String)"/data/table/data/row");
                        if (tableRow.getAttribute("inUse").equals("true")) {
                            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u043d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c, \u0442\u0430\u043a \u043a\u0430\u043a \u043e\u043d \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.");
                        } else if (tableRow.getAttribute("inUse").equals("false") && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0438\u0437 \u0432\u0441\u0435\u0445 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430", 0) == 0) {
                            delRequest.setAction("DeleteProductItem").setAttribute("id", id);
                            Document doc1 = ((ClientContext)this.getContext()).getDocument(delRequest);
                            if (ClientUtils.checkStatus((Document)doc1)) {
                                this.performAction("refresh");
                            }
                        }
                    });
                }
            }
        });
    }

    class ProductsTableModel
    extends BGTableModel<LicenseProduct> {
        public ProductsTableModel() {
            super(ProductsTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0412\u0435\u0440\u0441\u0438\u044f", 100, 100, 100, "version", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class ProductItemEditor
    extends BGEditorDialog<LicenseComponent> {
        private BGTextField title;
        private BGTextField name;
        private BGTextField comment;
        private BGUComboBoxRefresh<IdTitle> category;
        private BGUComboBoxRefresh<IdTitle> tariffGroup;
        private JCheckBox hidden;
        private JCheckBox unlimited;
        private JCheckBox availableOnWeb;

        public ProductItemEditor(String title, LicenseComponent data) {
            super(title, (Object)data);
            this.title = new BGTextField(50);
            this.name = new BGTextField();
            this.comment = new BGTextField();
            this.category = new BGUComboBoxRefresh();
            this.tariffGroup = new BGUComboBoxRefresh();
            this.hidden = new JCheckBox("\u0441\u043a\u0440\u044b\u0442\u044b\u0439");
            this.unlimited = new JCheckBox("\u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d");
            this.availableOnWeb = new JCheckBox("\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0432 \u041b\u041a");
        }

        public void doDialogPanel() {
            this.addFieldV("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435:", (JComponent)this.title);
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:", (JComponent)this.name);
            this.addFieldV("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f:", (JComponent)this.category);
            this.addFieldV("\u0422\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430:", (JComponent)this.tariffGroup);
            this.addFieldV("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:", (JComponent)this.comment);
            this.panel.add((Component)this.getFlagPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 10, 0), 0, 0));
            List<IdTitle> categoryItems = Stream.of(LicenseComponentCategory.values()).map(a -> new IdTitle(a.getCode(), a.getTitle())).toList();
            this.category.setSupplier(() -> categoryItems);
            this.category.refresh();
            this.tariffGroup.setSupplier(() -> ((LicenseService)LicenseProductPanel.this.licenseService.get()).licenseTariffGroupTitles());
            this.tariffGroup.refresh();
            this.name.setEnabled(((LicenseComponent)this.data).getId() < 1);
            this.name.setText(((LicenseComponent)this.data).getName());
            this.title.setText(((LicenseComponent)this.data).getTitle());
            this.comment.setText(((LicenseComponent)this.data).getComment());
            this.hidden.setSelected(((LicenseComponent)this.data).getType() == 1);
            this.unlimited.setSelected(((LicenseComponent)this.data).getUnlimited() == 1);
            this.availableOnWeb.setSelected(((LicenseComponent)this.data).isAvailableOnWeb());
            this.category.setSelectedItem((Object)new Id().setId(((LicenseComponent)this.data).getCategory().getCode()));
            this.tariffGroup.setSelectedItem((Object)new Id().setId(((LicenseComponent)this.data).getTariffGroupId()));
        }

        public boolean doApply() throws Exception {
            LicenseComponent productItem = ((LicenseService)LicenseProductPanel.this.licenseService.get()).productComponentByNameGet(this.name.getText());
            if (productItem != null && productItem.getId() > 0 && productItem.getId() != ((LicenseComponent)this.data).getId()) {
                ClientUtils.showErrorMessageDialog((String)"\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442. \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c.");
                return false;
            }
            if (this.tariffGroup.getSelectedItem() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u0433\u0440\u0443\u043f\u043f\u0443");
                return false;
            }
            ((LicenseComponent)this.data).setTitle(this.title.getText()).setName(this.name.getText()).setComment(this.comment.getText()).setType(this.hidden.isSelected() ? 1 : 0).setUnlimited(this.unlimited.isSelected() ? 1 : 0).setAvailableOnWeb(this.availableOnWeb.isSelected()).setCategory(LicenseComponentCategory.getComponentCategoryByCode((int)((IdTitle)this.category.getSelectedItem()).getId())).setTariffGroupId(((IdTitle)this.tariffGroup.getSelectedItem()).getId());
            return this.tryCallBoolean(() -> {
                ((LicenseService)LicenseProductPanel.this.licenseService.get()).productComponentUpdate((LicenseComponent)this.data);
                LicenseProductPanel.this.performAction("refresh");
            });
        }

        private JPanel getFlagPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.unlimited, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.hidden, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 25, 0, 5), 0, 0));
            panel.add((Component)this.availableOnWeb, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 25, 0, 5), 0, 0));
            return panel;
        }
    }

    class ProductEditor
    extends BGEditorDialog<LicenseProduct> {
        private BGTextField title;
        private BGTextField version;

        public ProductEditor(String title, LicenseProduct data) {
            super(title, (Object)data);
            this.title = new BGTextField(40);
            this.version = new BGTextField(5);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0412\u0435\u0440\u0441\u0438\u044f:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.version, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.title.setText(((LicenseProduct)this.data).getTitle());
            this.version.setText(((LicenseProduct)this.data).getVersion());
        }

        public boolean doApply() throws Exception {
            Request request = new Request().setModule(((ClientContext)LicenseProductPanel.this.getContext()).getModule()).setModuleId(((ClientContext)LicenseProductPanel.this.getContext()).getModuleId()).setAction("UpdateProduct").setAttribute("id", ((LicenseProduct)this.data).getId()).setAttribute("title", this.title.getText()).setAttribute("version", this.version.getText());
            Document doc = ((ClientContext)LicenseProductPanel.this.getContext()).getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                LicenseProductPanel.this.performAction("refresh");
                return true;
            }
            return false;
        }
    }
}

