/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.param.client;

import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.param.client.ParamBankData;
import ru.bitel.common.client.table.BGTableModel;

public class ParamBankToolBar
extends BGDialogToolBar {
    public ParamBankToolBar(BGUTable table, BGTableModel<ParamBankData> tableModel) {
        this.setOrientation(0);
        this.setDefaultButtons(e -> {
            int n = table.getSelectedRow();
            table.getDefaultEditor(table.getColumnClass(0)).stopCellEditing();
            switch (BGDialogToolBar.ButtonData.of(e.getActionCommand())) {
                case NEW_ITEM: {
                    ParamBankData paramBankData = new ParamBankData();
                    BankEditorDialog bankEditorDialog = new BankEditorDialog(this, "\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0431\u0430\u043d\u043a\u0430", paramBankData);
                    bankEditorDialog.open();
                    if (!bankEditorDialog.isDoApply()) break;
                    tableModel.addRow(paramBankData);
                    break;
                }
                case EDIT_ITEM: {
                    tableModel.optSelectedRow().ifPresentOrElse(data -> {
                        new BankEditorDialog(this, "\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u044b \u0431\u0430\u043d\u043a\u0430", (ParamBankData)data).open();
                        tableModel.fireTableDataChanged();
                    }, () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f"));
                    break;
                }
                case DELETE_ITEM: {
                    if (n <= -1) break;
                    tableModel.getRows().remove(n);
                    tableModel.fireTableRowsDeleted(n, n);
                    table.repaint();
                    break;
                }
                case DELETE_ALL_ITEM: {
                    if (!ClientUtils.confirmDelete("\u0432\u0441\u0435 \u0437\u0430\u043f\u0438\u0441\u0438")) break;
                    tableModel.deleteRows();
                    break;
                }
                default: {
                    ClientUtils.showErrorMessageDialog("\u041e\u0428\u0418\u0411\u041a\u0410: " + e.getActionCommand() + "???");
                }
            }
            this.firePropertyChange("updateData", "0", "1");
        }, BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.DELETE_ALL_ITEM);
        this.setFloatable(false);
    }

    class BankEditorDialog
    extends BGEditorDialog<ParamBankData> {
        private BGTextField bankBik = new BGTextField(40);
        private BGTextField bankName = new BGTextField(40);
        private BGTextField bankAccountR = new BGTextField(40);
        private BGTextField bankAccountC = new BGTextField(40);

        public BankEditorDialog(ParamBankToolBar this$0, String title, ParamBankData data) {
            super(title, data);
        }

        @Override
        public void doDialogPanel() {
            this.addFieldV("\u0411\u0418\u041a \u0431\u0430\u043d\u043a\u0430:", this.bankBik);
            this.addFieldV("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0431\u0430\u043d\u043a\u0430:", this.bankName);
            this.addFieldV("\u0420\u0430\u0441\u0447\u0435\u0442\u043d\u044b\u0439 \u0441\u0447\u0435\u0442:", this.bankAccountR);
            this.addFieldV("\u041a\u043e\u0440\u0440\u0435\u0441\u043f\u043e\u043d\u0434\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u0441\u0447\u0435\u0442:", this.bankAccountC);
            this.bankBik.setText(((ParamBankData)this.data).getBik());
            this.bankName.setText(((ParamBankData)this.data).getName());
            this.bankAccountR.setText(((ParamBankData)this.data).getAccountR());
            this.bankAccountC.setText(((ParamBankData)this.data).getAccountC());
        }

        @Override
        public boolean doApply() throws Exception {
            ((ParamBankData)this.data).setBik(this.bankBik.getText());
            ((ParamBankData)this.data).setName(this.bankName.getText());
            ((ParamBankData)this.data).setAccountR(this.bankAccountR.getText());
            ((ParamBankData)this.data).setAccountC(this.bankAccountC.getText());
            return super.doApply();
        }
    }
}

