/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.directory.tariff.client;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.TransferData;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.common.model.IdTitle;

public abstract class DefaultDirectory
implements Directory {
    private String name = "";
    private TransferData transferData;
    protected List<IdTitle> items = new ArrayList<IdTitle>();

    @Override
    public void init(int moduleId) throws Exception {
        DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
        this.transferData = dbInfo != null ? dbInfo.getTransferData() : null;
        this.items.clear();
        this.loadDir(moduleId);
    }

    @Override
    public String getValue(int code) {
        String result = null;
        IdTitle idTitle = this.getItem(code);
        if (idTitle != null) {
            result = idTitle.getTitle();
        }
        return result;
    }

    @Override
    public void renameValue(int code, String newName) {
        IdTitle idTitle = this.getItem(code);
        if (idTitle != null) {
            idTitle.setTitle(newName);
        }
    }

    @Override
    public List<IdTitle> getItems() {
        return this.items;
    }

    protected IdTitle getItem(int code) {
        IdTitle result = null;
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            IdTitle idTitle = this.items.get(i);
            if (idTitle.getId() != code) continue;
            result = idTitle;
            break;
        }
        return result;
    }

    protected boolean deleteByCode(int code) {
        boolean result = false;
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            IdTitle di = this.items.get(i);
            if (di.getId() != code) continue;
            this.items.remove(i);
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    protected Document getDoc(Request request) {
        Document doc = null;
        try {
            this.transferData.postData(request);
            doc = this.transferData.getDocument();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    protected String getString(Request request) {
        String doc = null;
        try {
            this.transferData.postData(request);
            doc = this.transferData.getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doc;
    }

    @Override
    public int getCode(String value) {
        int result = -1;
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            IdTitle idTitle = this.items.get(i);
            if (!idTitle.getTitle().equals(value)) continue;
            result = idTitle.getId();
            break;
        }
        return result;
    }

    protected abstract void loadDir(int var1) throws Exception;
}

