/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountTypeAbstractDao;

public class VoiceAccountTypeDao
extends VoiceAccountTypeAbstractDao<VoiceAccountType> {
    public VoiceAccountTypeDao(Connection con, int moduleId) {
        super(con, moduleId);
        this.isOperator = false;
    }

    @Override
    protected VoiceAccountType getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceAccountType result = (VoiceAccountType)super.getFromRS(rs);
        result.setNeedPhone(rs.getBoolean("needPhone"));
        result.setCheckPassword(rs.getBoolean("checkPassword"));
        result.setNeedLogin(rs.getBoolean("needLogin"));
        result.setSessionCountLimit(rs.getByte("sessionCountLimit"));
        result.setSessionCountLimitLock(rs.getBoolean("sessionCountLimitLock"));
        result.setNeedDevice(rs.getBoolean("needDevice"));
        result.setNeedPorts(rs.getBoolean("needPorts"));
        result.setNeedObject(rs.getBoolean("needObject"));
        result.setNeedLines(rs.getBoolean("needLines"));
        result.setStatusConfig(rs.getString("statusConfig"));
        return result;
    }

    @Override
    protected VoiceAccountType createAccountTypeInstance() {
        return new VoiceAccountType();
    }

    @Override
    protected int setParams(VoiceAccountType type, PreparedStatement ps, int idx) throws SQLException {
        ps.setBoolean(idx++, type.isNeedPhone());
        ps.setBoolean(idx++, type.isCheckPassword());
        ps.setBoolean(idx++, type.isNeedLogin());
        ps.setByte(idx++, type.getSessionCountLimit());
        ps.setBoolean(idx++, type.isSessionCountLimitLock());
        ps.setBoolean(idx++, type.isNeedDevice());
        ps.setBoolean(idx++, type.isNeedPorts());
        ps.setBoolean(idx++, type.isNeedObject());
        ps.setBoolean(idx++, type.isNeedLines());
        ps.setString(idx++, type.getStatusConfig());
        return idx;
    }

    @Override
    protected String fields() {
        return ", needPhone=?, checkPassword=?, needLogin=?, sessionCountLimit=?, sessionCountLimitLock=?, needDevice=?, needPorts=?, needObject=?, needLines=?, statusConfig=?";
    }
}

