/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.datalog.hourly.HourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.inet.IpAddress;

public abstract class AbstractNetflowLogParser {
    private final Setup setup;
    protected final int deviceId;

    public AbstractNetflowLogParser(Setup setup, int deviceId, int moduleId) {
        this.setup = setup;
        this.deviceId = deviceId;
    }

    public void parseHour(Date hour, int zoneDelta) throws BGException {
        try {
            FlowReader netflowReader;
            try {
                HourlyDataLogger dataLogger = (HourlyDataLogger)DefaultServerSetup.getEnvironment().lookup("flowDataLogger");
                dataLogger.flush(InetUtils.getHour(hour.getTime())).get(3L, TimeUnit.SECONDS);
            }
            catch (Exception dataLogger) {
                // empty catch block
            }
            IPHourlyDataLog netflowDataLog = new IPHourlyDataLog((ParameterMap)this.setup, "datalog.flow.dir", this.deviceId, TimeUtils.convertDateToCalendar((Date)hour));
            while ((netflowReader = (FlowReader)netflowDataLog.nextReader(null, true)) != null) {
                FlowArray flow;
                while ((flow = netflowReader.readChunk()) != null) {
                    int size = flow.size;
                    for (int i = 0; i < size; ++i) {
                        Data record = flow.array[i];
                        this.processFlow(record, record.srcAddress, record.dstAddress, 1, record.getDstPort(), record.inputInterface, record.outputInterface, zoneDelta, hour);
                        this.processFlow(record, record.dstAddress, record.srcAddress, 2, record.getSrcPort(), record.outputInterface, record.inputInterface, zoneDelta, hour);
                    }
                }
            }
            netflowDataLog.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected abstract void processFlow(Data var1, IpAddress var2, IpAddress var3, int var4, int var5, int var6, int var7, int var8, Date var9) throws BGException;
}

