/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.ActionDirectoryBase;
import bitel.billing.server.admin.bean.CommentUpdater;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractParameterGroupName;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractParameterGroupNameDao;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.common.Utils;

public class ActionUpdateDirectoryItem
extends ActionDirectoryBase {
    @Override
    public void doAction() throws Exception {
        String id = this.getParameter("id");
        String title = this.getParameter("title");
        int edit = this.getIntParameter("edit", 0);
        if (id == null || title == null) {
            throw new BGIllegalArgumentException();
        }
        int mode = this.getIntParameter("mode", -1);
        String table = this.getTable(mode);
        if (table == null) {
            throw new BGMessageException("Table not found, mode=" + mode);
        }
        if (mode == 0 || mode == 1) {
            if ("move".equals(this.getParameter("update"))) {
                this.move(this.getParameter("ids"), Utils.parseInt((String)id, (int)-1), table);
            } else {
                int type = this.getIntParameter("type", 0);
                if ("new".equals(id)) {
                    int up = this.getIntParameter("uid", -1);
                    if (up < 0) {
                        return;
                    }
                    String query = "INSERT " + table + " SET title=?, flag=?, type=?, up=?";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    ps.setString(1, title);
                    ps.setInt(2, edit);
                    ps.setInt(3, type);
                    ps.setInt(4, up);
                    ps.executeUpdate();
                    ps.close();
                } else {
                    int ID = Utils.parseInt((String)id, (int)-1);
                    if (ID < 0) {
                        return;
                    }
                    String query = "UPDATE " + table + " SET title=?, flag=?, type=? WHERE id=?";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    ps.setString(1, title);
                    ps.setInt(2, edit);
                    ps.setInt(3, type);
                    ps.setInt(4, ID);
                    ps.executeUpdate();
                    ps.close();
                }
            }
        } else if (mode == 17) {
            boolean insert = "-1".equals(id);
            String query = (insert ? "INSERT " : "UPDATE ") + table + " SET title=?, pat=?" + (insert ? "" : " WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, title);
            ps.setString(2, this.getParameter("pattern", ""));
            if (!insert) {
                ps.setString(3, id);
            }
            ps.executeUpdate();
            ps.close();
            if (!insert) {
                new RunTaskDataManager(this.con).addTask(new CommentUpdater(Utils.parseInt((String)id)));
            }
        } else if (mode == 4) {
            ContractParameterGroupName contractParameterGroupName = new ContractParameterGroupName();
            contractParameterGroupName.setId(Utils.parseInt((String)id));
            contractParameterGroupName.setTitle(title);
            new ContractParameterGroupNameDao(this.con).update((Object)contractParameterGroupName);
        } else if ("new".equals(id)) {
            String query = "INSERT " + table + " SET title =?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setString(1, title);
                ps.executeUpdate();
            }
        } else {
            int ID = Utils.parseInt((String)id, (int)-1);
            if (ID < 0) {
                return;
            }
            if (mode == 8) {
                int gid = this.getIntParameter("gid", 0);
                String query = "UPDATE " + table + " SET title=?, gid=? WHERE id=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setString(1, title);
                ps.setInt(2, gid);
                ps.setInt(3, ID);
                ps.executeUpdate();
                ps.close();
            } else {
                String query = "UPDATE " + table + " SET title=? WHERE id=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setString(1, title);
                ps.setInt(2, ID);
                ps.executeUpdate();
                ps.close();
            }
        }
    }

    public void move(String ids, int id, String table) {
        List idList = Utils.toIntegerList((String)ids);
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT up, type FROM " + table + " WHERE id=?");
            ps.setInt(1, id);
            HashSet<Integer> parentIds = new HashSet<Integer>();
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                if (rs.getInt(2) != 1) {
                    rs.close();
                    ps.close();
                    return;
                }
                int parentId = rs.getInt(1);
                while (true) {
                    parentIds.add(parentId);
                    ps.setInt(1, parentId);
                    rs = ps.executeQuery();
                    if (!rs.next()) break;
                    parentId = rs.getInt(1);
                }
                rs.close();
            } else {
                id = 0;
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("UPDATE " + table + " SET up=? WHERE id!=? AND id=?");
            ps.setInt(1, id);
            ps.setInt(2, id);
            for (Integer i : idList) {
                if (parentIds.contains(i)) continue;
                ps.setInt(3, i);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

