/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.AlarmErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationMessage;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationResult;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.server.CompilerWrapper;
import ru.bitel.bgbilling.kernel.dynamic.server.DatabaseClassLoader;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.ExcludeCompilationResources;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptSavingEvent;
import ru.bitel.bgbilling.kernel.dynamic.server.event.ScriptUpdatedEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.model.Pair;

public class ReadWriteClassManager
extends DynamicClassManager {
    private CompilerWrapper javac = new CompilerWrapper(new File(DynamicCodeDao.getScriptsDir()), new File(System.getProperty("java.io.tmpdir")));
    private final List<String> dynIgnoreClasses = this.compileIgnoreFiles();

    public ReadWriteClassManager() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ReadWriteClassManager(ClassLoader parentClassLoader) {
        super(parentClassLoader);
    }

    private List<String> compileIgnoreFiles() {
        ArrayList<String> ignoreFiles = new ArrayList<String>();
        Path dynIgnoreFile = Paths.get(new File("").getAbsolutePath(), "data", "dyn_ignore");
        if (Files.exists(dynIgnoreFile, new LinkOption[0])) {
            try (Stream<String> ignoreClasses = Files.lines(dynIgnoreFile);){
                ignoreFiles.addAll(ignoreClasses.toList());
            }
            catch (IOException e) {
                this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 dynIgnoreClasses", e);
            }
        }
        return ignoreFiles;
    }

    @Override
    protected void addListeners() throws BGException {
        EventProcessor.getInstance().addListener(new EventListener<ScriptSavingEvent>(){

            /*
             * Loose catch block
             */
            @Override
            public void notify(ScriptSavingEvent e, EventListenerContext ctx) throws BGException {
                CompilationResult result = null;
                Connection con = null;
                try {
                    con = Setup.getSetup().getDBConnectionFromPool();
                    con.setAutoCommit(false);
                    if (e.isClearTable()) {
                        new DynamicCodeDao(con).clearTables();
                    }
                    ReadWriteClassManager.this.flushLoadedClassCache();
                    Pair<CompilationResult, List<CompilerWrapper.CompiledUnit>> pair = ReadWriteClassManager.this.recompile(con, e.getClassNames(), true);
                    result = (CompilationResult)pair.getFirst();
                    List<String> classNames = ((List)pair.getSecond()).stream().map(f -> f.className).collect(Collectors.toList());
                    con.commit();
                    EventProcessor.getInstance().publish(new ScriptUpdatedEvent(classNames));
                }
                catch (CompilerWrapper.CompilationFailedException ex) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException ex1) {
                        throw new BGException((Throwable)ex1);
                    }
                    result = ex.getCompilationResult();
                    ServerUtils.closeConnection(con);
                    e.setCompilationResult(result != null ? result : new CompilationResult());
                }
                catch (Exception ex2) {
                    ReadWriteClassManager.this.logError(ex2);
                    throw new BGException((Throwable)ex2);
                    {
                        catch (Throwable throwable) {
                            ServerUtils.closeConnection(con);
                            e.setCompilationResult(result != null ? result : new CompilationResult());
                            throw throwable;
                        }
                    }
                }
                ServerUtils.closeConnection(con);
                e.setCompilationResult(result != null ? result : new CompilationResult());
            }
        }, ScriptSavingEvent.class);
    }

    public void recompileAll() {
        BGNestedContext.push((String)"script");
        try {
            this.recompileAll0();
        }
        finally {
            BGNestedContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void recompileAll0() {
        block32: {
            Connection con;
            CompilationResult result;
            Exception t;
            block29: {
                t = null;
                result = null;
                con = null;
                con = Setup.getSetup().getDBConnectionFromPool();
                con.setAutoCommit(false);
                result = this.recompileAllClasses(con);
                if (result != null && result.getErrors().size() <= 0) break block29;
                String key = "dynamic.code.recompilation.error";
                long time = System.currentTimeMillis();
                String subject = "\u041a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438!";
                StringBuilder text = new StringBuilder();
                if (result != null) {
                    text.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f API \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430: \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u0432 \u0411\u0414 \u043a\u043b\u0430\u0441\u0441\u044b \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e! \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438!\n\n");
                    for (CompilationMessage msg : result.getErrors()) {
                        text.append(msg.getMessage());
                        text.append(" at ");
                        text.append(msg.getSource());
                        text.append(" on ");
                        text.append(msg.getLine());
                        text.append(":");
                        text.append(msg.getColumn());
                        text.append("\n");
                    }
                } else {
                    text.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d!");
                }
                AlarmErrorMessage message = t != null ? new AlarmErrorMessage(key, subject, text.toString(), t) : new AlarmErrorMessage(key, subject, text.toString());
                AlarmSender.sendAlarm(message, time);
            }
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                this.logError(ex);
            }
            ServerUtils.closeConnection(con);
            break block32;
            catch (CompilerWrapper.CompilationFailedException ex) {
                block30: {
                    result = ex.getCompilationResult();
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Dynamic class recompilation FAILED: " + ex.getCompilationResult().getErrors().size() + " errors!");
                    }
                    if (result != null && result.getErrors().size() <= 0) break block30;
                    String key = "dynamic.code.recompilation.error";
                    long time = System.currentTimeMillis();
                    String subject = "\u041a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438!";
                    StringBuilder text = new StringBuilder();
                    if (result != null) {
                        text.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f API \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430: \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u0432 \u0411\u0414 \u043a\u043b\u0430\u0441\u0441\u044b \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e! \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438!\n\n");
                        for (CompilationMessage msg : result.getErrors()) {
                            text.append(msg.getMessage());
                            text.append(" at ");
                            text.append(msg.getSource());
                            text.append(" on ");
                            text.append(msg.getLine());
                            text.append(":");
                            text.append(msg.getColumn());
                            text.append("\n");
                        }
                    } else {
                        text.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d!");
                    }
                    AlarmErrorMessage message = t != null ? new AlarmErrorMessage(key, subject, text.toString(), t) : new AlarmErrorMessage(key, subject, text.toString());
                    AlarmSender.sendAlarm(message, time);
                }
                try {
                    con.rollback();
                }
                catch (SQLException ex2) {
                    this.logError(ex2);
                }
                ServerUtils.closeConnection(con);
            }
            catch (Exception ex2) {
                block31: {
                    t = ex2;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Dynamic class recompilation FAILED: " + ex2.getMessage() + "!", (Throwable)ex2);
                    }
                    if (result != null && result.getErrors().size() <= 0) break block31;
                    String key = "dynamic.code.recompilation.error";
                    long time = System.currentTimeMillis();
                    String subject = "\u041a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438!";
                    StringBuilder text = new StringBuilder();
                    if (result != null) {
                        text.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f API \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430: \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u0432 \u0411\u0414 \u043a\u043b\u0430\u0441\u0441\u044b \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e! \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438!\n\n");
                        for (CompilationMessage msg : result.getErrors()) {
                            text.append(msg.getMessage());
                            text.append(" at ");
                            text.append(msg.getSource());
                            text.append(" on ");
                            text.append(msg.getLine());
                            text.append(":");
                            text.append(msg.getColumn());
                            text.append("\n");
                        }
                    } else {
                        text.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d!");
                    }
                    AlarmErrorMessage message = t != null ? new AlarmErrorMessage(key, subject, text.toString(), t) : new AlarmErrorMessage(key, subject, text.toString());
                    AlarmSender.sendAlarm(message, time);
                }
                try {
                    con.rollback();
                }
                catch (SQLException ex3) {
                    this.logError(ex3);
                }
                ServerUtils.closeConnection(con);
                {
                    catch (Throwable throwable) {
                        if (result == null || result.getErrors().size() > 0) {
                            String key = "dynamic.code.recompilation.error";
                            long time = System.currentTimeMillis();
                            String subject = "\u041a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u044f \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043b\u0430\u0441\u0441\u043e\u0432 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442 \u0441 \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438!";
                            StringBuilder text = new StringBuilder();
                            if (result != null) {
                                text.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b! \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043e\u0448\u0438\u0431\u043a\u0438 \u043f\u043e\u044f\u0432\u0438\u043b\u0438\u0441\u044c \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f API \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430: \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0435 \u0432 \u0411\u0414 \u043a\u043b\u0430\u0441\u0441\u044b \u043c\u043e\u0433\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e! \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0432\u0440\u0443\u0447\u043d\u0443\u044e \u043f\u0435\u0440\u0435\u043a\u043e\u043c\u043f\u0438\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432\u0441\u0435 \u0434\u0438\u043d\u0430\u043c\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u044b \u0438 \u0438\u0441\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043e\u0448\u0438\u0431\u043a\u0438!\n\n");
                                for (CompilationMessage msg : result.getErrors()) {
                                    text.append(msg.getMessage());
                                    text.append(" at ");
                                    text.append(msg.getSource());
                                    text.append(" on ");
                                    text.append(msg.getLine());
                                    text.append(":");
                                    text.append(msg.getColumn());
                                    text.append("\n");
                                }
                            } else {
                                text.append("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d!");
                            }
                            AlarmErrorMessage message = t != null ? new AlarmErrorMessage(key, subject, text.toString(), t) : new AlarmErrorMessage(key, subject, text.toString());
                            AlarmSender.sendAlarm(message, time);
                        }
                        try {
                            con.rollback();
                        }
                        catch (SQLException ex4) {
                            this.logError(ex4);
                        }
                        ServerUtils.closeConnection(con);
                        throw throwable;
                    }
                }
            }
        }
    }

    private Pair<CompilationResult, List<CompilerWrapper.CompiledUnit>> recompile(Connection con, List<String> targetClassNames, boolean needConnectionCommit) throws BGException {
        DynamicCodeDao dao = new DynamicCodeDao(con);
        ArrayList<File> srcFiles = new ArrayList<File>();
        for (String name : targetClassNames) {
            if (!DynamicClass.isJavaSource(name)) continue;
            if (ExcludeCompilationResources.getInstance(false).classIsExclude(name)) {
                this.getLogger().debug("\u041a\u043b\u0430\u0441\u0441: {} \u0438\u0441\u043a\u043b\u044e\u0447\u0451\u043d \u0438\u0437 \u043a\u043e\u043c\u043f\u0438\u043b\u044f\u0446\u0438\u0438!", (Object)name);
                continue;
            }
            String simpleClassName = name.substring(name.lastIndexOf(46) + 1) + ".java";
            if (this.dynIgnoreClasses.contains(simpleClassName)) continue;
            srcFiles.add(DynamicCodeDao.getClassFile(name));
        }
        if (srcFiles.isEmpty()) {
            return new Pair((Object)new CompilationResult(), Collections.emptyList());
        }
        Pair<CompilationResult, List<CompilerWrapper.CompiledUnit>> result = this.javac.compile(srcFiles);
        List units = (List)result.getSecond();
        DatabaseClassLoader loader = new DatabaseClassLoader(this.parentClassLoader);
        for (CompilerWrapper.CompiledUnit unit : units) {
            try {
                dao.updateClassData(unit.className, Files.readAllBytes(unit.classFile.toPath()), unit.srcFile.lastModified());
            }
            catch (Exception ex) {
                throw new BGException(unit.className + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (needConnectionCommit) {
            ServerUtils.commitConnection(con);
        }
        this.javac.deleteClassDir();
        for (CompilerWrapper.CompiledUnit unit : units) {
            try {
                Class<?> loaded = loader.loadClass(unit.className);
                this.addLoadedClass(unit.className, loaded);
                dao.updateClassInterfaces(loaded);
            }
            catch (ClassNotFoundException e) {
                throw new BGException(unit.className + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                throw new BGException(unit.className + ": " + e.getMessage(), e);
            }
        }
        return result;
    }

    public CompilationResult recompileAllClasses(Connection con) throws Exception {
        DynamicCodeDao dao = new DynamicCodeDao(con);
        dao.clearTables();
        this.flushLoadedClassCache();
        List<String> classes = dao.getDynamicClasses().stream().map(DynamicClass::getClassName).collect(Collectors.toList());
        Pair<CompilationResult, List<CompilerWrapper.CompiledUnit>> pair = this.recompile(con, classes, false);
        CompilationResult result = (CompilationResult)pair.getFirst();
        this.getLogger().debug("Dynamic class recompilation OK!");
        return result;
    }
}

