/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseProduct;
import ru.bitel.common.model.Id;

public class LicenseProductDao
extends AbstractIdDao<LicenseProduct> {
    public LicenseProductDao(Connection con, int moduleId) {
        super(con, moduleId, "lic_product");
    }

    public List<LicenseProduct> list() throws SQLException {
        return this.listImpl(null, null, "id", new Object[0]);
    }

    public List<LicenseProduct> getProductsWithComponent(int componentId) throws SQLException {
        ArrayList<LicenseProduct> products = new ArrayList<LicenseProduct>();
        String query = "SELECT  id, title, version, lu  FROM " + this.tableName + " t1  JOIN  lic_product_component_" + this.moduleId + " t2 ON t1.id=t2.product_id  WHERE t2.component_id=? ORDER BY  title ";
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ps.setInt(1, componentId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    products.add(this.getFromRS(rs));
                }
            }
        }
        return products;
    }

    protected LicenseProduct getFromRS(ResultSet rs) throws SQLException {
        return new LicenseProduct(rs.getInt("id"), (Date)rs.getDate("lu")).setTitle(rs.getString("title")).setVersion(rs.getString("version"));
    }

    protected void updateImpl(LicenseProduct product) throws SQLException {
        String querySet = "title=?, version=?";
        try (PreparedStatement ps = this.prepareStatement((Id)product, querySet);){
            int index = 1;
            ps.setString(index++, product.getTitle());
            ps.setString(index++, product.getVersion());
            this.executeUpdate((Id)product, index, ps);
        }
    }
}

