/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.server;

import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWrapEvent;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoLogin;
import ru.bitel.bgbilling.modules.trayinfo.server.bean.TrayInfoLoginManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class Module
extends ModuleBase {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.trayinfo.server"};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void serializeContract(Connection con, int cid, int mid, XMLStreamWriter tables, boolean onlyCurrent) throws SQLException, XMLStreamException {
        ServerUtils.addItemsFromRS((Connection)con, (XMLStreamWriter)tables, (String)("trayinfo_login_" + mid), (String)"cid", (String)String.valueOf(cid), null, (boolean)onlyCurrent, (String)"date1", (String)"date2");
    }

    public void moduleAction(ServerContext ctx, int mid, Event event) throws Exception {
        if (event instanceof ContractDeleteEvent) {
            ContractDeleteEvent cdEvent = (ContractDeleteEvent)event;
            if (!cdEvent.isCheck()) {
                ServerUtils.deleteRowsFromTable((Connection)ctx.getConnection(), (String)("trayinfo_login_" + mid), (String)"cid", (String)String.valueOf(event.getContractId()), null);
            }
        } else if (event instanceof ContractCloseEvent) {
            ContractCloseEvent cEvent = (ContractCloseEvent)event;
            Connection con = ctx.getConnection();
            if (!cEvent.isCheck()) {
                String query = "UPDATE trayinfo_login_" + mid + " SET date2=? WHERE cid=? AND date2 IS NULL";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)cEvent.getDate()));
                ps.setInt(2, event.getContractId());
                ps.executeUpdate();
                ps.close();
            }
        } else if (event instanceof ContractWrapEvent) {
            ContractWrapEvent cwEvent = (ContractWrapEvent)event;
            Connection con = ctx.getConnection();
            if (!cwEvent.isCheck()) {
                TrayInfoLoginManager manager = new TrayInfoLoginManager(con, mid);
                Date dateClose = cwEvent.getDateClose();
                Date dateOpen = cwEvent.getDateOpen();
                for (TrayInfoLogin login : manager.getContractLoginsList(cwEvent.getContractId())) {
                    if (login.getDate2() != null && TimeUtils.dateBeforeOrEq((Date)login.getDate2(), (Date)dateClose)) continue;
                    manager.updateTrayInfoLogin(login.getLogin(), login.getPassword(), login.getDate1(), dateClose);
                    manager.addTrayInfoLogin(cwEvent.getToContractId(), login.getPassword(), dateOpen, login.getDate2());
                }
            }
        }
    }
}

